/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.integration.patchouli.processor;

import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorFusionRecipe
implements IComponentProcessor {
    public static final NumberFormat ENERGY_FORMAT = new DecimalFormat("#,##0");
    IFusionRecipe fusionRecipe;

    public void setup(IVariableProvider<String> variables) {
        ItemStack output = PatchouliAPI.instance.deserializeItemStack((String)variables.get("output"));
        this.fusionRecipe = RecipeManager.FUSION_REGISTRY.getRecipes().stream().filter(recipe -> recipe.getRecipeOutput(ItemStack.field_190927_a).func_77969_a(output)).findFirst().orElse(null);
    }

    public String process(String key) {
        if (this.fusionRecipe != null) {
            if (key.equals("catalyst")) {
                return PatchouliAPI.instance.serializeItemStack(this.fusionRecipe.getRecipeCatalyst());
            }
            if (key.equals("tier")) {
                return I18n.func_74838_a((String)("gui.jeiFusion.tier." + this.fusionRecipe.getRecipeTier()));
            }
            if (key.equals("tier_color")) {
                int tier = this.fusionRecipe.getRecipeTier();
                return tier == 0 ? "5050FF" : (tier == 1 ? "8000FF" : (tier == 2 ? "FF6600" : "505050"));
            }
            if (key.equals("energy")) {
                return ENERGY_FORMAT.format(this.fusionRecipe.getIngredientEnergyCost() * (long)this.fusionRecipe.getRecipeIngredients().size()) + " RF";
            }
        }
        return null;
    }
}

