/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiPackagerExtension;
import thelm.packagedauto.container.ContainerPackagerExtension;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.networking.HostHelperTilePackagerExtension;
import thelm.packagedauto.inventory.InventoryPackagerExtension;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TileUnpackager;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TilePackagerExtension
extends TileBase
implements ITickable,
ISettingsCloneable,
IGridHost,
IActionHost {
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public TilePackager packager;
    public IInventory listStackInventory = new InventoryBasic("Recipe List", false, 1);
    public List<IPackagePattern> patternList = new ArrayList<IPackagePattern>();
    public IPackagePattern currentPattern;
    public boolean lockPattern = false;
    public TilePackager.Mode mode = TilePackager.Mode.EXACT;
    public boolean disjoint = false;
    public boolean powered = false;
    public boolean firstTick = true;
    public HostHelperTilePackagerExtension hostHelper;

    public TilePackagerExtension() {
        this.setInventory(new InventoryPackagerExtension(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTilePackagerExtension(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.packager_extension.name");
    }

    @Override
    public String getConfigTypeName() {
        return "tile.packagedauto.packager.name";
    }

    public void onLoad() {
        this.updatePowered();
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            this.updatePatternList();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isInputValid()) {
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive() && !this.inventory.func_70301_a(9).func_190926_b()) {
                        this.hostHelper.ejectItem();
                    } else if (!this.inventory.func_70301_a(9).func_190926_b()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    if (!this.inventory.func_70301_a(9).func_190926_b()) {
                        this.hostHelper.ejectItem();
                    }
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else if (!this.inventory.func_70301_a(9).func_190926_b()) {
                    this.ejectItem();
                }
            }
        }
    }

    public boolean isInputValid() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            return false;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return false;
        }
        if (!this.lockPattern && this.disjoint) {
            return MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), true);
        }
        List matchers = Lists.transform(this.currentPattern.getInputs(), TilePackager::getIngredient);
        int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
        if (matches == null) {
            return false;
        }
        for (int i = 0; i < matches.length; ++i) {
            if (input.get(i).func_190916_E() >= this.currentPattern.getInputs().get(matches[i]).func_190916_E()) continue;
            return false;
        }
        return true;
    }

    protected boolean canStart() {
        this.getPattern();
        if (this.currentPattern == null) {
            return false;
        }
        if (!this.isInputValid()) {
            return false;
        }
        ItemStack slotStack = this.inventory.func_70301_a(9);
        ItemStack outputStack = this.currentPattern.getOutput();
        return slotStack.func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + 1 <= outputStack.func_77976_d();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isInputValid();
    }

    protected void getPattern() {
        if (this.currentPattern != null && this.lockPattern) {
            return;
        }
        this.lockPattern = false;
        this.currentPattern = null;
        if (this.powered) {
            return;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return;
        }
        for (IPackagePattern pattern : this.patternList) {
            if (this.disjoint) {
                if (!MiscUtil.removeExactSet(input, pattern.getInputs(), true)) continue;
                this.currentPattern = pattern;
                return;
            }
            List matchers = Lists.transform(pattern.getInputs(), TilePackager::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) continue;
            this.currentPattern = pattern;
            return;
        }
    }

    public void updatePatternList() {
        this.packager = null;
        this.listStackInventory.func_174888_l();
        this.patternList.clear();
        if (this.field_145850_b != null) {
            for (BlockPos posP : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
                TileEntity te = this.field_145850_b.func_175625_s(posP);
                if (!(te instanceof TilePackager)) continue;
                this.packager = (TilePackager)te;
                ItemStack listStack = this.packager.inventory.func_70301_a(10);
                this.listStackInventory.func_70299_a(0, listStack);
                this.patternList.addAll(this.packager.patternList);
                switch (this.mode) {
                    case EXACT: {
                        this.disjoint = false;
                        break;
                    }
                    case DISJOINT: {
                        this.disjoint = MiscUtil.arePatternsDisjoint(this.patternList);
                        break;
                    }
                    case FIRST: {
                        this.disjoint = true;
                    }
                }
                break;
            }
        }
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            this.endProcess();
            return;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            this.endProcess();
            return;
        }
        if (!this.lockPattern && this.disjoint) {
            if (!MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), true)) {
                this.endProcess();
                return;
            }
            if (this.inventory.func_70301_a(9).func_190926_b()) {
                this.inventory.func_70299_a(9, this.currentPattern.getOutput());
            } else if (this.inventory.func_70301_a(9).func_77973_b() instanceof IPackageItem) {
                this.inventory.func_70301_a(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), false);
        } else {
            List matchers = Lists.transform(this.currentPattern.getInputs(), TilePackager::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) {
                this.endProcess();
                return;
            }
            if (this.inventory.func_70301_a(9).func_190926_b()) {
                this.inventory.func_70299_a(9, this.currentPattern.getOutput());
            } else if (this.inventory.func_70301_a(9).func_77973_b() instanceof IPackageItem) {
                this.inventory.func_70301_a(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            for (int i = 0; i < matches.length; ++i) {
                input.get(i).func_190918_g(this.currentPattern.getInputs().get(matches[i]).func_190916_E());
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    protected void startProcess() {
        this.remainingProgress = energyReq;
        this.func_70296_d();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.lockPattern = false;
        this.func_70296_d();
    }

    protected void ejectItem() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(te instanceof TileUnpackager)) continue;
            TileUnpackager tile = (TileUnpackager)te;
            ItemStack stack = this.inventory.func_70301_a(9);
            if (stack.func_190926_b()) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            this.inventory.func_70299_a(9, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.inventory.func_70301_a(10);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(10, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.func_70301_a(9).func_190926_b()) {
            return 15;
        }
        return 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public boolean canPushPattern() {
        return !this.isWorking && this.inventory.stacks.subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        this.mode = TilePackager.Mode.values()[nbt.func_74771_c("Mode")];
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        List<IRecipeInfo> recipeList;
        nbt.func_74774_a("Mode", (byte)this.mode.ordinal());
        ItemStack listStack = this.listStackInventory.func_70301_a(0);
        if (listStack.func_77973_b() instanceof IRecipeListItem && !(recipeList = ((IRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList()).isEmpty()) {
            nbt.func_74782_a("Recipes", (NBTBase)MiscUtil.writeRecipeListToNBT(new NBTTagList(), recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        IRecipeInfo recipe;
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        this.mode = TilePackager.Mode.values()[nbt.func_74771_c("Mode")];
        super.func_145839_a(nbt);
        this.updatePatternList();
        this.isWorking = nbt.func_74767_n("Working");
        this.remainingProgress = nbt.func_74762_e("Progress");
        this.powered = nbt.func_74767_n("Powered");
        this.lockPattern = false;
        this.currentPattern = null;
        if (nbt.func_74764_b("Pattern") && (recipe = MiscUtil.readRecipeFromNBT(tag = nbt.func_74775_l("Pattern"))) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.func_74771_c("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
                this.lockPattern = true;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Mode", (byte)this.mode.ordinal());
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Progress", this.remainingProgress);
        nbt.func_74757_a("Powered", this.powered);
        if (this.lockPattern) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), this.currentPattern.getRecipeInfo());
            tag.func_74774_a("Index", (byte)this.currentPattern.getIndex());
            nbt.func_74782_a("Pattern", (NBTBase)tag);
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void changePackagingMode() {
        this.mode = TilePackager.Mode.values()[(this.mode.ordinal() + 1) % 3];
        this.updatePatternList();
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.isWorking && !this.isInputValid()) {
            this.endProcess();
        }
        super.func_70296_d();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiPackagerExtension(new ContainerPackagerExtension(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerPackagerExtension(player.field_71071_by, this);
    }
}

