/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.item.ItemDistributorMarker;
import thelm.packagedauto.item.ItemProxyMarker;

public class WorldOverlayRenderer {
    public static final WorldOverlayRenderer INSTANCE = new WorldOverlayRenderer();
    public static final Vec3d BLOCK_SIZE = new Vec3d(1.0, 1.0, 1.0);
    private Minecraft mc;
    private List<DirectionalMarkerInfo> directionalMarkers = new LinkedList<DirectionalMarkerInfo>();
    private List<SizedMarkerInfo> sizedMarkers = new LinkedList<SizedMarkerInfo>();
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private WorldOverlayRenderer() {
    }

    public void onConstruct() {
        this.mc = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.mc.field_71441_e == null || this.mc.field_71439_g == null || this.mc.func_147113_T()) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            DirectionalGlobalPos globalPos;
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (stack.func_77973_b() == ItemDistributorMarker.INSTANCE && (globalPos = ItemDistributorMarker.INSTANCE.getDirectionalGlobalPos(stack)) != null) {
                this.addDirectionalMarkers(Collections.singletonList(globalPos), 65535, 1);
            }
            if (stack.func_77973_b() != ItemProxyMarker.INSTANCE || (globalPos = ItemProxyMarker.INSTANCE.getDirectionalGlobalPos(stack)) == null) continue;
            this.addDirectionalMarkers(Collections.singletonList(globalPos), 0xFF7F00, 1);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.getPartialTicks());
    }

    public void addDirectionalMarkers(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.directionalMarkers.add(new DirectionalMarkerInfo(positions, color, lifetime));
    }

    public void addSizedMarker(Vec3d lowerCorner, Vec3d size, int color, int lifetime) {
        this.sizedMarkers.add(new SizedMarkerInfo(lowerCorner, size, color, lifetime));
    }

    public void addBeams(Vec3d source, List<Vec3d> deltas, int color, int lifetime, boolean fadeout) {
        this.beams.add(new BeamInfo(source, deltas, color, lifetime, fadeout));
    }

    public void render(float partialTick) {
        int g;
        int r;
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.directionalMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.sizedMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + partialTick;
        double viewerPosX = this.mc.func_175598_ae().field_78730_l;
        double viewerPosY = this.mc.func_175598_ae().field_78731_m;
        double viewerPosZ = this.mc.func_175598_ae().field_78728_n;
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)4.0f);
        GlStateManager.func_179097_i();
        for (DirectionalMarkerInfo directionalMarkerInfo : this.directionalMarkers) {
            int r2 = directionalMarkerInfo.color >> 16 & 0xFF;
            int g2 = directionalMarkerInfo.color >> 8 & 0xFF;
            int b = directionalMarkerInfo.color & 0xFF;
            for (DirectionalGlobalPos globalPos : directionalMarkerInfo.positions) {
                if (globalPos.dimension() != this.mc.field_71441_e.field_73011_w.getDimension()) continue;
                int range = 64;
                BlockPos blockPos = globalPos.blockPos();
                double distX = viewerPosX - (double)blockPos.func_177958_n() - 0.5;
                double distY = viewerPosY - (double)blockPos.func_177956_o() - 0.5;
                double distZ = viewerPosZ - (double)blockPos.func_177952_p() - 0.5;
                if (Doubles.max((double[])new double[]{Math.abs(distX), Math.abs(distY), Math.abs(distZ)}) > (double)range) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)blockPos.func_177958_n() - viewerPosX), (double)((double)blockPos.func_177956_o() - viewerPosY), (double)((double)blockPos.func_177952_p() - viewerPosZ));
                EnumFacing direction = globalPos.direction();
                this.drawMarker(BLOCK_SIZE, direction, r2, g2, b, 127);
                this.drawMarker(BLOCK_SIZE, null, r2, g2, b, 255);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179126_j();
        for (SizedMarkerInfo sizedMarkerInfo : this.sizedMarkers) {
            Vec3d lowerCorner = sizedMarkerInfo.lowerCorner;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(lowerCorner.field_72450_a - viewerPosX), (double)(lowerCorner.field_72448_b - viewerPosY), (double)(lowerCorner.field_72449_c - viewerPosZ));
            r = sizedMarkerInfo.color >> 16 & 0xFF;
            g = sizedMarkerInfo.color >> 8 & 0xFF;
            int b = sizedMarkerInfo.color & 0xFF;
            this.drawMarker(sizedMarkerInfo.size, null, r, g, b, 255);
            GlStateManager.func_179121_F();
        }
        GL11.glLineWidth((float)3.0f);
        for (BeamInfo beamInfo : this.beams) {
            Vec3d source = beamInfo.source;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(source.field_72450_a - viewerPosX), (double)(source.field_72448_b - viewerPosY), (double)(source.field_72449_c - viewerPosZ));
            r = beamInfo.color >> 16 & 0xFF;
            g = beamInfo.color >> 8 & 0xFF;
            int b = beamInfo.color & 0xFF;
            int a = (int)(beamInfo.getAlpha(renderTick) * 255.0f);
            for (Vec3d delta : beamInfo.deltas) {
                this.drawBeam(delta, r, g, b, a);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    public void drawMarker(Vec3d delta, EnumFacing direction, int r, int g, int b, int a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        buffer.func_181668_a(direction == null ? 1 : 7, DefaultVertexFormats.field_181706_f);
        if (direction == null || direction == EnumFacing.NORTH) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.SOUTH) {
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.WEST) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.EAST) {
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == EnumFacing.DOWN) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == EnumFacing.UP) {
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        if (direction == null) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public void drawBeam(Vec3d delta, int r, int g, int b, int a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static class BeamInfo {
        private Vec3d source;
        private List<Vec3d> deltas;
        private int color;
        private int lifetime;
        private int startTick;
        private boolean fadeout;

        public BeamInfo(Vec3d source, List<Vec3d> deltas, int color, int lifetime, boolean fadeout) {
            this.source = source;
            this.deltas = deltas;
            this.color = color;
            this.lifetime = lifetime;
            this.fadeout = fadeout;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }

        public float getAlpha(float renderTick) {
            if (!this.fadeout) {
                return 1.0f;
            }
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = Math.min(diff / (float)this.lifetime, 1.0f);
            return 1.0f - factor * factor;
        }
    }

    public static class SizedMarkerInfo {
        private Vec3d lowerCorner;
        private Vec3d size;
        private int color;
        private int lifetime;
        private int startTick;

        public SizedMarkerInfo(Vec3d lowerCorner, Vec3d size, int color, int lifetime) {
            this.lowerCorner = lowerCorner;
            this.size = size;
            this.color = color;
            this.lifetime = lifetime;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public static class DirectionalMarkerInfo {
        private List<DirectionalGlobalPos> positions;
        private int color;
        private int lifetime;
        private int startTick;

        public DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime) {
            this.positions = positions;
            this.color = color;
            this.lifetime = lifetime;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }
}

