/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCTextures;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.lib.ScissorHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ImageElement
extends MDElementBase<ImageElement> {
    private static final Random rand = new Random();
    private static final List<Block> LOADING_BLOCKS = Lists.newArrayList((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150349_c, Blocks.field_150347_e, Blocks.field_150364_r, Blocks.field_150359_w, Blocks.field_150391_bh, Blocks.field_150486_ae, Blocks.field_150381_bn, Blocks.field_150462_ai, Blocks.field_150467_bQ, Blocks.field_150461_bJ, Blocks.field_150342_X, Blocks.field_150482_ag, Blocks.field_150343_Z, Blocks.field_150346_d, Blocks.field_150367_z, Blocks.field_150460_al, Blocks.field_150407_cf});
    private ItemStack renderLoadingStack = ItemStack.field_190927_a;
    private int loadingTime = 0;
    private int maxLoadTime = 40;
    private boolean downloading = false;
    private MDElementContainer container;
    private String imageURL;
    private DLResourceLocation resourceLocation;
    public String linkTo = "";

    public ImageElement(MDElementContainer container, String imageURL) {
        this.container = container;
        this.imageURL = imageURL;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.resourceLocation = DLRSCache.getResource(this.imageURL);
        int w = 0;
        int h = 0;
        if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
            w = 76;
            h = 76;
            this.downloading = true;
        } else {
            if (this.width == -1 && this.height == -1) {
                this.width = 32;
            }
            if (this.width != -1) {
                int n = w = this.screenRelativeSize ? (int)(MathHelper.clip((double)((double)this.width / 100.0), (double)0.0, (double)1.0) * (double)layout.getWidth()) : MathHelper.clip((int)this.width, (int)8, (int)layout.getWidth());
                if (this.height == -1) {
                    h = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.height / (double)this.resourceLocation.width * (double)w) : w;
                }
            }
            if (this.height != -1) {
                h = this.height;
                if (this.width == -1) {
                    w = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.width / (double)this.resourceLocation.height * (double)this.height) : this.height;
                }
            }
        }
        this.setSize(w, h);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.downloading) {
            this.renderDownloading(partialTicks);
        } else {
            ResourceHelperBC.bindTexture(this.resourceLocation);
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.hasColourBorder) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.getColourBorder(mouseOver));
            } else if (this.hasColourBorderHover && mouseOver) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.colourBorderHover);
            }
            int w = this.xSize() - this.rightPad - this.leftPad;
            int h = this.ySize() - this.bottomPad - this.topPad;
            GlStateManager.func_179147_l();
            this.container.drawModalRectWithCustomSizedTexture(this.xPos() + this.leftPad, this.yPos() + this.topPad, 0.0, 0.0, w, h, w, h);
            GlStateManager.func_179084_k();
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    private void renderDownloading(float partialTicks) {
        boolean failed = this.resourceLocation.dlFailed;
        float failTicks = failed ? 0.0f : partialTicks;
        this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, failed ? -65536 : -16711936);
        double anim = 74.0 * ((double)((float)this.loadingTime + failTicks) / (double)this.maxLoadTime);
        this.bindTexture(BCTextures.MODULAR_GUI);
        double texAnim = Math.max(0.0, (1.0 - anim / 64.0) * 48.0);
        double texX = (double)this.xPos() + (double)this.xSize() / 2.0 - 20.0;
        double texY = Math.max((double)(this.yPos() - 48) + (48.0 - texAnim) * 2.0, (double)this.yPos());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 200.0));
        this.drawScaledCustomSizeModalRect(texX, texY + 1.0, failed ? 20.0 : 0.0, 18.0 + (24.0 - Math.min(24.0, 48.0 - texAnim)), 20.0, Math.min(Math.min(24.0, 48.0 - texAnim), texAnim), 40.0, Math.min(Math.min(48.0, (48.0 - texAnim) * 2.0), texAnim * 2.0), 256.0, 256.0);
        GlStateManager.func_179137_b((double)((double)this.xPos() + (double)this.xSize() / 2.0), (double)(this.yPos() + this.ySize() - 32), (double)0.0);
        GlStateManager.func_179114_b((float)(((float)BCClientEventHandler.elapsedTicks + partialTicks) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-64.0f, (float)-64.0f, (float)-64.0f);
        GlStateManager.func_179114_b((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ScissorHelper.pushGuiScissor(this.mc, this.xPos(), (double)this.maxYPos() - anim, this.xSize(), anim, this.screenWidth, this.screenHeight);
        RenderHelper.func_74519_b();
        GlStateManager.func_179094_E();
        double shrink = 1.0 - MathHelper.clip((double)((anim - 64.0) / 10.0), (double)0.0, (double)1.0);
        GlStateManager.func_179139_a((double)shrink, (double)shrink, (double)shrink);
        this.mc.func_175599_af().func_181564_a(this.renderLoadingStack, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        ScissorHelper.popScissor();
        Cuboid6 cuboid6 = new Cuboid6(-0.251, -0.251, -0.251, 0.251, 0.251, 0.251);
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (failed) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderUtils.drawCuboidOutline((Cuboid6)cuboid6);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)this.fontRenderer.field_78291_n, (float)this.fontRenderer.field_78292_o, (float)this.fontRenderer.field_78306_p, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.linkTo.isEmpty() && this.container.linkDisplayTarget != null) {
                MGuiElementBase e = this.container.linkDisplayTarget;
                int width = this.fontRenderer.func_78256_a(this.linkTo);
                int height = this.fontRenderer.func_78267_b(this.linkTo, e.xSize()) + 4;
                this.zOffset += (double)this.container.linkDisplayZOffset;
                this.drawColouredRect(e.xPos(), e.maxYPos() - height, Math.min(Math.max(width + 4, e.xSize() / 2), e.xSize()), height, -1879048192);
                this.drawSplitString(this.fontRenderer, this.linkTo, e.xPos() + 2, e.maxYPos() - height + 2, e.xSize(), 0xC0C0C0, false);
                this.zOffset -= (double)this.container.linkDisplayZOffset;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.resourceLocation.dlFailed) {
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.bc.downloading_image_failed.info", (Object[])new Object[0]));
            } else if (!this.resourceLocation.dlFinished) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.bc.downloading_image.info", (Object[])new Object[0]));
            }
            if (this.enableTooltip && !this.tooltip.isEmpty()) {
                tooltip.addAll(this.tooltip);
            }
            if (!tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (mouseButton == 0 && GuiScreen.func_146272_n()) {
                DLRSCache.clearResourceCache(this.imageURL);
                DLRSCache.clearFileCache(this.imageURL);
                this.container.layoutMarkdownElements();
                this.loadingTime = 0;
                return true;
            }
            if (mouseButton != 1 && !this.linkTo.isEmpty()) {
                this.container.handleLinkClick(this.linkTo, mouseButton);
                return true;
            }
            if (mouseButton == 1) {
                this.container.handleLinkClick(this.imageURL, mouseButton);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onUpdate() {
        if (this.resourceLocation != null) {
            if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed || this.loadingTime > 0) {
                if (this.loadingTime == 0) {
                    this.renderLoadingStack = new ItemStack(LOADING_BLOCKS.get(rand.nextInt(LOADING_BLOCKS.size())));
                }
                ++this.loadingTime;
                if (this.resourceLocation.dlFailed && this.loadingTime == this.maxLoadTime / 2) {
                    this.loadingTime = this.maxLoadTime / 2 - 1;
                }
                if (this.loadingTime >= this.maxLoadTime) {
                    this.loadingTime = 0;
                }
                if (this.resourceLocation.dlStateChanged()) {
                    this.container.getTopLevelContainer().layoutMarkdownElements();
                    this.downloading = false;
                    return true;
                }
            } else if (this.downloading) {
                this.loadingTime = 0;
                this.downloading = false;
                this.container.getTopLevelContainer().layoutMarkdownElements();
                return true;
            }
        }
        return super.onUpdate();
    }
}

