/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.tile.TileBase;

public class InventoryTileBase
implements ISidedInventory {
    public final NonNullList<ItemStack> stacks;
    public final TileBase tile;
    public int[] slots;
    protected Map<EnumFacing, IItemHandlerModifiable> wrapperMap = new IdentityHashMap<EnumFacing, IItemHandlerModifiable>(7);

    public InventoryTileBase(TileBase tile, int size) {
        this.tile = tile;
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.slots = IntStream.range(0, size).toArray();
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.stacks.size() ? (ItemStack)this.stacks.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return Items.field_190931_a.func_77639_j();
    }

    public void func_70296_d() {
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    public void syncTile(boolean rerender) {
        if (this.tile != null) {
            this.tile.syncTile(rerender);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.tile != null) {
            BlockPos pos = this.tile.func_174877_v();
            return this.tile.func_145831_w().func_175625_s(pos) == this.tile && pos.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 64.0;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public String func_70005_c_() {
        return this.tile != null ? this.tile.func_70005_c_() : "[null]";
    }

    public boolean func_145818_k_() {
        return this.tile != null && this.tile.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.tile != null ? this.tile.func_145748_c_() : new TextComponentString("[null]");
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.stacks.clear();
        MiscUtil.loadAllItems(nbt.func_150295_c("Items", 10), this.stacks, "Slot");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)MiscUtil.saveAllItems(new NBTTagList(), this.stacks, "Slot"));
        return nbt;
    }

    public IItemHandlerModifiable getWrapperForDirection(EnumFacing direction) {
        return this.wrapperMap.computeIfAbsent(direction, f -> new SidedInvWrapper((ISidedInventory)this, f));
    }
}

