/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import java.util.Objects;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class PackageCraftingPatternHelper
implements ICraftingPatternDetails {
    public final IPackagePattern pattern;
    public final ItemStack definition;
    public final IAEItemStack[] inputs;
    public final IAEItemStack[] outputs;
    public final IAEItemStack[] condensedInputs;
    public final IAEItemStack[] condensedOutputs;

    public PackageCraftingPatternHelper(IPackagePattern pattern) {
        this.pattern = pattern;
        this.definition = pattern.getOutput();
        this.definition.func_77978_p().func_74778_a("PatternType", "package");
        IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        this.inputs = (IAEItemStack[])pattern.getInputs().stream().map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.outputs = new IAEItemStack[]{(IAEItemStack)storageChannel.createStack((Object)pattern.getOutput())};
        this.condensedInputs = AppEngUtil.condenseStacks(this.inputs);
        this.condensedOutputs = (IAEItemStack[])this.outputs.clone();
    }

    public ItemStack getPattern() {
        return this.definition;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public boolean canSubstitute() {
        return true;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageCraftingPatternHelper) {
            PackageCraftingPatternHelper other = (PackageCraftingPatternHelper)obj;
            return this.pattern.getIndex() == other.pattern.getIndex() && this.pattern.getRecipeInfo().equals(other.pattern.getRecipeInfo());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pattern.getIndex(), this.pattern.getRecipeInfo());
    }
}

