/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.EffectTrackerFusionCrafting;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;
import thelm.packagedauto.tile.TileUnpackager;
import thelm.packageddraconic.client.gui.GuiFusionCrafter;
import thelm.packageddraconic.client.sound.FusionCrafterRotationSound;
import thelm.packageddraconic.container.ContainerFusionCrafter;
import thelm.packageddraconic.integration.appeng.networking.HostHelperTileFusionCrafter;
import thelm.packageddraconic.inventory.InventoryFusionCrafter;
import thelm.packageddraconic.packet.PacketSyncCrafter;
import thelm.packageddraconic.recipe.IRecipeInfoFusion;
import thelm.packageddraconic.tile.TileMarkedInjector;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileFusionCrafter
extends TileBase
implements ITickable,
IPackageCraftingMachine,
IFusionCraftingInventory,
IGridHost,
IActionHost {
    public static int energyCapacity = 5000;
    public static int energyUsage = 5;
    public static boolean drawMEEnergy = true;
    public IFusionRecipe effectRecipe;
    @SideOnly(value=Side.CLIENT)
    public LinkedList<EffectTrackerFusionCrafting> effects;
    public double effectRotation;
    public boolean allLocked;
    public int[] requiredInjectors = new int[]{0, 0, 0, 0};
    public boolean isWorking = false;
    public short progress = 0;
    public int craftRate = 0;
    public IRecipeInfoFusion currentRecipe;
    public List<BlockPos> injectors = new ArrayList<BlockPos>();
    public HostHelperTileFusionCrafter hostHelper;

    public TileFusionCrafter() {
        this.setInventory(new InventoryFusionCrafter(this));
        this.setEnergyStorage(new EnergyStorage((TileBase)this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileFusionCrafter(this);
        }
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packageddraconic.fusion_crafter.name");
    }

    public ITextComponent getMessage() {
        if (this.isWorking) {
            return null;
        }
        TextComponentTranslation message = new TextComponentTranslation("tile.packageddraconic.fusion_crafter.injectors.usable", new Object[0]);
        TextComponentString usable = new TextComponentString(" ");
        for (int i2 = 0; i2 <= 3; ++i2) {
            int usableInjectors = this.getEmptyInjectorsForTier(i2).size();
            if (usableInjectors <= 0) continue;
            if (!usable.func_150253_a().isEmpty()) {
                usable.func_150258_a(", ");
            }
            usable.func_150257_a((ITextComponent)new TextComponentTranslation("tile.packageddraconic.fusion_crafter.injectors." + i2, new Object[]{usableInjectors}));
        }
        if (usable.func_150253_a().isEmpty()) {
            message.func_150258_a(" 0");
        } else {
            message.func_150258_a("\n");
            message.func_150257_a((ITextComponent)usable);
        }
        if (Arrays.stream(this.requiredInjectors).anyMatch(i -> i > 0)) {
            message.func_150258_a("\n");
            message.func_150257_a((ITextComponent)new TextComponentTranslation("tile.packageddraconic.fusion_crafter.injectors.required", new Object[0]));
            int[] actualRequiredInjectors = new int[]{this.requiredInjectors[0] - this.requiredInjectors[1] - this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[1] - this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[3]};
            TextComponentString required = new TextComponentString(" ");
            for (int i3 = 0; i3 <= 3; ++i3) {
                int requiredInjectors = actualRequiredInjectors[i3];
                if (requiredInjectors <= 0) continue;
                if (!required.func_150253_a().isEmpty()) {
                    required.func_150258_a(", ");
                }
                required.func_150257_a((ITextComponent)new TextComponentTranslation("tile.packageddraconic.fusion_crafter.injectors." + i3, new Object[]{requiredInjectors}));
            }
            message.func_150258_a("\n");
            message.func_150257_a((ITextComponent)required);
        }
        return message;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.progress >= 2000) {
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive()) {
                        this.hostHelper.ejectItem();
                    } else {
                        this.ejectItems();
                    }
                }
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.ejectItem();
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else {
                    this.ejectItems();
                }
            }
        } else {
            this.clientTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void clientTick() {
        if (this.effects == null) {
            if (this.isWorking) {
                this.initializeEffects();
                this.effectRotation = 0.0;
                this.allLocked = false;
            }
            return;
        }
        double distFromCore = 1.2;
        if (this.progress > 1600) {
            distFromCore *= 1.0 - (double)(this.progress - 1600) / 400.0;
        }
        if (this.allLocked) {
            this.effectRotation -= Math.min((double)(this.progress - 1100) / 900.0 * 0.8, 0.5);
            if (this.effectRotation > 0.0) {
                this.effectRotation = 0.0;
            }
        }
        int index = 0;
        int count = this.effects.size();
        boolean flag = true;
        boolean isMoving = this.progress > 1000;
        for (EffectTrackerFusionCrafting effect : this.effects) {
            effect.onUpdate(isMoving);
            if (!effect.positionLocked) {
                flag = false;
            }
            if (isMoving) {
                effect.scale = 0.7f + (float)(distFromCore / 1.2) * 0.3f;
                effect.green = effect.blue = (float)(distFromCore - 0.2);
                effect.red = 1.0f - (float)(distFromCore - 0.2);
            }
            double indexPos = (double)index / (double)count;
            double offset = indexPos * Math.PI * 2.0;
            double offsetX = Math.sin(this.effectRotation + offset) * distFromCore;
            double offsetZ = Math.cos(this.effectRotation + offset) * distFromCore;
            double mix = this.effectRotation / 5.0;
            double xAdditive = offsetX * Math.sin(-mix);
            double zAdditive = offsetZ * Math.cos(-mix);
            double offsetY = (xAdditive + zAdditive) * 0.2 * distFromCore / 1.2;
            effect.circlePosition.set((double)this.field_174879_c.func_177958_n() + 0.5 + offsetX, (double)this.field_174879_c.func_177956_o() + 0.5 + offsetY, (double)this.field_174879_c.func_177952_p() + 0.5 + offsetZ);
            ++index;
        }
        SoundHandler soundManager = FMLClientHandler.instance().getClient().func_147118_V();
        if (!this.allLocked && flag) {
            soundManager.func_147682_a((ISound)new FusionCrafterRotationSound(this));
        }
        this.allLocked = flag;
        if (!this.isWorking) {
            for (int i = 0; i < 100; ++i) {
                BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new EffectTrackerFusionCrafting.SubParticle(this.field_145850_b, new Vec3D(this.field_174879_c).add(0.5, 0.5, 0.5)));
            }
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 2.0f, 1.0f, false);
            this.effects = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initializeEffects() {
        this.injectors.clear();
        int range = 16;
        Streams.stream((Iterable)Iterables.concat((Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-range, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(range, 1, 1)), (Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -range, -1), (BlockPos)this.field_174879_c.func_177982_a(1, range, 1)), (Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -range), (BlockPos)this.field_174879_c.func_177982_a(1, 1, range)))).forEach(checkPos -> {
            TileEntity tile = this.field_145850_b.func_175625_s((BlockPos)checkPos);
            if (tile instanceof TileMarkedInjector) {
                TileMarkedInjector injector = (TileMarkedInjector)tile;
                BlockPos dirVec = checkPos.func_177973_b((Vec3i)this.field_174879_c);
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist >= 2 && EnumFacing.func_176737_a((float)dirVec.func_177958_n(), (float)dirVec.func_177956_o(), (float)dirVec.func_177952_p()) == injector.getDirection().func_176734_d() && injector.setCraftingInventory(this)) {
                    EnumFacing facing = injector.getDirection();
                    for (BlockPos bp : BlockPos.func_177980_a((BlockPos)checkPos.func_177972_a(facing), (BlockPos)checkPos.func_177967_a(facing, TileFusionCrafter.distanceInDirection((BlockPos)checkPos, this.field_174879_c, facing) - 1))) {
                        if (this.field_145850_b.func_175623_d(bp) || !this.field_145850_b.func_180495_p(bp).func_185917_h() && !(this.field_145850_b.func_175625_s(bp) instanceof TileMarkedInjector)) continue;
                        injector.setCraftingInventory(null);
                        return;
                    }
                    this.injectors.add(checkPos.func_185334_h());
                }
            }
        });
        this.effectRecipe = RecipeManager.FUSION_REGISTRY.findRecipe((IFusionCraftingInventory)this, this.field_145850_b, this.field_174879_c);
        if (this.effectRecipe == null) {
            this.effects = null;
            return;
        }
        this.effects = new LinkedList();
        for (ICraftingInjector injector : this.getInjectors()) {
            if (injector.getStackInPedestal().func_190926_b()) continue;
            injector.setCraftingInventory((IFusionCraftingInventory)this);
            Vec3D spawn = new Vec3D(((TileEntity)injector).func_174877_v());
            spawn.add(0.5 + (double)injector.getDirection().func_82601_c() * 0.45, 0.5 + (double)injector.getDirection().func_96559_d() * 0.45, 0.5 + (double)injector.getDirection().func_82599_e() * 0.45);
            this.effects.add(new EffectTrackerFusionCrafting(this.field_145850_b, spawn, new Vec3D(this.field_174879_c), (IFusionCraftingInventory)this, this.effectRecipe.getRecipeIngredients().size()));
        }
    }

    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IRecipeInfoFusion) {
            IRecipeInfoFusion recipe = (IRecipeInfoFusion)recipeInfo;
            int tier = recipe.getTierRequired();
            List<ItemStack> injectorInputs = recipe.getInjectorInputs();
            List<BlockPos> emptyInjectors = this.getEmptyInjectors(tier);
            this.requiredInjectors[tier] = Math.max(this.requiredInjectors[tier], injectorInputs.size());
            if (emptyInjectors.size() >= injectorInputs.size()) {
                ICraftingInjector injector;
                int i;
                this.injectors.clear();
                this.injectors.addAll(emptyInjectors.subList(0, injectorInputs.size()));
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.inventory.func_70299_a(0, recipe.getCoreInput().func_77946_l());
                List<ICraftingInjector> craftInjectors = this.getInjectors();
                for (i = 0; i < craftInjectors.size(); ++i) {
                    injector = craftInjectors.get(i);
                    injector.setStackInPedestal(injectorInputs.get(i).func_77946_l());
                    injector.setCraftingInventory((IFusionCraftingInventory)this);
                }
                if (!recipe.getRecipe().matches((IFusionCraftingInventory)this, this.field_145850_b, this.field_174879_c) || !"true".equals(recipe.getRecipe().canCraft((IFusionCraftingInventory)this, this.field_145850_b, this.field_174879_c))) {
                    this.injectors.clear();
                    this.currentRecipe = null;
                    this.isWorking = false;
                    this.inventory.func_70299_a(0, ItemStack.field_190927_a);
                    for (i = 0; i < craftInjectors.size(); ++i) {
                        injector = craftInjectors.get(i);
                        injector.setStackInPedestal(ItemStack.field_190927_a);
                        injector.setCraftingInventory(null);
                    }
                    return false;
                }
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.inventory.stacks.subList(0, 2).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        List<ICraftingInjector> craftInjectors = this.getInjectors();
        if (craftInjectors.size() != this.injectors.size()) {
            this.endProcess();
        } else {
            PacketSyncCrafter.sync(this);
            long totalCharge = this.getInjectors().stream().mapToLong(c -> c.getInjectorCharge()).sum();
            long averageCharge = totalCharge / (long)this.injectors.size();
            double percentage = (double)averageCharge / (double)this.currentRecipe.getEnergyRequired();
            if (percentage <= 1.0 && this.progress < 1000) {
                this.progress = (short)(percentage * 1000.0);
                if (this.progress == 0 && percentage > 0.0) {
                    this.progress = 1;
                }
            } else if (this.progress < 2000 && this.energyStorage.extractEnergy(energyUsage, true) == energyUsage) {
                this.energyStorage.extractEnergy(energyUsage, false);
                if (this.craftRate <= 0) {
                    this.craftRate = craftInjectors.stream().mapToInt(c -> {
                        if (c instanceof TileMarkedInjector) {
                            return ((TileMarkedInjector)((Object)c)).getCraftRate();
                        }
                        return 2 + Math.max(c.getPedestalTier() * 2 - 1, 0);
                    }).min().orElse(2);
                }
                this.progress = (short)(this.progress + this.craftRate);
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.injectors.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).anyMatch(tile -> !(tile instanceof TileMarkedInjector) || tile.func_145837_r())) {
            this.endProcess();
            return;
        }
        this.currentRecipe.getRecipe().craft((IFusionCraftingInventory)this, this.field_145850_b, this.field_174879_c);
        for (ICraftingInjector injector : this.getInjectors()) {
            injector.onCraft();
        }
        this.endProcess();
    }

    public void endProcess() {
        this.progress = 0;
        this.getInjectors().stream().forEach(tile -> ((TileMarkedInjector)((Object)tile)).ejectItem());
        this.injectors.clear();
        this.isWorking = false;
        this.craftRate = 0;
        this.currentRecipe = null;
        this.func_70296_d();
    }

    protected List<BlockPos> getEmptyInjectors(int minTier) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = 3; i >= minTier; --i) {
            positions.addAll(this.getEmptyInjectorsForTier(i));
        }
        return positions;
    }

    protected List<BlockPos> getEmptyInjectorsForTier(int tier) {
        int range = 16;
        return Streams.stream((Iterable)Iterables.concat((Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-range, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(range, 1, 1)), (Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -range, -1), (BlockPos)this.field_174879_c.func_177982_a(1, range, 1)), (Iterable)BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -range), (BlockPos)this.field_174879_c.func_177982_a(1, 1, range)))).map(checkPos -> {
            TileEntity tile = this.field_145850_b.func_175625_s((BlockPos)checkPos);
            if (tile instanceof TileMarkedInjector) {
                TileMarkedInjector injector = (TileMarkedInjector)tile;
                BlockPos dirVec = checkPos.func_177973_b((Vec3i)this.field_174879_c);
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist >= 2 && injector.getPedestalTier() == tier && injector.getStackInPedestal().func_190926_b() && EnumFacing.func_176737_a((float)dirVec.func_177958_n(), (float)dirVec.func_177956_o(), (float)dirVec.func_177952_p()) == injector.getDirection().func_176734_d()) {
                    EnumFacing facing = injector.getDirection();
                    for (BlockPos bp : BlockPos.func_177980_a((BlockPos)checkPos.func_177972_a(facing), (BlockPos)checkPos.func_177967_a(facing, TileFusionCrafter.distanceInDirection((BlockPos)checkPos, this.field_174879_c, facing) - 1))) {
                        IBlockState state = this.field_145850_b.func_180495_p(bp);
                        TileEntity btile = this.field_145850_b.func_175625_s(bp);
                        if ((state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, bp) || btile instanceof TilePackager || btile instanceof TilePackagerExtension || btile instanceof TileUnpackager || !this.field_145850_b.func_180495_p(bp).func_185917_h()) && !(btile instanceof TileMarkedInjector) && !(btile instanceof TileFusionCrafter)) continue;
                        return null;
                    }
                    return checkPos.func_185334_h();
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ICraftingInjector> getInjectors() {
        return this.injectors.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(tile -> tile instanceof TileMarkedInjector && !tile.func_145837_r()).map(tile -> (ICraftingInjector)tile).collect(Collectors.toList());
    }

    public static int distanceInDirection(BlockPos fromPos, BlockPos toPos, EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return fromPos.func_177956_o() - toPos.func_177956_o();
            }
            case UP: {
                return toPos.func_177956_o() - fromPos.func_177956_o();
            }
            case NORTH: {
                return fromPos.func_177952_p() - toPos.func_177952_p();
            }
            case SOUTH: {
                return toPos.func_177952_p() - fromPos.func_177952_p();
            }
            case WEST: {
                return fromPos.func_177958_n() - toPos.func_177958_n();
            }
            case EAST: {
                return toPos.func_177958_n() - fromPos.func_177958_n();
            }
        }
        return 0;
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 1 : 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TileUnpackager || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 1; i >= endIndex; --i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.inventory.func_70299_a(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.inventory.func_70301_a(2);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(2, ItemStack.field_190927_a);
            }
        }
    }

    public ItemStack getStackInCore(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void setStackInCore(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public long getIngredientEnergyCost() {
        return this.currentRecipe == null ? 0L : this.currentRecipe.getEnergyRequired();
    }

    public boolean craftingInProgress() {
        return this.isWorking;
    }

    public int getCraftingStage() {
        return this.progress;
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.stacks.subList(0, 2).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-16, -16, -16), this.field_174879_c.func_177982_a(17, 17, 17));
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("Progress");
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe")) {
            NBTTagCompound tag = nbt.func_74775_l("Recipe");
            IRecipeInfo recipe = MiscUtil.readRecipeFromNBT((NBTTagCompound)tag);
            if (recipe instanceof IRecipeInfoFusion) {
                this.currentRecipe = (IRecipeInfoFusion)recipe;
            }
            this.injectors.clear();
            NBTTagList injectorsTag = nbt.func_150295_c("Injectors", 11);
            for (int i = 0; i < injectorsTag.func_74745_c(); ++i) {
                int[] posArray = injectorsTag.func_150306_c(i);
                BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.injectors.add(pos);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0) {
            return 0;
        }
        return scale * this.progress / 2000;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiFusionCrafter(new ContainerFusionCrafter(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerFusionCrafter(player.field_71071_by, this);
    }

    private static /* synthetic */ void lambda$writeToNBT$10(NBTTagList injectorsTag, int[] arr) {
        injectorsTag.func_74742_a((NBTBase)new NBTTagIntArray(arr));
    }
}

