/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.GuiButtonAHeight;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.inventory.ContainerBCBase;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class GuiEnergyCore
extends GuiContainer {
    public EntityPlayer player;
    public TileEnergyStorageCore tile;
    private GuiButton activate;
    private GuiButton tierUp;
    private GuiButton tierDown;
    private GuiButton toggleGuide;
    private GuiButton assembleCore;
    private GuiButton layerPlus;
    private GuiButton layerMinus;
    public static int layer = -1;
    private long ticks;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long years;

    public GuiEnergyCore(EntityPlayer player, TileEnergyStorageCore tile) {
        super((Container)new ContainerBCBase(player, (TileBCBase)tile).addPlayerSlots(10, 126));
        this.tile = tile;
        this.field_146999_f = 180;
        this.field_147000_g = 210;
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.activate = new GuiButtonAHeight(0, this.field_147003_i + 9, this.field_147009_r + 99 + 10, 162, 12, "Activate-L");
        this.field_146292_n.add(this.activate);
        this.tierUp = new GuiButtonAHeight(1, this.field_147003_i + 91, this.field_147009_r + 86 + 10, 80, 12, net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.tierUp.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.tierUp);
        this.tierDown = new GuiButtonAHeight(2, this.field_147003_i + 9, this.field_147009_r + 86 + 10, 80, 12, net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.tierDown.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.tierDown);
        this.toggleGuide = new GuiButtonAHeight(3, this.field_147003_i + 9, this.field_147009_r + 73 + 10, 162, 12, net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.toggleGuide);
        this.assembleCore = new GuiButtonAHeight(4, this.field_147003_i + 9, this.field_147009_r + 99 + 10, 162, 12, net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.assembleCore.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.assembleCore);
        this.layerMinus = new GuiButtonAHeight(5, this.field_147003_i + 5, this.field_147009_r - 13, 70, 12, "Layer-");
        this.field_146292_n.add(this.layerMinus);
        this.layerPlus = new GuiButtonAHeight(6, this.field_147003_i + 105, this.field_147009_r - 13, 70, 12, "Layer+");
        this.field_146292_n.add(this.layerPlus);
        this.layerPlus.field_146125_m = this.tile.buildGuide.value;
        this.layerMinus.field_146125_m = this.tile.buildGuide.value;
        this.updateButtonStates();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiHelper.drawGuiBaseBackground((Gui)this, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiHelper.drawPlayerSlots((Gui)this, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 115 + 10), (boolean)true);
        this.func_73732_a(this.field_146289_q, net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.energyStorageCore.name", (Object[])new Object[]{this.tile.tier.toString()}), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 5, 65535);
        if (this.tile.active.value) {
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.capacity.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 16), (int)0xFFAA00, (boolean)true);
            String capText = this.tile.tier.value == 8 ? net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.almostInfinite.txt", (Object[])new Object[0]) : Utils.formatNumber((long)this.tile.getExtendedCapacity());
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)capText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 27), (int)0x555555, (boolean)false);
            DecimalFormat energyValue = new DecimalFormat("###.###");
            double percent = (double)this.tile.getExtendedStorage() / (double)this.tile.getExtendedCapacity() * 100.0;
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)net.minecraft.client.resources.I18n.func_135052_a((String)"info.bc.charge.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 38), (int)0xFFAA00, (boolean)true);
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)(Utils.formatNumber((long)this.tile.getExtendedStorage()) + "RF [" + energyValue.format(percent) + "%]"), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 49), (int)0x555555, (boolean)false);
            int coreColour = this.tile.transferRate.value > 0L ? 65280 : (this.tile.transferRate.value < 0L ? 0xFF0000 : 0x222222);
            String transfer = (this.tile.transferRate.value > 0L ? "+" : (this.tile.transferRate.value < 0L ? "-" : "")) + Utils.formatNumber((long)Math.abs(this.tile.transferRate.value)) + " RF/t";
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)net.minecraft.client.resources.I18n.func_135052_a((String)("gui.de.transfer" + (this.tile.transferRate.value > 0L ? ".charge" : (this.tile.transferRate.value < 0L ? ".discharge" : "")) + ".txt"), (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 59), (int)0xFFAA00, (boolean)true);
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)transfer, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 70), (int)coreColour, (this.tile.transferRate.value > 0L ? 1 : 0) != 0);
            if (this.tile.transferRate.value != 0L) {
                String time = "";
                if (this.years > 0L) {
                    time = time + GuiEnergyCore.formatYear(this.years) + ", ";
                    time = time + this.days % 365L + " Days";
                } else if (this.days > 0L) {
                    time = time + this.days % 365L + " Days, ";
                    time = time + (this.hours % 24L < 10L ? "0" : "") + this.hours % 24L + ":";
                    time = time + (this.minutes % 60L < 10L ? "0" : "") + this.minutes % 60L + ":";
                    time = time + (this.seconds % 60L < 10L ? "0" : "") + this.seconds % 60L + "." + (this.ticks % 20L < 10L ? "0" : "") + this.ticks % 20L;
                } else {
                    time = time + (this.hours % 24L < 10L ? "0" : "") + this.hours % 24L + ":";
                    time = time + (this.minutes % 60L < 10L ? "0" : "") + this.minutes % 60L + ":";
                    time = time + (this.seconds % 60L < 10L ? "0" : "") + this.seconds % 60L + "." + (this.ticks % 20L < 10L ? "0" : "") + this.ticks % 20L;
                }
                GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)time, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 70 + 10), (int)0x555555, (boolean)false);
            }
        } else {
            int stabColour = this.tile.stabilizersOK.value ? 65280 : 0xFF0000;
            String stabText = net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.stabilizers.txt", (Object[])new Object[0]) + ": " + (this.tile.stabilizersOK.value ? net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)stabText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 18), (int)stabColour, (boolean)this.tile.stabilizersOK.value);
            if (this.tile.tier.value >= 5) {
                GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.advancedStabilizersRequired.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 28), (int)0x777777, (boolean)false);
            }
            int coreColour = this.tile.coreValid.value ? 65280 : 0xFF0000;
            String coreText = net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.core.txt", (Object[])new Object[0]) + ": " + (this.tile.coreValid.value ? net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)coreText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 36), (int)coreColour, (boolean)this.tile.coreValid.value);
            if (!this.tile.coreValid.value) {
                GuiHelper.drawCenteredSplitString((FontRenderer)this.field_146289_q, (String)this.tile.invalidMessage.value, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 46), (int)180, (int)coreColour, (boolean)this.tile.coreValid.value);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.tile.active.value) {
            ArrayList<String> list;
            GuiEnergyCore.drawEnergyBar((Gui)this, this.field_147003_i + 5, this.field_147009_r + 82 + 10, 170, true, this.tile.getExtendedStorage(), this.tile.getExtendedCapacity(), true, mouseX, mouseY);
            if (GuiHelper.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 27), (int)(this.field_146999_f - 80), (int)8, (int)mouseX, (int)mouseY)) {
                list = new ArrayList<String>();
                list.add(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedCapacity()) + " RF]");
                this.func_146283_a(list, mouseX, mouseY);
            }
            if (GuiHelper.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 48), (int)(this.field_146999_f - 80), (int)8, (int)mouseX, (int)mouseY)) {
                list = new ArrayList();
                list.add(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedStorage()) + " RF]");
                this.func_146283_a(list, mouseX, mouseY);
            }
            if (this.tile.transferRate.value != 0L && GuiHelper.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 70 + 10), (int)(this.field_146999_f - 80), (int)8, (int)mouseX, (int)mouseY)) {
                list = new ArrayList();
                list.add(TextFormatting.AQUA + "ETA");
                if (this.years > 0L) {
                    list.add(TextFormatting.GOLD + GuiEnergyCore.formatYear(this.years));
                }
                if (this.days > 0L) {
                    list.add(TextFormatting.GOLD + "" + this.days % 365L + " Days");
                }
                String time = (this.hours % 24L < 10L ? "0" : "") + this.hours % 24L + ":";
                time = time + (this.minutes % 60L < 10L ? "0" : "") + this.minutes % 60L + ":";
                time = time + (this.seconds % 60L < 10L ? "0" : "") + this.seconds % 60L + "." + (this.ticks % 20L < 10L ? "0" : "") + this.ticks % 20L;
                list.add(TextFormatting.GOLD + "" + time);
                this.func_146283_a(list, mouseX, mouseY);
            }
        }
        if (this.tile.buildGuide.value) {
            this.func_73732_a(this.field_146289_q, layer == -1 ? "All" : layer + "", this.field_147003_i + this.field_146999_f / 2, this.field_147009_r - 10, 0xFFFFFF);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtonStates();
        if (this.tile.transferRate.value != 0L) {
            long space = this.tile.transferRate.value > 0L ? this.tile.getExtendedCapacity() - this.tile.getExtendedStorage() : this.tile.getExtendedStorage();
            this.ticks = Math.abs(space / this.tile.transferRate.value);
        } else {
            this.ticks = 0L;
        }
        this.seconds = this.ticks / 20L;
        this.minutes = this.seconds / 60L;
        this.hours = this.minutes / 60L;
        this.days = this.hours / 24L;
        this.years = this.days / 365L;
    }

    private void updateButtonStates() {
        if (this.tile.active.value) {
            this.activate.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.deactivate.txt", (Object[])new Object[0]);
        } else {
            this.activate.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.activate.txt", (Object[])new Object[0]);
            this.toggleGuide.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]) + " " + (this.tile.buildGuide.value ? net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.active.txt", (Object[])new Object[0]) : net.minecraft.client.resources.I18n.func_135052_a((String)"gui.de.inactive.txt", (Object[])new Object[0]));
            this.tierUp.field_146124_l = this.tile.tier.value < 8;
            this.tierDown.field_146124_l = this.tile.tier.value > 1;
        }
        this.toggleGuide.field_146125_m = !this.tile.active.value;
        this.tierDown.field_146125_m = this.toggleGuide.field_146125_m;
        this.tierUp.field_146125_m = this.toggleGuide.field_146125_m;
        this.assembleCore.field_146125_m = !this.tile.coreValid.value;
        this.activate.field_146125_m = this.tile.coreValid.value;
        this.layerPlus.field_146125_m = this.tile.buildGuide.value;
        this.layerMinus.field_146125_m = this.tile.buildGuide.value;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k < 5) {
            this.tile.sendPacketToServer(output -> {}, button.field_146127_k);
        } else {
            layer = button == this.layerPlus ? ++layer : --layer;
            layer = MathHelper.clip((int)layer, (int)-1, (int)6);
        }
    }

    public static void drawEnergyBar(Gui gui, int posX, int posY, int size, boolean horizontal, long energy, long maxEnergy, boolean toolTip, int mouseX, int mouseY) {
        ResourceHelperBC.bindTexture((String)"textures/gui/energy_gui.png");
        int draw = (int)((double)energy / (double)maxEnergy * (double)(size - 2));
        boolean inRect = GuiHelper.isInRect((int)posX, (int)posY, (int)size, (int)14, (int)mouseX, (int)mouseY);
        if (horizontal) {
            int x = posY;
            posY = posX;
            posX = x;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(size + posY * 2), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(posX, posY, 0, 0, 14, size);
        gui.func_73729_b(posX, posY + size - 1, 0, 255, 14, 1);
        gui.func_73729_b(posX + 1, posY + size - draw - 1, 14, size - draw, 12, draw);
        if (horizontal) {
            GlStateManager.func_179121_F();
        }
        if (toolTip && inRect) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(InfoHelper.ITC() + I18n.func_74838_a((String)"gui.de.energyStorage.txt"));
            list.add(InfoHelper.HITC() + Utils.formatNumber((long)energy) + " / " + Utils.formatNumber((long)maxEnergy));
            list.add(TextFormatting.GRAY + "[" + Utils.addCommas((long)energy) + " RF]");
            GuiHelper.drawHoveringText(list, (int)mouseX, (int)mouseY, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        }
    }

    public static String formatYear(long value) {
        if (value < 1000L) {
            return value + " Years";
        }
        if (value < 1000000L) {
            return (double)Math.round((double)value / 10.0) / 100.0 + " Thousand Years";
        }
        if (value < 1000000000L) {
            return (double)Math.round((double)value / 10000.0) / 100.0 + " Million Years";
        }
        if (value < 1000000000000L) {
            return (double)Math.round((double)value / 1.0E7) / 100.0 + " Billion Years";
        }
        if (value < 1000000000000000L) {
            return (double)Math.round((double)value / 1.0E10) / 100.0 + " Trillion Years";
        }
        if (value < 1000000000000000000L) {
            return (double)Math.round((double)value / 1.0E13) / 100.0 + " Quadrillion Years";
        }
        if (value <= Long.MAX_VALUE) {
            return (double)Math.round((double)value / 1.0E16) / 100.0 + " Quintillion Years";
        }
        return "Something is very broken!!!!";
    }
}

