/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.network.ISelfHandleMessage;

public class PacketSetRecipe
implements ISelfHandleMessage<IMessage> {
    private Int2ObjectMap<ItemStack> map;

    public PacketSetRecipe() {
    }

    public PacketSetRecipe(Int2ObjectMap<ItemStack> map) {
        this.map = map;
    }

    public PacketSetRecipe addItem(int index, ItemStack stack) {
        this.map.put(index, (Object)stack);
        return this;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.map.size());
        for (Int2ObjectMap.Entry entry : this.map.int2ObjectEntrySet()) {
            buf.writeByte(entry.getIntKey());
            MiscUtil.writeItemWithLargeCount(buf, (ItemStack)entry.getValue());
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readByte();
        this.map = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            short index = buf.readUnsignedByte();
            ItemStack stack = MiscUtil.readItemWithLargeCount(buf);
            this.map.put((int)index, (Object)stack);
        }
    }

    @Override
    public IMessage onMessage(MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer world = player.func_71121_q();
        world.func_152344_a(() -> {
            if (player.field_71070_bA instanceof ContainerEncoder) {
                ContainerEncoder container = (ContainerEncoder)player.field_71070_bA;
                container.patternInventory.setRecipe(this.map);
            }
        });
        return null;
    }
}

