/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageContentsWrapper;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingWrapper;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeWrapper;
import thelm.packagedauto.integration.jei.category.PackagingCategory;
import thelm.packagedauto.integration.jei.category.PackagingWrapper;
import thelm.packagedauto.recipe.RecipeTypeProcessing;

public class PackageRegistryPlugin
implements IRecipeRegistryPlugin {
    private final IRecipeInfo exampleRecipe = RecipeTypeProcessing.INSTANCE.getNewRecipeInfo();

    public PackageRegistryPlugin() {
        this.exampleRecipe.generateFromStacks(Collections.singletonList(new ItemStack(Blocks.field_180401_cv)), Collections.singletonList(new ItemStack(Blocks.field_180401_cv)), null);
    }

    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            if (stack.func_77973_b() instanceof IPackageItem) {
                switch (focus.getMode()) {
                    case INPUT: {
                        return ImmutableList.of((Object)"packagedauto:package_recipe", (Object)"packagedauto:package_processing", (Object)"packagedauto:package_contents");
                    }
                    case OUTPUT: {
                        return ImmutableList.of((Object)"packagedauto:package_recipe", (Object)"packagedauto:packaging");
                    }
                }
            }
            if (stack.func_77973_b() instanceof IRecipeListItem) {
                switch (focus.getMode()) {
                    case INPUT: {
                        return ImmutableList.of((Object)"packagedauto:package_recipe", (Object)"packagedauto:package_processing");
                    }
                    case OUTPUT: {
                        return ImmutableList.of((Object)"packagedauto:package_recipe");
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            String uid = recipeCategory.getUid();
            ItemStack stack = (ItemStack)focus.getValue();
            if (stack.func_77973_b() instanceof IPackageItem) {
                IPackageItem packageItem = (IPackageItem)stack.func_77973_b();
                IRecipeInfo recipe = packageItem.getRecipeInfo(stack);
                int index = packageItem.getIndex(stack);
                if (recipe != null && recipe.validPatternIndex(index)) {
                    if ("packagedauto:package_recipe".equals(uid)) {
                        return Collections.singletonList(new PackageRecipeWrapper(recipe));
                    }
                    if ("packagedauto:packaging".equals(uid)) {
                        return Collections.singletonList(new PackagingWrapper(recipe.getPatterns().get(index)));
                    }
                    if ("packagedauto:package_processing".equals(uid)) {
                        return Collections.singletonList(new PackageProcessingWrapper(recipe));
                    }
                    if ("packagedauto:package_contents".equals(uid)) {
                        return Collections.singletonList(new PackageContentsWrapper(recipe.getPatterns().get(index)));
                    }
                }
            }
            if (stack.func_77973_b() instanceof IRecipeListItem) {
                List<IRecipeInfo> recipeList = ((IRecipeListItem)stack.func_77973_b()).getRecipeList(stack).getRecipeList();
                if ("packagedauto:package_recipe".equals(uid)) {
                    return recipeList.stream().map(PackageRecipeWrapper::new).collect(Collectors.toList());
                }
                if ("packagedauto:package_processing".equals(uid)) {
                    return recipeList.stream().map(PackageProcessingWrapper::new).collect(Collectors.toList());
                }
            }
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof PackageRecipeCategory) {
            return Collections.singletonList(new PackageRecipeWrapper(this.exampleRecipe));
        }
        if (recipeCategory instanceof PackagingCategory) {
            return Collections.singletonList(new PackagingWrapper(this.exampleRecipe.getPatterns().get(0)));
        }
        if (recipeCategory instanceof PackageProcessingCategory) {
            return Collections.singletonList(new PackageProcessingWrapper(this.exampleRecipe));
        }
        if (recipeCategory instanceof PackageContentsCategory) {
            return Collections.singletonList(new PackageContentsWrapper(this.exampleRecipe.getPatterns().get(0)));
        }
        return Collections.emptyList();
    }
}

