/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiDistributor;
import thelm.packagedauto.container.ContainerDistributor;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileDistributor;
import thelm.packagedauto.inventory.InventoryDistributor;
import thelm.packagedauto.item.ItemDistributorMarker;
import thelm.packagedauto.network.packet.PacketBeam;
import thelm.packagedauto.network.packet.PacketDirectionalMarker;
import thelm.packagedauto.network.packet.PacketSizedMarker;
import thelm.packagedauto.recipe.IRecipeInfoProcessingPositioned;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileDistributor
extends TileBase
implements ITickable,
IPackageCraftingMachine,
ISettingsCloneable,
IGridHost,
IActionHost {
    public static int range = 16;
    public static int refreshInterval = 4;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    public boolean firstTick = true;
    public HostHelperTileDistributor hostHelper;

    public TileDistributor() {
        this.setInventory(new InventoryDistributor(this));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileDistributor(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.distributor.name");
    }

    @Override
    public String getConfigTypeName() {
        return "tile.packagedauto.distributor.name";
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K && this.hostHelper != null) {
                this.hostHelper.isActive();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        if (!this.isBusy() && recipeInfo instanceof IRecipeInfoProcessingPositioned) {
            IRecipeInfoProcessingPositioned recipe = (IRecipeInfoProcessingPositioned)recipeInfo;
            boolean blocking = false;
            TileEntity unpackager = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (unpackager instanceof TileUnpackager) {
                blocking = ((TileUnpackager)unpackager).blocking;
            }
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.field_145850_b.func_175667_e(pos)) {
                    return false;
                }
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (tile == null) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).func_77946_l();
                EnumFacing dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
                if (itemHandler != null) {
                    if (blocking && !MiscUtil.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).func_77946_l());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        ArrayList<Vec3d> deltas = new ArrayList<Vec3d>();
        for (int i : this.pending.keySet().toIntArray()) {
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                break;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.field_145850_b.func_175667_e(pos)) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile == null) {
                this.ejectItems();
                break;
            }
            ItemStack stack = (ItemStack)this.pending.get(i);
            EnumFacing dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            ItemStack stackRem = stack;
            if (itemHandler == null) {
                this.ejectItems();
                break;
            }
            stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (stackRem.func_190916_E() < stack.func_190916_E()) {
                Vec3d delta = new Vec3d((Vec3i)pos.func_177973_b((Vec3i)this.field_174879_c)).func_178787_e(new Vec3d(dir.func_176730_m()).func_186678_a(0.5));
                deltas.add(delta);
            }
            if (stackRem.func_190926_b()) {
                this.pending.remove(i);
                continue;
            }
            this.pending.put(i, (Object)stackRem);
        }
        if (!deltas.isEmpty()) {
            Vec3d source = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
            PacketBeam.sendBeams(source, deltas, 65535, 6, true, this.field_145850_b.field_73011_w.getDimension(), 32.0);
            this.func_70296_d();
        }
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).func_190926_b()) continue;
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
        this.func_70296_d();
    }

    public void sendPreview(EntityPlayerMP player) {
        long currentTime = this.field_145850_b.func_82737_E();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.func_110124_au());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            this.previewTimes.put((Object)player.func_110124_au(), (Object)currentTime);
            if (!this.positions.isEmpty()) {
                List<Vec3d> deltas = this.positions.values().stream().map(globalPos -> {
                    BlockPos pos = globalPos.blockPos();
                    EnumFacing dir = globalPos.direction();
                    return new Vec3d((Vec3i)pos.func_177973_b((Vec3i)this.field_174879_c)).func_72441_c((double)dir.func_82601_c() * 0.5, (double)dir.func_96559_d() * 0.5, (double)dir.func_82599_e() * 0.5);
                }).collect(Collectors.toList());
                Vec3d source = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
                PacketDirectionalMarker.sendDirectionalMarkers(player, new ArrayList<DirectionalGlobalPos>((Collection<DirectionalGlobalPos>)this.positions.values()), 65407, 200);
                PacketBeam.sendBeams(player, source, deltas, 65407, 200, false);
            }
            Vec3d lowerCorner = new Vec3d((Vec3i)this.field_174879_c).func_178786_a((double)range, (double)range, (double)range);
            Vec3d size = new Vec3d((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            PacketSizedMarker.sendSizedMarker(player, lowerCorner, size, 65535, 200);
        }
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    @Override
    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        ItemStack stack;
        int i;
        InventoryPlayer playerInventory;
        int requiredCount;
        NBTTagList positionsTag;
        block13: {
            ItemStack stack2;
            int i2;
            positionsTag = nbt.func_150295_c("Positions", 10);
            if (positionsTag.func_82582_d()) {
                return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("item.packagedauto.settings_cloner.invalid", new Object[0]));
            }
            requiredCount = positionsTag.func_74745_c();
            int availableCount = 0;
            playerInventory = player.field_71071_by;
            for (i2 = 0; i2 < this.inventory.func_70302_i_(); ++i2) {
                stack2 = this.inventory.func_70301_a(i2);
                if (stack2.func_190926_b()) continue;
                if (stack2.func_77973_b() == ItemDistributorMarker.INSTANCE) {
                    availableCount += stack2.func_190916_E();
                    continue;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.distributor.non_marker_present", new Object[0]));
            }
            if (availableCount < requiredCount) {
                for (i2 = 0; i2 < playerInventory.func_70302_i_(); ++i2) {
                    stack2 = playerInventory.func_70301_a(i2);
                    if (!stack2.func_190926_b() && stack2.func_77973_b() == ItemDistributorMarker.INSTANCE && !stack2.func_77942_o()) {
                        availableCount += stack2.func_190916_E();
                    }
                    if (availableCount < requiredCount) {
                        continue;
                    }
                    break block13;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.distributor.no_markers", new Object[0]));
            }
        }
        int removedCount = 0;
        for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
            removedCount += this.inventory.func_70301_a(i).func_190916_E();
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        if (removedCount < requiredCount) {
            for (i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack3 = playerInventory.func_70301_a(i);
                if (!stack3.func_190926_b() && stack3.func_77973_b() == ItemDistributorMarker.INSTANCE && !stack3.func_77942_o()) {
                    removedCount += stack3.func_77979_a(requiredCount - removedCount).func_190916_E();
                }
                if (removedCount >= requiredCount) break;
            }
        }
        if (removedCount > requiredCount && !playerInventory.func_70441_a(stack = new ItemStack((Item)ItemDistributorMarker.INSTANCE, removedCount - requiredCount))) {
            EntityItem item = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            item.func_145799_b(player.func_70005_c_());
            this.field_145850_b.func_72838_d((Entity)item);
        }
        for (int i3 = 0; i3 < requiredCount; ++i3) {
            NBTTagCompound positionTag = positionsTag.func_150305_b(i3);
            byte index = positionTag.func_74771_c("Index");
            int dimension = positionTag.func_74762_e("Dimension");
            int[] posArray = positionTag.func_74759_k("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            EnumFacing direction = EnumFacing.func_82600_a((int)positionTag.func_74771_c("Direction"));
            DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
            ItemStack stack4 = new ItemStack((Item)ItemDistributorMarker.INSTANCE);
            ItemDistributorMarker.INSTANCE.setDirectionalGlobalPos(stack4, globalPos);
            this.inventory.func_70299_a(index, stack4);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        if (this.positions.isEmpty()) {
            return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.distributor.empty", new Object[0]));
        }
        NBTTagList positionsTag = new NBTTagList();
        for (Int2ObjectMap.Entry entry : this.positions.int2ObjectEntrySet()) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)entry.getValue();
            NBTTagCompound positionTag = new NBTTagCompound();
            positionTag.func_74774_a("Index", (byte)entry.getIntKey());
            positionTag.func_74768_a("Dimension", pos.dimension());
            positionTag.func_74783_a("Position", new int[]{pos.x(), pos.y(), pos.z()});
            positionTag.func_74774_a("Direction", (byte)pos.direction().func_176745_a());
            positionsTag.func_74742_a((NBTBase)positionTag);
        }
        nbt.func_74782_a("Positions", (NBTBase)positionsTag);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscUtil.loadAllItems(nbt.func_150295_c("Pending", 10), pendingList);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.func_190926_b()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault((Object)i, (Object)ItemStack.field_190927_a));
        }
        NBTTagList pendingTag = MiscUtil.saveAllItems(new NBTTagList(), pendingList);
        nbt.func_74782_a("Pending", (NBTBase)pendingTag);
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiDistributor(new ContainerDistributor(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerDistributor(player.field_71071_by, this);
    }
}

