/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.integration.appeng.networking;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import net.minecraft.item.ItemStack;
import thelm.packagedauto.integration.appeng.networking.HostHelperTile;
import thelm.packagedauto.tile.TileBase;
import thelm.packageddraconic.tile.TileFusionCrafter;

public class HostHelperTileFusionCrafter
extends HostHelperTile<TileFusionCrafter> {
    public HostHelperTileFusionCrafter(TileFusionCrafter tile) {
        super((TileBase)tile);
        this.gridBlock.flags.remove(GridFlags.REQUIRE_CHANNEL);
    }

    public void ejectItem() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            int endIndex = ((TileFusionCrafter)this.tile).isWorking ? 1 : 0;
            for (int i = 1; i >= endIndex; --i) {
                ItemStack is = ((TileFusionCrafter)this.tile).getInventory().func_70301_a(i);
                if (is.func_190926_b()) continue;
                IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)is);
                IAEItemStack rem = (IAEItemStack)AEApi.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, (IActionSource)this.source, Actionable.MODULATE);
                if (rem == null || rem.getStackSize() == 0L) {
                    ((TileFusionCrafter)this.tile).getInventory().func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                if (rem.getStackSize() >= stack.getStackSize()) continue;
                ((TileFusionCrafter)this.tile).getInventory().func_70299_a(i, rem.createItemStack());
            }
        }
    }

    public void chargeEnergy() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(((TileFusionCrafter)this.tile).getEnergyStorage().getMaxReceive(), ((TileFusionCrafter)this.tile).getEnergyStorage().getMaxEnergyStored() - ((TileFusionCrafter)this.tile).getEnergyStorage().getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            ((TileFusionCrafter)this.tile).getEnergyStorage().receiveEnergy(extract, false);
        }
    }
}

