/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StabilizedSpawnerLogic
extends MobSpawnerBaseLogic {
    private TileStabilizedSpawner tile;
    private double mobRotation;
    private double prevMobRotation;
    private int spawnRange = 4;

    public StabilizedSpawnerLogic(TileStabilizedSpawner tile) {
        this.tile = tile;
    }

    @Nullable
    public ResourceLocation func_190895_g() {
        return new ResourceLocation(DEFeatures.mobSoul.getEntityString(this.tile.mobSoul.value));
    }

    public void func_190894_a(@Nullable ResourceLocation id) {
    }

    public void func_98278_g() {
        if (!this.func_98279_f()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            BlockPos blockpos = this.func_177221_b();
            if (this.func_98271_a().field_72995_K) {
                double d3 = (float)blockpos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
                double d4 = (float)blockpos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
                double d5 = (float)blockpos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
                this.func_98271_a().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                this.func_98271_a().func_175688_a(EnumParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                if (this.tile.spawnDelay.value > 0) {
                    this.tile.spawnDelay.value = (short)(this.tile.spawnDelay.value - 1);
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.tile.spawnDelay.value + 200.0f))) % 360.0;
            } else {
                if (this.tile.spawnDelay.value == -1) {
                    this.resetTimer();
                }
                if (this.tile.spawnDelay.value > 0) {
                    this.tile.spawnDelay.value = (short)(this.tile.spawnDelay.value - 1);
                    return;
                }
                TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.value;
                boolean flag = false;
                int successCount = 0;
                for (int i = 0; i < tier.getSpawnCount() + tier.ordinal() + 3; ++i) {
                    World world = this.func_98271_a();
                    Entity entity = DEFeatures.mobSoul.createEntity(world, this.tile.mobSoul.value);
                    do {
                        double spawnX = (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        double spawnY = blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                        double spawnZ = (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        entity.func_70080_a(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                    } while (entity.func_180425_c().func_177958_n() == this.tile.func_174877_v().func_177958_n() && entity.func_180425_c().func_177952_p() == this.tile.func_174877_v().func_177952_p());
                    int nearbyCount = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                    if (nearbyCount >= tier.getMaxCluster()) {
                        this.resetTimer();
                        return;
                    }
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving == null || this.canEntitySpawnSpawner(entityliving, this.func_98271_a(), (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, this)) {
                        if (!tier.requiresPlayer() && entity instanceof EntityLiving) {
                            ((EntityLiving)entity).func_110163_bv();
                            entity.getEntityData().func_74772_a("DESpawnedMob", System.currentTimeMillis());
                            DEEventHandler.onMobSpawnedBySpawner((EntityLiving)entity);
                        }
                        AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
                        world.func_175718_b(2004, blockpos, 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                            if (tier == TileStabilizedSpawner.SpawnerTier.CHAOTIC) {
                                double velocity = 2.5;
                                entity.field_70159_w = (world.field_73012_v.nextDouble() - 0.5) * velocity;
                                entity.field_70181_x = world.field_73012_v.nextDouble() * velocity;
                                entity.field_70179_y = (world.field_73012_v.nextDouble() - 0.5) * velocity;
                            }
                        }
                        flag = true;
                        ++successCount;
                    }
                    if (successCount >= tier.getSpawnCount()) break;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    public boolean canEntitySpawnSpawner(EntityLiving entity, World world, float x, float y, float z, MobSpawnerBaseLogic spawner) {
        Event.Result result = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)x, (float)y, (float)z, (MobSpawnerBaseLogic)spawner);
        if (result == Event.Result.DEFAULT) {
            return (((TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.value).ignoreSpawnReq() || entity.func_70601_bi()) && entity.func_70058_J();
        }
        return result == Event.Result.ALLOW;
    }

    private void resetTimer() {
        TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.value;
        if (tier.getMaxDelay() <= tier.getMinDelay()) {
            this.tile.spawnDelay.value = (short)tier.getMinDelay();
        } else {
            int i = tier.getMaxDelay() - tier.getMinDelay();
            this.tile.spawnDelay.value = (short)(tier.getMinDelay() + this.func_98271_a().field_73012_v.nextInt(i));
        }
        this.func_98267_a(1);
    }

    public boolean func_98268_b(int delay) {
        return false;
    }

    public Entity func_184994_d() {
        return this.tile.getRenderEntity();
    }

    public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public double func_177222_d() {
        return this.mobRotation;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_177223_e() {
        return this.prevMobRotation;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return super.getSpawnerEntity();
    }

    public boolean func_98279_f() {
        return this.tile.isActive();
    }

    public void func_98267_a(int id) {
        this.tile.func_145831_w().func_175641_c(this.tile.func_174877_v(), Blocks.field_150474_ac, id, 0);
    }

    public World func_98271_a() {
        return this.tile.func_145831_w();
    }

    public BlockPos func_177221_b() {
        return this.tile.func_174877_v();
    }

    public NBTTagCompound func_189530_b(NBTTagCompound p_189530_1_) {
        return p_189530_1_;
    }

    public void func_98270_a(NBTTagCompound nbt) {
    }
}

