/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.spritesets.SpriteSetPlayer;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class SpriteInfo {
    private final String name;
    private TextureAtlasSprite sprite;
    private SpriteSetPlayer spriteSetPlayer;

    public SpriteInfo(String name, int size, int tickDelay) {
        this.name = name;
        if (size > 0) {
            this.spriteSetPlayer = new SpriteSetPlayer(tickDelay, size);
        }
    }

    public boolean isSpriteSet() {
        return this.spriteSetPlayer != null;
    }

    public ResourceLocation getResLocationName() {
        return this.getResLocationName(0);
    }

    public ResourceLocation getResLocationName(int index) {
        if (this.isSpriteSet()) {
            return new ResourceLocation("watut:particles/" + this.name + index);
        }
        return new ResourceLocation("watut:particles/" + this.name);
    }

    public void setupSprites(TextureAtlas textureAtlas) {
        if (this.isSpriteSet()) {
            ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
            for (int i = 0; i < this.spriteSetPlayer.getFrames(); ++i) {
                TextureAtlasSprite textureAtlasSprite = textureAtlas.m_118316_(this.getResLocationName(i));
                if (textureAtlasSprite != null) {
                    list.add(textureAtlasSprite);
                    continue;
                }
                CULog.dbg((String)("failed to find " + this.getResLocationName(i)));
            }
            this.spriteSetPlayer.setList(list);
            this.sprite = (TextureAtlasSprite)list.get(0);
        } else {
            this.sprite = textureAtlas.m_118316_(this.getResLocationName());
            if (this.sprite == null) {
                CULog.dbg((String)("failed to find " + this.getResLocationName()));
            }
        }
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public String getName() {
        return this.name;
    }

    public SpriteSetPlayer getSpriteSet() {
        return this.spriteSetPlayer;
    }

    public void setSpriteSetPlayer(SpriteSetPlayer spriteSetPlayer) {
        this.spriteSetPlayer = spriteSetPlayer;
    }
}

