/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.config;

import com.google.common.collect.Lists;
import com.leclowndu93150.wakes.config.enums.EffectSpawningRule;
import com.leclowndu93150.wakes.config.enums.Resolution;
import com.leclowndu93150.wakes.render.WakeColor;
import com.leclowndu93150.wakes.render.enums.RenderType;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class WakesConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final General GENERAL;
    public static final Appearance APPEARANCE;
    public static final Debug DEBUG;

    public static WakeColor getWakeColor(int i) {
        return new WakeColor((String)((List)WakesConfig.APPEARANCE.wakeColors.get()).get(i));
    }

    static {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        GENERAL = new General(clientBuilder);
        APPEARANCE = new Appearance(clientBuilder);
        DEBUG = new Debug(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
    }

    public static class Appearance {
        public final ForgeConfigSpec.EnumValue<Resolution> wakeResolution;
        public final ForgeConfigSpec.DoubleValue wakeOpacity;
        public final ForgeConfigSpec.DoubleValue blendStrength;
        public final ForgeConfigSpec.BooleanValue firstPersonSplashPlane;
        public final ForgeConfigSpec.BooleanValue spawnParticles;
        public final ForgeConfigSpec.DoubleValue shaderLightPassthrough;
        public final ForgeConfigSpec.DoubleValue splashPlaneWidth;
        public final ForgeConfigSpec.DoubleValue splashPlaneHeight;
        public final ForgeConfigSpec.DoubleValue splashPlaneDepth;
        public final ForgeConfigSpec.DoubleValue splashPlaneOffset;
        public final ForgeConfigSpec.DoubleValue splashPlaneGap;
        public final ForgeConfigSpec.IntValue splashPlaneResolution;
        public final ForgeConfigSpec.DoubleValue maxSplashPlaneVelocity;
        public final ForgeConfigSpec.DoubleValue splashPlaneScale;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> wakeColorIntervals;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wakeColors;

        public Appearance(ForgeConfigSpec.Builder builder) {
            this.wakeResolution = builder.defineEnum("wakeResolution", (Enum)Resolution.SIXTEEN);
            this.wakeOpacity = builder.defineInRange("wakeOpacity", 1.0, 0.0, 1.0);
            this.blendStrength = builder.defineInRange("blendStrength", 0.5, 0.0, 1.0);
            this.firstPersonSplashPlane = builder.define("firstPersonSplashPlane", false);
            this.spawnParticles = builder.define("spawnParticles", true);
            this.shaderLightPassthrough = builder.defineInRange("shaderLightPassthrough", 0.5, 0.0, 1.0);
            builder.comment("Splash Plane Settings").push("splashPlane");
            this.splashPlaneWidth = builder.defineInRange("splashPlaneWidth", 2.0, -5.0, 5.0);
            this.splashPlaneHeight = builder.defineInRange("splashPlaneHeight", 1.5, -5.0, 5.0);
            this.splashPlaneDepth = builder.defineInRange("splashPlaneDepth", 3.0, -5.0, 5.0);
            this.splashPlaneOffset = builder.defineInRange("splashPlaneOffset", 0.0, -5.0, 5.0);
            this.splashPlaneGap = builder.defineInRange("splashPlaneGap", 1.0, -5.0, 5.0);
            this.splashPlaneResolution = builder.defineInRange("splashPlaneResolution", 5, 0, 10);
            this.maxSplashPlaneVelocity = builder.defineInRange("maxSplashPlaneVelocity", 0.5, -5.0, 5.0);
            this.splashPlaneScale = builder.defineInRange("splashPlaneScale", 0.8, -5.0, 5.0);
            builder.pop();
            ArrayList defaultWakeColorIntervals = Lists.newArrayList((Object[])new Double[]{0.05, 0.15, 0.2, 0.35, 0.52, 0.6, 0.7, 0.9});
            ArrayList defaultWakeColors = Lists.newArrayList((Object[])new String[]{"#00000000", "#289399a6", "#649ea5b0", "#b4c4cad1", "#00000000", "#b4c4cad1", "#ffffffff", "#b4c4cad1", "#649ea5b0"});
            this.wakeColorIntervals = builder.defineList("wakeColorIntervals", (List)defaultWakeColorIntervals, obj -> obj instanceof Double);
            this.wakeColors = builder.defineList("wakeColors", (List)defaultWakeColors, obj -> obj instanceof String);
        }
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue disableMod;
        public final ForgeConfigSpec.BooleanValue pickBoat;
        public final ForgeConfigSpec.EnumValue<EffectSpawningRule> boatSpawning;
        public final ForgeConfigSpec.EnumValue<EffectSpawningRule> playerSpawning;
        public final ForgeConfigSpec.EnumValue<EffectSpawningRule> otherPlayersSpawning;
        public final ForgeConfigSpec.EnumValue<EffectSpawningRule> mobSpawning;
        public final ForgeConfigSpec.EnumValue<EffectSpawningRule> itemSpawning;
        public final ForgeConfigSpec.DoubleValue wavePropagationFactor;
        public final ForgeConfigSpec.DoubleValue waveDecayFactor;
        public final ForgeConfigSpec.IntValue initialStrength;
        public final ForgeConfigSpec.IntValue paddleStrength;
        public final ForgeConfigSpec.IntValue splashStrength;

        public General(ForgeConfigSpec.Builder builder) {
            this.disableMod = builder.comment("Disable the mod functionality").define("disableMod", false);
            this.pickBoat = builder.define("pickBoat", true);
            builder.comment("Spawning Rules").push("spawningRules");
            this.boatSpawning = builder.defineEnum("boatSpawning", (Enum)EffectSpawningRule.SIMULATION_AND_PLANES);
            this.playerSpawning = builder.defineEnum("playerSpawning", (Enum)EffectSpawningRule.ONLY_SIMULATION);
            this.otherPlayersSpawning = builder.defineEnum("otherPlayersSpawning", (Enum)EffectSpawningRule.ONLY_SIMULATION);
            this.mobSpawning = builder.defineEnum("mobSpawning", (Enum)EffectSpawningRule.ONLY_SIMULATION);
            this.itemSpawning = builder.defineEnum("itemSpawning", (Enum)EffectSpawningRule.ONLY_SIMULATION);
            builder.pop();
            builder.comment("Wake Behavior").push("wakeBehavior");
            this.wavePropagationFactor = builder.defineInRange("wavePropagationFactor", 0.95, 0.0, 1.0);
            this.waveDecayFactor = builder.defineInRange("waveDecayFactor", 0.5, 0.0, 1.0);
            this.initialStrength = builder.defineInRange("initialStrength", 20, 0, Integer.MAX_VALUE);
            this.paddleStrength = builder.defineInRange("paddleStrength", 100, 0, Integer.MAX_VALUE);
            this.splashStrength = builder.defineInRange("splashStrength", 100, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Debug {
        public final ForgeConfigSpec.BooleanValue debugColors;
        public final ForgeConfigSpec.BooleanValue drawDebugBoxes;
        public final ForgeConfigSpec.BooleanValue showDebugInfo;
        public final ForgeConfigSpec.IntValue floodFillDistance;
        public final ForgeConfigSpec.IntValue floodFillTickDelay;
        public final ForgeConfigSpec.EnumValue<RenderType> renderType;

        public Debug(ForgeConfigSpec.Builder builder) {
            this.debugColors = builder.define("debugColors", false);
            this.drawDebugBoxes = builder.define("drawDebugBoxes", false);
            this.showDebugInfo = builder.define("showDebugInfo", false);
            this.floodFillDistance = builder.defineInRange("floodFillDistance", 2, 1, 6);
            this.floodFillTickDelay = builder.defineInRange("floodFillTickDelay", 2, 1, 20);
            this.renderType = builder.defineEnum("renderType", (Enum)RenderType.AUTO);
        }
    }
}

