/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class StormbringerSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    int radius = 3;
    int ability_timer_max = (int)Config.getFloat("shockDeflectBlockDuration", "UniqueEffects", ConfigDefaultValues.shockDeflectBlockDuration);
    int skillCooldown = (int)Config.getFloat("shockDeflectCooldown", "UniqueEffects", ConfigDefaultValues.shockDeflectCooldown);
    int perfectParryWindow = (int)Config.getFloat("shockDeflectParryDuration", "UniqueEffects", ConfigDefaultValues.shockDeflectParryDuration);
    float abilityDamage = Config.getFloat("shockDeflectDamage", "UniqueEffects", ConfigDefaultValues.shockDeflectDamage);
    float spellScalingModifier = Config.getFloat("shockDeflectSpellScaling", "UniqueEffects", ConfigDefaultValues.shockDeflectSpellScaling);
    boolean parrySuccess;
    int parrySuccession;

    public StormbringerSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_02.get(), user.m_5720_(), 0.8f, (float)((double)0.8f * ((double)this.parrySuccession * 0.1)));
        user.m_147207_(new MobEffectInstance(MobEffects.f_19617_, this.ability_timer_max, 2), (Entity)user);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_) {
            if (remainingUseTicks <= 2) {
                user.m_21253_();
            }
            AABB box = new AABB(user.m_20185_() + (double)this.radius, user.m_20186_() + (double)this.radius, user.m_20189_() + (double)this.radius, user.m_20185_() - (double)this.radius, user.m_20186_() - (double)this.radius, user.m_20189_() - (double)this.radius);
            for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || !le.f_20911_ || remainingUseTicks <= this.m_8105_(stack) - this.perfectParryWindow) continue;
                this.parrySuccess = true;
                if (this.parrySuccession < 20) {
                    ++this.parrySuccession;
                }
                user.m_21253_();
                le.f_20911_ = false;
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_01.get(), user.m_5720_(), 1.0f, (float)((double)0.8f * ((double)this.parrySuccession * 0.1)));
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_) {
            if (this.parrySuccess) {
                AABB box = new AABB(user.m_20185_() + (double)this.radius, user.m_20186_() + (double)this.radius, user.m_20189_() + (double)this.radius, user.m_20185_() - (double)this.radius, user.m_20186_() - (double)this.radius, user.m_20189_() - (double)this.radius);
                for (Entity entities : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    le.m_6469_(user.m_269291_().m_269104_((Entity)user, (Entity)user), this.abilityDamage + (float)this.parrySuccession);
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.m_5720_(), 0.3f, choose);
                    le.m_20334_(le.m_20185_() - user.m_20185_(), 0.1, le.m_20189_() - user.m_20189_());
                    user.m_20256_(le.m_20154_().m_82490_(1.5));
                    user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                    user.f_19864_ = true;
                }
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_IMPACT_01.get(), user.m_5720_(), (float)((double)0.2f * ((double)this.parrySuccession * 0.04)), 0.8f);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown / 2 + this.parrySuccession * 2);
                }
            }
            if (!this.parrySuccess) {
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown);
                }
                this.parrySuccession = 0;
            }
            this.parrySuccess = false;
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.ability_timer_max;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "lightning") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "lightning");
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123757_, ParticleTypes.f_123757_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stormbringersworditem.tooltip11").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleLightning"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

