/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class LichbladeSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    float overallAbsorptionCap = Config.getFloat("abilityAbsorptionCap", "UniqueEffects", ConfigDefaultValues.abilityAbsorptionCap);
    int radius = (int)Config.getFloat("soulAnguishRadius", "UniqueEffects", ConfigDefaultValues.soulAnguishRadius);
    float absorptionCap = Config.getFloat("soulAnguishAbsorptionCap", "UniqueEffects", ConfigDefaultValues.soulAnguishAbsorptionCap);
    float abilityDamage = Config.getFloat("soulAnguishDamage", "UniqueEffects", ConfigDefaultValues.soulAnguishDamage);
    int maxDuration = (int)Config.getFloat("soulAnguishDuration", "UniqueEffects", ConfigDefaultValues.soulAnguishDuration);
    int skillCooldown = (int)Config.getFloat("soulAnguishCooldown", "UniqueEffects", ConfigDefaultValues.soulAnguishCooldown);
    float healAmount = Config.getFloat("soulAnguishHeal", "UniqueEffects", ConfigDefaultValues.soulAnguishHeal);
    int range = (int)Config.getFloat("soulAnguishRange", "UniqueEffects", ConfigDefaultValues.soulAnguishRange);
    float spellScalingModifier = Config.getFloat("soulAnguishSpellScaling", "UniqueEffects", ConfigDefaultValues.soulAnguishSpellScaling);
    public int damageTracker = 0;
    double lastX;
    double lastY;
    double lastZ;
    double targetX;
    double targetY;
    double targetZ;
    LivingEntity abilityTarget;

    public LichbladeSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (itemStack.m_150930_((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        this.abilityTarget = (LivingEntity)HelperMethods.getTargetedEntity((Entity)user, this.range);
        if (this.abilityTarget != null) {
            this.abilityTarget.m_147207_(new MobEffectInstance(MobEffects.f_19619_, 10, 0), (Entity)user);
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.m_5720_(), 0.5f, 0.5f);
            this.lastX = user.m_20185_();
            this.lastY = user.m_20186_();
            this.lastZ = user.m_20189_();
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.m_5776_() && user.m_6844_(EquipmentSlot.MAINHAND) == stack && this.abilityTarget != null) {
            if (stack.m_150930_((Item)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                if (this.abilityTarget.m_21224_() || this.abilityTarget == user || remainingUseTicks < this.maxDuration) {
                    this.abilityTarget = user;
                    if (user.m_20275_(this.lastX, this.lastY, this.lastZ) < (double)this.radius) {
                        user.m_7911_(Math.min(this.overallAbsorptionCap, user.m_6103_() + Math.min((float)this.damageTracker / 2.0f, this.absorptionCap)));
                        user.m_21253_();
                        world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_SPELL.get(), user.m_5720_(), 0.04f, 0.5f);
                    }
                }
            } else if (stack.m_150930_((Item)ItemsRegistry.WAKING_LICHBLADE.get()) && (this.abilityTarget.m_21224_() || remainingUseTicks < this.maxDuration)) {
                user.m_21253_();
            }
            if (user.f_19797_ % 5 == 0) {
                this.targetX = this.abilityTarget.m_20185_();
                this.targetY = this.abilityTarget.m_20186_();
                this.targetZ = this.abilityTarget.m_20189_();
                if (this.targetX > this.lastX) {
                    this.lastX += 1.0;
                }
                if (this.targetX < this.lastX) {
                    this.lastX -= 1.0;
                }
                if (this.targetZ > this.lastZ) {
                    this.lastZ += 1.0;
                }
                if (this.targetZ < this.lastZ) {
                    this.lastZ -= 1.0;
                }
                if (this.targetY > this.lastY) {
                    this.lastY += 1.0;
                }
                if (this.targetY < this.lastY) {
                    this.lastY -= 1.0;
                }
            }
            AbilityMethods.tickAbilitySoulAnguish(stack, world, user, this.abilityDamage, this.radius, this.lastX, this.lastY, this.lastZ, this.healAmount, this.abilityTarget);
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.maxDuration * 2;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.damageTracker = 0;
        if (!world.f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            if (this.abilityTarget != null) {
                player.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown);
            }
        }
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity user, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, user, "soul") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, user, "soul");
            scalesWithSpellPower = true;
        }
        if (!user.m_9236_().m_5776_() && user instanceof LivingEntity) {
            LivingEntity livingUser = (LivingEntity)user;
            if (livingUser.f_19797_ % 35 == 0 && livingUser.m_6844_(EquipmentSlot.MAINHAND) == stack && !livingUser.m_6117_()) {
                AABB box = new AABB(livingUser.m_20185_() + (double)this.radius, livingUser.m_20186_() + (double)this.radius, livingUser.m_20189_() + (double)this.radius, livingUser.m_20185_() - (double)this.radius, livingUser.m_20186_() - (double)this.radius, livingUser.m_20189_() - (double)this.radius);
                for (Entity entity : world.m_6249_((Entity)livingUser, box, EntitySelector.f_20403_)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)entity;
                    if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, livingUser)) continue;
                    le.m_6469_(livingUser.m_269291_().m_269104_(user, user), this.abilityDamage);
                }
                world.m_6269_(null, (Entity)livingUser, (SoundEvent)SoundRegistry.DARK_SWORD_BLOCK.get(), livingUser.m_5720_(), 0.1f, 0.2f);
                double xpos = livingUser.m_20185_() - (double)(this.radius + 1);
                double ypos = livingUser.m_20186_();
                double zpos = livingUser.m_20189_() - (double)(this.radius + 1);
                for (int i = this.radius * 2; i > 0; --i) {
                    for (int j = this.radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_235898_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123746_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123757_, xpos + (double)i + (double)choose, ypos + 2.0, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(user, stack, world, stepMod, ParticleTypes.f_123746_, ParticleTypes.f_123746_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, user, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        if (itemStack.m_150930_((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip1").m_6270_(ABILITY));
        } else if (itemStack.m_150930_((Item)ItemsRegistry.WAKING_LICHBLADE.get())) {
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip1.2").m_6270_(ABILITY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip1.3").m_6270_(ABILITY));
        }
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.lichbladesworditem.tooltip3", (Object[])new Object[]{this.radius}).m_6270_(TEXT));
        if (!itemStack.m_150930_((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip4").m_6270_(TEXT));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip5").m_6270_(TEXT));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip6").m_6270_(TEXT));
            if (itemStack.m_150930_((Item)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip7").m_6270_(TEXT));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip8").m_6270_(TEXT));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.lichbladesworditem.tooltip9").m_6270_(TEXT));
            }
        }
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleSoul"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

