/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class ArcanethystSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    int radius = (int)Config.getFloat("arcaneAssaultRadius", "UniqueEffects", ConfigDefaultValues.arcaneAssaultRadius);
    float abilityDamage = Config.getFloat("arcaneAssaultDamage", "UniqueEffects", ConfigDefaultValues.arcaneAssaultDamage);
    int arcane_timer_max = (int)Config.getFloat("arcaneAssaultDuration", "UniqueEffects", ConfigDefaultValues.arcaneAssaultDuration);
    int skillCooldown = (int)Config.getFloat("arcaneAssaultCooldown", "UniqueEffects", ConfigDefaultValues.arcaneAssaultCooldown);
    int chargeChance = (int)Config.getFloat("arcaneAssaultChance", "UniqueEffects", ConfigDefaultValues.arcaneAssaultChance);
    int spellScalingModifier = (int)Config.getFloat("arcaneAssaultSpellScaling", "UniqueEffects", ConfigDefaultValues.arcaneAssaultSpellScaling);

    public ArcanethystSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= this.chargeChance) {
                target.m_147207_(new MobEffectInstance(MobEffects.f_19620_, 60, 1), (Entity)attacker);
                attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_01.get(), attacker.m_5720_(), 0.5f, 1.2f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            ItemStack itemStack = user.m_21120_(hand);
            if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.4f, 1.2f);
            user.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.m_6844_(EquipmentSlot.MAINHAND) == stack && user instanceof Player) {
            AbilityMethods.tickAbilityArcaneAssault(stack, world, user, remainingUseTicks, this.arcane_timer_max, this.abilityDamage, this.skillCooldown, this.radius);
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.arcane_timer_max;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            player.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown);
        }
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "arcane") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "arcane");
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123799_, ParticleTypes.f_123799_, ParticleTypes.f_123789_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.arcanethystsworditem.tooltip6").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleArcane"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

