/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FatalFlickerEffect
extends MobEffect {
    public FatalFlickerEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public static void performDash(LivingEntity user, Level world, int radius) {
        LivingEntity le;
        int dashDistance = (int)Config.getFloat("fatalFlickerDashVelocity", "UniqueEffects", ConfigDefaultValues.fatalFlickerDashVelocity);
        int maxAmplifier = (int)Config.getFloat("fatalFlickerMaxStacks", "UniqueEffects", ConfigDefaultValues.fatalFlickerMaxStacks);
        int amplifier = 1;
        user.m_20256_(user.m_20154_().m_82490_((double)dashDistance));
        user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
        user.f_19864_ = true;
        user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 10, 3), (Entity)user);
        user.f_19802_ = 25;
        AABB box = HelperMethods.createBox((Entity)user, radius);
        List entities = world.m_6249_((Entity)user, box, EntitySelector.f_20403_);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
            ++amplifier;
        }
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
            HelperMethods.incrementStatusEffect(le, (MobEffect)EffectRegistry.ECHO.get(), 20, amplifier, maxAmplifier);
        }
        AABB boxPull = HelperMethods.createBox((Entity)user, radius * 2);
        for (Entity entity : world.m_6249_((Entity)user, boxPull, EntitySelector.f_20403_)) {
            LivingEntity le2;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le2 = (LivingEntity)entity, user)) continue;
            le2.m_20334_((user.m_20185_() - le2.m_20185_()) / 4.0, (user.m_20186_() - le2.m_20186_()) / 4.0, (user.m_20189_() - le2.m_20189_()) / 4.0);
        }
    }

    public void m_6742_(LivingEntity user, int amplifier) {
        super.m_6742_(user, amplifier);
        if (!user.m_9236_().m_5776_()) {
            int ability_timer = Objects.requireNonNull(user.m_21124_((MobEffect)EffectRegistry.FATAL_FLICKER.get())).m_19557_();
            Level world = user.m_9236_();
            int radius = (int)Config.getFloat("fatalFlickerRadius", "UniqueEffects", ConfigDefaultValues.fatalFlickerRadius);
            if (ability_timer >= 5) {
                FatalFlickerEffect.performDash(user, world, radius);
            } else {
                user.m_20334_(0.0, 0.0, 0.0);
                user.f_19864_ = true;
            }
            if (user.f_19797_ % 2 == 0) {
                int particleRadius = (int)((double)radius * 0.5);
                double xpos = user.m_20185_() - (double)(particleRadius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(particleRadius + 1);
                for (int i = particleRadius * 2; i > 0; --i) {
                    for (int j = particleRadius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_175830_, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123796_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123785_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }
}

