/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.PlatformFunctions;
import com.minenash.seamless_loading_screen.SeamlessLoadingScreen;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30;
import org.slf4j.Logger;

public class ScreenshotLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ResourceLocation SCREENSHOT = new ResourceLocation("seamless_loading_screen", "screenshot");
    public static double imageRatio = 1.0;
    public static boolean loaded = false;
    public static DisplayMode displayMode = DisplayMode.ENABLED;
    public static boolean inFade = false;
    public static int time;
    public static float timeDelta;
    private static String fileName;
    private static final Pattern RESERVED_FILENAMES_PATTERN;
    public static boolean replacebg;

    public static String getFileName() {
        return fileName;
    }

    public static void setScreenshot(String address, int port) {
        ScreenshotLoader.setFileName("screenshots/worlds/servers/" + ScreenshotLoader.cleanFileName(address) + "_" + port + ".png");
    }

    public static void setScreenshot(String worldName) {
        ScreenshotLoader.setFileName("screenshots/worlds/singleplayer/" + worldName + ".png");
    }

    public static void setRealmScreenshot(String realmName) {
        ScreenshotLoader.setFileName("screenshots/worlds/realms/" + ScreenshotLoader.cleanFileName(realmName) + ".png");
    }

    private static void setFileName(String newFileName) {
        fileName = newFileName;
        ScreenshotLoader.setScreenshot();
    }

    private static void setScreenshot() {
        loaded = false;
        if (displayMode == DisplayMode.DISABLED) {
            return;
        }
        try (FileInputStream in2 = new FileInputStream(fileName);){
            if (PlatformFunctions.isDevEnv()) {
                LOGGER.info("Name: " + fileName);
            }
            DynamicTexture image = new DynamicTexture(NativeImage.m_85058_((InputStream)in2));
            Minecraft.m_91087_().m_91097_().m_118495_(SCREENSHOT, (AbstractTexture)image);
            imageRatio = (double)image.m_117991_().m_84982_() / (double)image.m_117991_().m_85084_();
            loaded = true;
            time = Config.get().time;
            timeDelta = 1.0f / (float)Config.get().fade;
            replacebg = true;
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            LOGGER.error("[SeamlessLoadingScreen]: An Issue has occurred when attempting to set a Screenshot: [name: {}]", (Object)fileName);
            LOGGER.error(String.valueOf(e));
        }
    }

    private static String cleanFileName(String fileName) {
        for (char c : SharedConstants.f_136184_) {
            fileName = ((String)fileName).replace(c, '_');
        }
        if (RESERVED_FILENAMES_PATTERN.matcher((CharSequence)fileName).matches()) {
            fileName = "_" + (String)fileName + "_";
        }
        if (((String)fileName).length() > 251) {
            fileName = ((String)fileName).substring(0, 251);
        }
        return fileName;
    }

    public static void render(Screen screen, GuiGraphics context) {
        RenderSystem.enableBlend();
        int w = (int)(imageRatio * (double)screen.f_96544_);
        context.m_280163_(SCREENSHOT, screen.f_96543_ / 2 - w / 2, 0, 0.0f, 0.0f, w, screen.f_96544_, w, screen.f_96544_);
        ScreenshotLoader.renderAfterEffects(screen, context, 1.0f);
        RenderSystem.disableBlend();
    }

    public static void renderAfterEffects(Screen screen, GuiGraphics context, float fadeValue) {
        ScreenshotLoader.renderTint(screen, context, fadeValue);
        if (Config.get().enableScreenshotBlur && SeamlessLoadingScreen.BLUR_PROGRAM.loaded) {
            ScreenshotLoader.renderBlur(screen, context, Config.get().screenshotBlurStrength * fadeValue, Config.get().screenshotBlurQuality);
        }
    }

    public static void renderTint(Screen screen, GuiGraphics context, float fadeValue) {
        Color color = Config.get().tintColor;
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = Math.round(255.0f * (Config.get().tintStrength * fadeValue));
        int argb_color = ScreenshotLoader.getArgb(alpha, red, green, blue);
        context.m_280509_(0, 0, screen.f_96543_, screen.f_96544_, argb_color);
    }

    public static int getArgb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static void renderBlur(Screen screen, GuiGraphics context, float size, float quality) {
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix = context.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)screen.f_96544_, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)screen.f_96543_, (float)screen.f_96544_, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)screen.f_96543_, 0.0f, 0.0f).m_5752_();
        SeamlessLoadingScreen.BLUR_PROGRAM.setParameters(16, quality, size);
        SeamlessLoadingScreen.BLUR_PROGRAM.use();
        Tesselator.m_85913_().m_85914_();
    }

    static {
        fileName = "";
        RESERVED_FILENAMES_PATTERN = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
        replacebg = false;
    }

    public static class BlurHelper {
        private Uniform inputResolution;
        private Uniform directions;
        private Uniform quality;
        private Uniform size;
        private RenderTarget input;
        private ShaderInstance backingProgram;
        public boolean loaded = false;

        public void onWindowResize(Minecraft client, Window window) {
            if (this.input == null) {
                return;
            }
            this.input.m_83941_(window.m_85441_(), window.m_85442_(), Minecraft.f_91002_);
        }

        public void load(ShaderInstance backingProgram) {
            this.backingProgram = backingProgram;
            this.setup();
            this.loaded = true;
        }

        public void setParameters(int directions, float quality, float size) {
            this.directions.m_5985_((float)directions);
            this.size.m_5985_(size);
            this.quality.m_5985_(quality);
        }

        public void use() {
            RenderTarget buffer = Minecraft.m_91087_().m_91385_();
            this.input.m_83947_(false);
            GL30.glBindFramebuffer((int)36008, (int)buffer.f_83920_);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)buffer.f_83915_, (int)buffer.f_83916_, (int)0, (int)0, (int)buffer.f_83915_, (int)buffer.f_83916_, (int)16384, (int)9729);
            buffer.m_83947_(false);
            this.inputResolution.m_7971_((float)buffer.f_83915_, (float)buffer.f_83916_);
            this.backingProgram.m_173350_("InputSampler", (Object)this.input.m_83975_());
            RenderSystem.setShader(() -> this.backingProgram);
        }

        protected void setup() {
            this.inputResolution = this.findUniform("InputResolution");
            this.directions = this.findUniform("Directions");
            this.quality = this.findUniform("Quality");
            this.size = this.findUniform("Size");
            Window window = Minecraft.m_91087_().m_91268_();
            this.input = new TextureTarget(window.m_85441_(), window.m_85442_(), false, Minecraft.f_91002_);
        }

        private Uniform findUniform(String key) {
            return this.backingProgram.m_173348_(key);
        }
    }
}

