/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.ObjToIntMap;
import dev.latvian.mods.rhino.Parser;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Token;
import java.io.IOException;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final StringBuilder rawString = new StringBuilder();
    private final ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private final String sourceString;
    private final int sourceEnd;
    private final Parser parser;
    String regExpFlags;
    int lineno;
    int sourceCursor;
    int cursor;
    int tokenBeg;
    int tokenEnd;
    Token.CommentType commentType;
    private boolean dirtyLine;
    private String string = "";
    private double number;
    private boolean isBinary;
    private boolean isOldOctal;
    private boolean isOctal;
    private boolean isHex;
    private int quoteChar;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineEndChar = -1;

    static boolean isKeyword(String s, boolean isStrict) {
        return 0 != TokenStream.stringToKeyword(s, isStrict);
    }

    private static int stringToKeyword(String name, boolean isStrict) {
        return TokenStream.stringToKeywordForES(name, isStrict);
    }

    private static int stringToKeywordForES(String name, boolean isStrict) {
        return switch (name) {
            case "break" -> 121;
            case "case" -> 116;
            case "catch" -> 125;
            case "const" -> 155;
            case "continue" -> 122;
            case "default" -> 117;
            case "delete" -> 31;
            case "do" -> 119;
            case "else" -> 114;
            case "finally" -> 126;
            case "for" -> 120;
            case "function" -> 110;
            case "if" -> 113;
            case "in" -> 52;
            case "instanceof" -> 53;
            case "new" -> 30;
            case "return" -> 4;
            case "switch" -> 115;
            case "this" -> 43;
            case "throw" -> 50;
            case "try" -> 82;
            case "typeof" -> 32;
            case "var" -> 123;
            case "void" -> 127;
            case "while" -> 118;
            case "with" -> 124;
            case "yield" -> 73;
            case "false" -> 44;
            case "null" -> 42;
            case "true" -> 45;
            case "let" -> 154;
            case "class", "export", "static", "public", "protected", "private", "package", "interface", "implements", "enum", "await", "super", "import", "extends" -> 128;
            default -> 0;
        };
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || c == 65279 || Character.getType((char)c) == 12;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    private static String convertLastCharToHex(String str) {
        int lastIndex = str.length() - 1;
        StringBuilder buf = new StringBuilder(str.substring(0, lastIndex));
        buf.append("\\u");
        String hexCode = Integer.toHexString(str.charAt(lastIndex));
        for (int i = 0; i < 4 - hexCode.length(); ++i) {
            buf.append('0');
        }
        buf.append(hexCode);
        return buf.toString();
    }

    TokenStream(Parser parser, String sourceString, int lineno) {
        this.parser = parser;
        this.lineno = lineno;
        if (sourceString == null) {
            Kit.codeBug();
        }
        this.sourceString = sourceString;
        this.sourceEnd = sourceString.length();
        this.cursor = 0;
        this.sourceCursor = 0;
    }

    final String getSourceString() {
        return this.sourceString;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final char getQuoteChar() {
        return (char)this.quoteChar;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean isNumberBinary() {
        return this.isBinary;
    }

    final boolean isNumberOldOctal() {
        return this.isOldOctal;
    }

    final boolean isNumberOctal() {
        return this.isOctal;
    }

    final boolean isNumberHex() {
        return this.isHex;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int getToken() throws IOException {
        boolean lookForSlash;
        int c;
        block138: {
            block143: {
                double dval;
                String numString;
                boolean isEmpty;
                int base;
                block142: {
                    block141: {
                        boolean isUnicodeEscapeStart;
                        block139: {
                            block140: {
                                boolean identifierStart;
                                do {
                                    if ((c = this.getChar()) == -1) {
                                        this.tokenBeg = this.cursor - 1;
                                        this.tokenEnd = this.cursor;
                                        return 0;
                                    }
                                    if (c != 10) continue;
                                    this.dirtyLine = false;
                                    this.tokenBeg = this.cursor - 1;
                                    this.tokenEnd = this.cursor;
                                    return 1;
                                } while (TokenStream.isJSSpace(c));
                                if (c != 45) {
                                    this.dirtyLine = true;
                                }
                                this.tokenBeg = this.cursor - 1;
                                this.tokenEnd = this.cursor;
                                isUnicodeEscapeStart = false;
                                if (c == 92) {
                                    c = this.getChar();
                                    if (c == 117) {
                                        identifierStart = true;
                                        isUnicodeEscapeStart = true;
                                        this.stringBufferTop = 0;
                                    } else {
                                        identifierStart = false;
                                        this.ungetChar(c);
                                        c = 92;
                                    }
                                } else {
                                    identifierStart = Character.isJavaIdentifierStart((char)c);
                                    if (identifierStart) {
                                        this.stringBufferTop = 0;
                                        this.addToString(c);
                                    }
                                }
                                if (identifierStart) break block139;
                                if (!TokenStream.isDigit(c) && (c != 46 || !TokenStream.isDigit(this.peekChar()))) break block140;
                                this.stringBufferTop = 0;
                                base = 10;
                                this.isBinary = false;
                                this.isOctal = false;
                                this.isOldOctal = false;
                                this.isHex = false;
                                if (c == 48) {
                                    c = this.getChar();
                                    if (c == 120 || c == 88) {
                                        base = 16;
                                        this.isHex = true;
                                        c = this.getChar();
                                    } else if (c == 111 || c == 79) {
                                        base = 8;
                                        this.isOctal = true;
                                        c = this.getChar();
                                    } else if (c == 98 || c == 66) {
                                        base = 2;
                                        this.isBinary = true;
                                        c = this.getChar();
                                    } else if (TokenStream.isDigit(c)) {
                                        base = 8;
                                        this.isOldOctal = true;
                                    } else {
                                        this.addToString(48);
                                    }
                                }
                                isEmpty = true;
                                if (base != 16) break block141;
                                while (0 <= Kit.xDigitToInt(c, 0)) {
                                    this.addToString(c);
                                    c = this.getChar();
                                    isEmpty = false;
                                }
                                break block142;
                            }
                            if (c == 34 || c == 39) break block143;
                            switch (c) {
                                case 59: {
                                    return 83;
                                }
                                case 91: {
                                    return 84;
                                }
                                case 93: {
                                    return 85;
                                }
                                case 123: {
                                    return 86;
                                }
                                case 125: {
                                    return 87;
                                }
                                case 40: {
                                    return 88;
                                }
                                case 41: {
                                    return 89;
                                }
                                case 44: {
                                    return 90;
                                }
                                case 63: {
                                    if (this.matchChar(63)) {
                                        return 75;
                                    }
                                    if (this.matchChar(46)) {
                                        return 77;
                                    }
                                    return 103;
                                }
                                case 58: {
                                    return 104;
                                }
                                case 46: {
                                    return 109;
                                }
                                case 124: {
                                    if (this.matchChar(124)) {
                                        return 105;
                                    }
                                    if (this.matchChar(61)) {
                                        return 92;
                                    }
                                    return 9;
                                }
                                case 94: {
                                    if (this.matchChar(61)) {
                                        return 93;
                                    }
                                    return 10;
                                }
                                case 38: {
                                    if (this.matchChar(38)) {
                                        return 106;
                                    }
                                    if (this.matchChar(61)) {
                                        return 94;
                                    }
                                    return 11;
                                }
                                case 61: {
                                    if (this.matchChar(61)) {
                                        if (this.matchChar(61)) {
                                            return 46;
                                        }
                                        return 12;
                                    }
                                    if (this.matchChar(62)) {
                                        return 165;
                                    }
                                    return 91;
                                }
                                case 33: {
                                    if (!this.matchChar(61)) {
                                        return 26;
                                    }
                                    if (this.matchChar(61)) {
                                        return 47;
                                    }
                                    return 13;
                                }
                                case 60: {
                                    if (this.matchChar(33)) {
                                        if (this.matchChar(45)) {
                                            if (this.matchChar(45)) {
                                                this.tokenBeg = this.cursor - 4;
                                                this.skipLine();
                                                this.commentType = Token.CommentType.HTML;
                                                return 162;
                                            }
                                            this.ungetCharIgnoreLineEnd(45);
                                        }
                                        this.ungetCharIgnoreLineEnd(33);
                                    }
                                    if (this.matchChar(60)) {
                                        if (this.matchChar(61)) {
                                            return 95;
                                        }
                                        return 18;
                                    }
                                    if (this.matchChar(61)) {
                                        return 15;
                                    }
                                    return 14;
                                }
                                case 62: {
                                    if (this.matchChar(62)) {
                                        if (this.matchChar(62)) {
                                            if (this.matchChar(61)) {
                                                return 97;
                                            }
                                            return 20;
                                        }
                                        if (this.matchChar(61)) {
                                            return 96;
                                        }
                                        return 19;
                                    }
                                    if (this.matchChar(61)) {
                                        return 17;
                                    }
                                    return 16;
                                }
                                case 42: {
                                    if (this.matchChar(61)) {
                                        return 100;
                                    }
                                    if (this.matchChar(42)) {
                                        return 76;
                                    }
                                    return 23;
                                }
                                case 47: {
                                    this.markCommentStart();
                                    if (this.matchChar(47)) {
                                        this.tokenBeg = this.cursor - 2;
                                        this.skipLine();
                                        this.commentType = Token.CommentType.LINE;
                                        return 162;
                                    }
                                    if (this.matchChar(42)) {
                                        lookForSlash = false;
                                        this.tokenBeg = this.cursor - 2;
                                        if (this.matchChar(42)) {
                                            lookForSlash = true;
                                            this.commentType = Token.CommentType.JSDOC;
                                            break block138;
                                        } else {
                                            this.commentType = Token.CommentType.BLOCK_COMMENT;
                                        }
                                        break block138;
                                    } else {
                                        if (this.matchChar(61)) {
                                            return 101;
                                        }
                                        return 24;
                                    }
                                }
                                case 37: {
                                    if (this.matchChar(61)) {
                                        return 102;
                                    }
                                    return 25;
                                }
                                case 126: {
                                    return 27;
                                }
                                case 43: {
                                    if (this.matchChar(61)) {
                                        return 98;
                                    }
                                    if (this.matchChar(43)) {
                                        return 107;
                                    }
                                    return 21;
                                }
                                case 45: {
                                    if (this.matchChar(61)) {
                                        c = 99;
                                    } else if (this.matchChar(45)) {
                                        if (!this.dirtyLine && this.matchChar(62)) {
                                            this.markCommentStart("--");
                                            this.skipLine();
                                            this.commentType = Token.CommentType.HTML;
                                            return 162;
                                        }
                                        c = 108;
                                    } else {
                                        c = 22;
                                    }
                                    this.dirtyLine = true;
                                    return c;
                                }
                                case 96: {
                                    return 167;
                                }
                                default: {
                                    this.parser.addError("msg.illegal.character", c);
                                    return -1;
                                }
                            }
                        }
                        boolean containsEscape = isUnicodeEscapeStart;
                        while (true) {
                            int escapeVal;
                            if (isUnicodeEscapeStart) {
                                escapeVal = 0;
                            } else {
                                c = this.getChar();
                                if (c == 92) {
                                    c = this.getChar();
                                    if (c != 117) {
                                        this.parser.addError("msg.illegal.character", c);
                                        return -1;
                                    }
                                    isUnicodeEscapeStart = true;
                                    containsEscape = true;
                                    continue;
                                }
                                if (c != -1 && c != 65279 && Character.isJavaIdentifierPart((char)c)) {
                                    this.addToString(c);
                                    continue;
                                }
                                this.ungetChar(c);
                                String str = this.getStringFromBuffer();
                                if (!containsEscape) {
                                    int result = TokenStream.stringToKeyword(str, this.parser.inUseStrictDirective());
                                    if (result != 0) {
                                        this.string = (String)this.allStrings.intern(str);
                                        return result;
                                    }
                                } else if (TokenStream.isKeyword(str, this.parser.inUseStrictDirective())) {
                                    str = TokenStream.convertLastCharToHex(str);
                                }
                                this.string = (String)this.allStrings.intern(str);
                                return 39;
                            }
                            for (int i = 0; i != 4 && (escapeVal = Kit.xDigitToInt(c = this.getChar(), escapeVal)) >= 0; ++i) {
                            }
                            if (escapeVal < 0) {
                                this.parser.addError("msg.invalid.escape");
                                return -1;
                            }
                            this.addToString(escapeVal);
                            isUnicodeEscapeStart = false;
                        }
                    }
                    while (48 <= c && c <= 57) {
                        if (base == 8 && c >= 56) {
                            if (!this.isOldOctal) {
                                this.parser.addError("msg.caught.nfe");
                                return -1;
                            }
                            this.parser.addWarning("msg.bad.octal.literal", c == 56 ? "8" : "9");
                            base = 10;
                        } else if (base == 2 && c >= 50) {
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        this.addToString(c);
                        c = this.getChar();
                        isEmpty = false;
                    }
                }
                if (isEmpty && (this.isBinary || this.isOctal || this.isHex)) {
                    this.parser.addError("msg.caught.nfe");
                    return -1;
                }
                boolean isInteger = true;
                if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                    isInteger = false;
                    if (c == 46) {
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                    if (c == 101 || c == 69) {
                        this.addToString(c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            this.addToString(c);
                            c = this.getChar();
                        }
                        if (!TokenStream.isDigit(c)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                }
                this.ungetChar(c);
                this.string = numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.parseDouble(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    dval = ScriptRuntime.stringPrefixToNumber(numString, 0, base);
                }
                this.number = dval;
                return 40;
            }
            this.quoteChar = c;
            this.stringBufferTop = 0;
            c = this.getChar(false);
            block47: while (true) {
                if (c == this.quoteChar) {
                    String str = this.getStringFromBuffer();
                    this.string = (String)this.allStrings.intern(str);
                    return 41;
                }
                if (c == 10 || c == -1) {
                    this.ungetChar(c);
                    this.tokenEnd = this.cursor;
                    this.parser.addError("msg.unterminated.string.lit");
                    return -1;
                }
                if (c == 92) {
                    c = this.getChar();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: {
                            int escapeStart = this.stringBufferTop;
                            this.addToString(117);
                            int escapeVal = 0;
                            for (int i = 0; i != 4; ++i) {
                                c = this.getChar();
                                escapeVal = Kit.xDigitToInt(c, escapeVal);
                                if (escapeVal < 0) continue block47;
                                this.addToString(c);
                            }
                            this.stringBufferTop = escapeStart;
                            c = escapeVal;
                            break;
                        }
                        case 120: {
                            c = this.getChar();
                            int escapeVal = Kit.xDigitToInt(c, 0);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                continue block47;
                            }
                            int c1 = c;
                            c = this.getChar();
                            escapeVal = Kit.xDigitToInt(c, escapeVal);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                this.addToString(c1);
                                continue block47;
                            }
                            c = escapeVal;
                            break;
                        }
                        case 10: {
                            c = this.getChar();
                            continue block47;
                        }
                        default: {
                            if (48 > c || c >= 56) break;
                            int val = c - 48;
                            c = this.getChar();
                            if (48 <= c && c < 56) {
                                val = 8 * val + c - 48;
                                c = this.getChar();
                                if (48 <= c && c < 56 && val <= 31) {
                                    val = 8 * val + c - 48;
                                    c = this.getChar();
                                }
                            }
                            this.ungetChar(c);
                            c = val;
                        }
                    }
                }
                this.addToString(c);
                c = this.getChar(false);
            }
        }
        while (true) {
            if ((c = this.getChar()) == -1) {
                this.tokenEnd = this.cursor - 1;
                this.parser.addError("msg.unterminated.comment");
                return 162;
            }
            if (c == 42) {
                lookForSlash = true;
                continue;
            }
            if (c == 47) {
                if (!lookForSlash) continue;
                this.tokenEnd = this.cursor;
                return 162;
            }
            lookForSlash = false;
            this.tokenEnd = this.cursor;
        }
    }

    void readRegExp(int startToken) throws IOException {
        int c;
        int start = this.tokenBeg;
        this.stringBufferTop = 0;
        if (startToken == 101) {
            this.addToString(61);
        } else {
            if (startToken != 24) {
                Kit.codeBug();
            }
            if (this.peekChar() == 42) {
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
        }
        boolean inCharSet = false;
        while ((c = this.getChar()) != 47 || inCharSet) {
            if (c == 10 || c == -1) {
                this.ungetChar(c);
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
            if (c == 92) {
                this.addToString(c);
                c = this.getChar();
                if (c == 10 || c == -1) {
                    this.ungetChar(c);
                    this.tokenEnd = this.cursor - 1;
                    this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                    this.parser.reportError("msg.unterminated.re.lit");
                    return;
                }
            } else if (c == 91) {
                inCharSet = true;
            } else if (c == 93) {
                inCharSet = false;
            }
            this.addToString(c);
        }
        int reEnd = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (this.matchChar(109)) {
                this.addToString(109);
                continue;
            }
            if (!this.matchChar(121)) break;
            this.addToString(121);
        }
        this.tokenEnd = start + this.stringBufferTop + 2;
        if (TokenStream.isAlpha(this.peekChar())) {
            this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, reEnd);
        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
    }

    String readAndClearRegExpFlags() {
        String flags = this.regExpFlags;
        this.regExpFlags = null;
        return flags;
    }

    String getRawString() {
        if (this.rawString.length() == 0) {
            return "";
        }
        return this.rawString.toString();
    }

    private int getTemplateLiteralChar() throws IOException {
        boolean unget = this.ungetCursor != 0;
        int oldLineEnd = this.lineEndChar;
        int c = this.getCharIgnoreLineEnd(false);
        if (c == 10) {
            c = this.lineEndChar;
        }
        if (!(oldLineEnd < 0 || unget || oldLineEnd == 13 && c == 10)) {
            this.lineEndChar = -1;
            this.lineStart = this.sourceCursor - 1;
            ++this.lineno;
        }
        this.rawString.append((char)c);
        return c;
    }

    private void ungetTemplateLiteralChar(int c) {
        this.ungetCharIgnoreLineEnd(c);
        this.rawString.setLength(this.rawString.length() - 1);
    }

    private boolean matchTemplateLiteralChar(int test) throws IOException {
        int c = this.getTemplateLiteralChar();
        if (c == test) {
            return true;
        }
        this.ungetTemplateLiteralChar(c);
        return false;
    }

    private int peekTemplateLiteralChar() throws IOException {
        int c = this.getTemplateLiteralChar();
        this.ungetTemplateLiteralChar(c);
        return c;
    }

    int readTemplateLiteral() throws IOException {
        this.rawString.setLength(0);
        this.stringBufferTop = 0;
        block21: while (true) {
            int c = this.getTemplateLiteralChar();
            switch (c) {
                case -1: {
                    this.string = this.getStringFromBuffer();
                    this.tokenEnd = this.cursor - 1;
                    this.parser.reportError("msg.unexpected.eof");
                    return -1;
                }
                case 96: {
                    this.rawString.setLength(this.rawString.length() - 1);
                    this.string = this.getStringFromBuffer();
                    return 167;
                }
                case 36: {
                    if (this.matchTemplateLiteralChar(123)) {
                        this.rawString.setLength(this.rawString.length() - 2);
                        this.string = this.getStringFromBuffer();
                        this.tokenEnd = this.cursor - 1;
                        return 169;
                    }
                    this.addToString(c);
                    continue block21;
                }
                case 92: {
                    c = this.getTemplateLiteralChar();
                    switch (c) {
                        case 13: {
                            this.matchTemplateLiteralChar(10);
                            continue block21;
                        }
                        case 10: 
                        case 8232: 
                        case 8233: {
                            continue block21;
                        }
                        case 34: 
                        case 39: 
                        case 92: {
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 120: {
                            int escapeVal = 0;
                            escapeVal = Kit.xDigitToInt(this.getTemplateLiteralChar(), escapeVal);
                            escapeVal = Kit.xDigitToInt(this.getTemplateLiteralChar(), escapeVal);
                            if (escapeVal < 0) {
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            c = escapeVal;
                            break;
                        }
                        case 117: {
                            int escapeVal = 0;
                            c = this.getTemplateLiteralChar();
                            if (c == 123) {
                                c = this.getTemplateLiteralChar();
                                do {
                                    if ((escapeVal = Kit.xDigitToInt(c, escapeVal)) >= 0 && escapeVal <= 0x10FFFF) continue;
                                    this.parser.reportError("msg.syntax");
                                    return -1;
                                } while ((c = this.getTemplateLiteralChar()) != 125);
                                if (escapeVal > 65535) {
                                    this.addToString(Character.highSurrogate(escapeVal));
                                    this.addToString(Character.lowSurrogate(escapeVal));
                                    continue block21;
                                }
                                c = escapeVal;
                                break;
                            }
                            escapeVal = Kit.xDigitToInt(c, escapeVal);
                            escapeVal = Kit.xDigitToInt(this.getTemplateLiteralChar(), escapeVal);
                            escapeVal = Kit.xDigitToInt(this.getTemplateLiteralChar(), escapeVal);
                            escapeVal = Kit.xDigitToInt(this.getTemplateLiteralChar(), escapeVal);
                            if (escapeVal < 0) {
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            c = escapeVal;
                            break;
                        }
                        case 48: {
                            int d = this.peekTemplateLiteralChar();
                            if (d >= 48 && d <= 57) {
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            c = 0;
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.parser.reportError("msg.syntax");
                            return -1;
                        }
                    }
                    this.addToString(c);
                    continue block21;
                }
            }
            this.addToString(c);
        }
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c;
        this.stringBufferTop = N + 1;
    }

    private boolean canUngetChar() {
        return this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private boolean matchChar(int test) throws IOException {
        int c = this.getCharIgnoreLineEnd();
        if (c == test) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(c);
        return false;
    }

    private int peekChar() throws IOException {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() throws IOException {
        return this.getChar(true);
    }

    private int getChar(boolean skipFormattingChars) throws IOException {
        int c;
        block9: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceCursor == this.sourceEnd) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                c = this.sourceString.charAt(this.sourceCursor++);
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block9;
                }
                if (c == 65279) {
                    return c;
                }
                if (!skipFormattingChars || !TokenStream.isJSFormatChar(c)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private int getCharIgnoreLineEnd() throws IOException {
        return this.getCharIgnoreLineEnd(true);
    }

    private int getCharIgnoreLineEnd(boolean skipFormattingChars) throws IOException {
        int c;
        block6: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            do {
                if (this.sourceCursor == this.sourceEnd) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                if ((c = this.sourceString.charAt(this.sourceCursor++)) <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block6;
                }
                if (c != 65279) continue;
                return c;
            } while (skipFormattingChars && TokenStream.isJSFormatChar(c));
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private void ungetCharIgnoreLineEnd(int c) {
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
        this.tokenEnd = this.cursor;
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    private int charAt(int index) {
        return index < 0 || index >= this.sourceEnd ? -1 : (int)this.sourceString.charAt(index);
    }

    private String substring(int beginIndex, int endIndex) {
        return this.sourceString.substring(beginIndex, endIndex);
    }

    final String getLine() {
        int lineEnd = this.sourceCursor;
        if (this.lineEndChar >= 0) {
            if (this.lineEndChar == 10 && this.charAt(--lineEnd - 1) == 13) {
                --lineEnd;
            }
        } else {
            int c;
            int lineLength = lineEnd - this.lineStart;
            while ((c = this.charAt(this.lineStart + lineLength)) != -1 && !ScriptRuntime.isJSLineTerminator(c)) {
                ++lineLength;
            }
            lineEnd = this.lineStart + lineLength;
        }
        return this.substring(this.lineStart, lineEnd);
    }

    final String getLine(int position, int[] linep) {
        assert (position >= 0 && position <= this.cursor);
        assert (linep.length == 2);
        int delta = this.cursor + this.ungetCursor - position;
        int cur = this.sourceCursor;
        if (delta > cur) {
            return null;
        }
        int end = 0;
        int lines = 0;
        while (delta > 0) {
            assert (cur > 0);
            int c = this.charAt(cur - 1);
            if (ScriptRuntime.isJSLineTerminator(c)) {
                if (c == 10 && this.charAt(cur - 2) == 13) {
                    --delta;
                    --cur;
                }
                ++lines;
                end = cur - 1;
            }
            --delta;
            --cur;
        }
        int start = 0;
        int offset = 0;
        while (cur > 0) {
            int c = this.charAt(cur - 1);
            if (ScriptRuntime.isJSLineTerminator(c)) {
                start = cur;
                break;
            }
            --cur;
            ++offset;
        }
        linep[0] = this.lineno - lines + (this.lineEndChar >= 0 ? 1 : 0);
        linep[1] = offset;
        if (lines == 0) {
            return this.getLine();
        }
        return this.substring(start, end);
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getTokenBeg() {
        return this.tokenBeg;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getTokenLength() {
        return this.tokenEnd - this.tokenBeg;
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    private void markCommentStart() {
        this.markCommentStart("");
    }

    private void markCommentStart(String prefix) {
    }
}

