/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.socket.UdpServer;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.socket.NettyPacketHandler;
import su.plo.voice.server.socket.NettyUdpKeepAlive;
import su.plo.voice.socket.NettyPacketUdpDecoder;

public final class NettyUdpServer
implements UdpServer {
    private final EventLoopGroup loopGroup = new NioEventLoopGroup();
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final EventExecutorGroup executors = new DefaultEventExecutorGroup(Runtime.getRuntime().availableProcessors());
    private final BaseVoiceServer voiceServer;
    private NettyUdpKeepAlive keepAlive;
    private InetSocketAddress socketAddress;

    @Override
    public void start(String ip, int port) {
        this.keepAlive = new NettyUdpKeepAlive(this.voiceServer);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group(this.loopGroup)).channel(NioDatagramChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(@NotNull NioDatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyPacketUdpDecoder());
                pipeline.addLast(NettyUdpServer.this.executors, "handler", (ChannelHandler)new NettyPacketHandler(NettyUdpServer.this.voiceServer));
            }
        });
        try {
            ChannelFuture channelFuture = bootstrap.bind(ip, port).sync();
            this.channelGroup.add((Object)channelFuture.channel());
            this.socketAddress = (InetSocketAddress)channelFuture.channel().localAddress();
        }
        catch (InterruptedException e) {
            this.stop();
            return;
        }
        catch (Exception e) {
            this.stop();
            throw e;
        }
        BaseVoice.LOGGER.info("UDP server is started on {}", this.socketAddress);
    }

    @Override
    public void stop() {
        this.voiceServer.getUdpConnectionManager().clearConnections();
        if (this.keepAlive != null) {
            this.keepAlive.close();
        }
        this.channelGroup.close();
        this.loopGroup.shutdownGracefully();
        this.executors.shutdownGracefully();
        BaseVoice.LOGGER.info("UDP server is stopped", new Object[0]);
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return Optional.ofNullable(this.socketAddress);
    }

    public NettyUdpServer(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

