/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class ConnectionPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID secret;
    private String ip;
    private int port;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.secret = PacketUtil.readUUID(in);
        this.ip = in.readUTF();
        this.port = in.readInt();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.secret, (Object)"secret cannot be null");
        Preconditions.checkNotNull((Object)this.ip, (Object)"ip cannot be null");
        PacketUtil.writeUUID(out, this.secret);
        out.writeUTF(this.ip);
        out.writeInt(this.port);
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public ConnectionPacket(UUID secret, String ip, int port) {
        this.secret = secret;
        this.ip = ip;
        this.port = port;
    }

    public ConnectionPacket() {
    }

    public String toString() {
        return "ConnectionPacket(secret=" + this.getSecret() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ")";
    }

    public UUID getSecret() {
        return this.secret;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }
}

