/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class WaterSplashParticle
extends TextureSheetParticle {
    protected final SpriteSet provider;
    private final float width;
    private final float height;
    private final Color color;
    private final float unit;
    protected boolean colored = true;

    WaterSplashParticle(ClientLevel clientWorld, double x, double y, double z, float width, float height, SpriteSet provider) {
        super(clientWorld, x, y, z);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 18;
        this.width = width;
        this.height = height;
        this.provider = provider;
        this.m_108339_(provider);
        this.color = new Color(BiomeColors.m_108811_((BlockAndTintGetter)clientWorld, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z)));
        this.unit = 2.0f / (float)Minecraft.m_91087_().f_91061_.f_107296_.m_276092_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.provider);
        if (!this.f_107208_.m_6425_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        float ageDelta = Mth.m_14179_((float)tickDelta, (float)(this.f_107224_ - 1), (float)this.f_107224_);
        float progress = ageDelta / (float)this.f_107225_;
        float scale = this.width * (0.8f + 0.2f * progress);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f2 = vector3fs[i];
            vector3f2.mul(scale);
            vector3f2.add(f, g, h);
        }
        float l = this.m_5970_() + this.unit;
        float m = this.m_5952_() - this.unit;
        float n = this.m_5951_();
        float o = this.m_5950_();
        int light = this.m_6355_(tickDelta);
        int color = this.colored ? this.color.getRGB() : Color.white.getRGB();
        this.renderSide(vertexConsumer, vector3fs, 0, 1, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 1, 2, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 2, 3, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 3, 0, this.height, l, m, n, o, light, color);
    }

    private void renderSide(VertexConsumer vertexConsumer, Vector3f[] vector3fs, int a, int b, float height, float l, float m, float n, float o, int light, int color) {
        vertexConsumer.m_5483_((double)vector3fs[a].x(), (double)vector3fs[a].y(), (double)vector3fs[a].z()).m_7421_(l, o).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[b].x(), (double)vector3fs[b].y(), (double)vector3fs[b].z()).m_7421_(m, o).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[b].x(), (double)(vector3fs[b].y() + height), (double)vector3fs[b].z()).m_7421_(m, n).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[a].x(), (double)(vector3fs[a].y() + height), (double)vector3fs[a].z()).m_7421_(l, n).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[b].x(), (double)vector3fs[b].y(), (double)vector3fs[b].z()).m_7421_(m, o).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[a].x(), (double)vector3fs[a].y(), (double)vector3fs[a].z()).m_7421_(l, o).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[a].x(), (double)(vector3fs[a].y() + height), (double)vector3fs[a].z()).m_7421_(l, n).m_193479_(color).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[b].x(), (double)(vector3fs[b].y() + height), (double)vector3fs[b].z()).m_7421_(m, n).m_193479_(color).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double x, double y, double z, double g, double h, double i) {
            return new WaterSplashParticle(clientWorld, x, y, z, (float)g, (float)h, this.provider);
        }
    }
}

