/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.leaves;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LeafParticle
extends TextureSheetParticle {
    protected static final int fadeInDuration = 10;
    protected static final int rampUpDuration = 20;
    protected static final int fadeOutDuration = 100;
    protected float rotateFactor;
    protected float gravityFactor = 0.075f;
    protected final boolean flippedSprite;
    protected final int flippedDirection;
    protected boolean expiring = false;

    protected LeafParticle(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(world, x, y, z, r, g, b);
        this.m_108335_(provider);
        this.f_107219_ = true;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 200;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107230_ = 0.0f;
        this.f_107227_ = (float)r;
        this.f_107228_ = (float)g;
        this.f_107229_ = (float)b;
        this.rotateFactor = 6.0f + (float)Math.random() * 3.0f;
        this.flippedSprite = this.f_107223_.m_188499_();
        this.flippedDirection = this.f_107223_.m_188499_() ? 1 : -1;
        this.f_107663_ = 0.21875f;
    }

    protected float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    protected float getAngle() {
        int time = this.f_107224_ - 10;
        float speed = this.rotateFactor;
        float amplitude = this.clamp(time, 0.0f, 30.0f) / 30.0f;
        return (float)Math.sin((float)time / speed) * amplitude * 0.5f * (float)this.flippedDirection;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ <= 10) {
            this.f_107216_ = 0.0;
        } else if (!this.expiring && (this.f_107218_ || this.f_107216_ == 0.0)) {
            this.expiring = true;
            this.f_107224_ = this.f_107225_ - 100;
            this.f_107213_ += 0.01;
            if (((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
                this.f_107231_ = (Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatRightAngles.get() != false ? (float)((double)this.f_107223_.m_188503_(4) / 2.0 * Math.PI) : (float)(Math.random() * Math.PI * 2.0);
            }
        }
        this.f_107204_ = this.f_107231_;
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        FluidState fluidState = this.f_107208_.m_6425_(pos);
        if (fluidState.m_205070_(FluidTags.f_13131_)) {
            if (this.f_107226_ > 0.0f) {
                this.f_107213_ = (float)pos.m_123342_() + fluidState.m_76155_((BlockGetter)this.f_107208_, pos);
                if (((Boolean)ParticularConfig.COMMON.fallingLeavesSpawnRipples.get()).booleanValue()) {
                    this.f_107208_.m_7106_((ParticleOptions)Particles.WATER_RIPPLE.get(), this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                }
            }
            this.f_107216_ = 0.0;
            this.f_107226_ = 0.0f;
        } else if (this.f_107224_ >= 10) {
            this.f_107226_ = this.gravityFactor;
            if (!this.f_107218_) {
                this.f_107231_ = this.getAngle();
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vector3f[] vector3fs;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        float j = this.m_5902_(tickDelta);
        if (!this.expiring || !((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
            Quaternionf quaternionf;
            vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            if (this.f_107231_ == 0.0f) {
                quaternionf = camera.m_253121_();
            } else {
                quaternionf = new Quaternionf((Quaternionfc)camera.m_253121_());
                quaternionf.rotateZ(Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_));
            }
            for (int k = 0; k < 4; ++k) {
                Vector3f vector3f = vector3fs[k];
                vector3f.rotate((Quaternionfc)quaternionf);
                vector3f.mul(j);
                vector3f.add(f, g, h);
            }
        } else {
            vector3fs = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
            for (int k = 0; k < 4; ++k) {
                Vector3f vector3f = vector3fs[k];
                vector3f.rotateAxis(this.f_107231_, 0.0f, 1.0f, 0.0f);
                vector3f.mul(j);
                vector3f.add(f, g, h);
            }
        }
        float ageDelta = Mth.m_269140_((float)tickDelta, (int)this.f_107224_, (int)(this.f_107224_ + 1));
        this.f_107230_ = this.f_107224_ <= 10 ? ageDelta / 10.0f : (this.f_107224_ > this.f_107225_ - 100 ? Math.max(0.0f, ((float)this.f_107225_ - ageDelta) / 100.0f) : 1.0f);
        float l = this.m_5970_();
        float m = this.m_5952_();
        float n = this.m_5951_();
        float o = this.m_5950_();
        int p = this.m_6355_(tickDelta);
        if (this.flippedSprite) {
            float temp = l;
            l = m;
            m = temp;
        }
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(l, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(l, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(m, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(m, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new LeafParticle(world, x, y, z, velX, velY, velZ, this.provider);
        }
    }
}

