/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.mixin.AccessorBiome;
import com.leclowndu93150.particular.network.NetworkHandler;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="particular")
public class Main {
    public static final String MOD_ID = "particular";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particular");
    public static ResourceLocation currentDimension;
    public static ConcurrentHashMap<BlockPos, Integer> cascades;
    public static float fireflyFrequency;

    public Main() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOGGER.info("I am quite particular about the effects I choose to add :3");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ParticularConfig.COMMON_SPEC);
        Particles.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::init);
    }

    public static void updateCascade(Level world, BlockPos pos, FluidState state) {
        boolean shouldHaveCascade;
        BlockPos cascadePos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        boolean bl = shouldHaveCascade = state.m_192917_((Fluid)Fluids.f_76193_) && world.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76192_) && world.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_);
        if (shouldHaveCascade) {
            int strength = 0;
            if (world.m_6425_(pos.m_122012_()).m_192917_((Fluid)Fluids.f_76193_)) {
                ++strength;
            }
            if (world.m_6425_(pos.m_122029_()).m_192917_((Fluid)Fluids.f_76193_)) {
                ++strength;
            }
            if (world.m_6425_(pos.m_122019_()).m_192917_((Fluid)Fluids.f_76193_)) {
                ++strength;
            }
            if (world.m_6425_(pos.m_122024_()).m_192917_((Fluid)Fluids.f_76193_)) {
                ++strength;
            }
            if (strength > 0) {
                boolean isEncased;
                boolean bl2 = isEncased = !world.m_8055_(pos.m_7494_().m_122012_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122029_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122019_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122024_()).m_60795_();
                if (!isEncased) {
                    cascades.put(cascadePos, strength);
                } else {
                    cascades.remove(cascadePos);
                }
            } else {
                cascades.remove(cascadePos);
            }
        } else {
            cascades.remove(cascadePos);
        }
    }

    public static void spawnBubble(ParticleOptions particle, Level world, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.25 + world.f_46441_.m_188500_() * 0.5;
        double y = (double)pos.m_123342_() + 0.25 + world.f_46441_.m_188500_() * 0.5;
        double z = (double)pos.m_123343_() + 0.25 + world.f_46441_.m_188500_() * 0.5;
        world.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnFirefly(Level world, BlockPos pos, RandomSource random) {
        if (random.m_188500_() > (double)fireflyFrequency) {
            return;
        }
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        float downfall = ((AccessorBiome)biome).getWeather().f_47683_();
        if ((!world.m_46471_() || ((Boolean)ParticularConfig.COMMON.fireflyCanSpawnInRain.get()).booleanValue()) && random.m_188503_(30 - (int)(10.0f * downfall)) == 0) {
            long time = world.m_46468_();
            float temp = biome.m_47554_();
            if (time >= (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue() && time <= (long)((Integer)ParticularConfig.COMMON.fireflyEndTime.get()).intValue() && (double)temp >= (Double)ParticularConfig.COMMON.fireflyMinTemp.get() && (double)temp <= (Double)ParticularConfig.COMMON.fireflyMaxTemp.get()) {
                world.m_7106_((ParticleOptions)Particles.FIREFLY.get(), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnDoubleBubbles(ParticleOptions particle, Level world, BlockPos pos, BlockState state) {
        ChestType chestType = (ChestType)state.m_61143_((Property)BlockStateProperties.f_61392_);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case NORTH: {
                xLen = true;
                if (chestType != ChestType.RIGHT) break;
                xOffset = -1;
                break;
            }
            case SOUTH: {
                xLen = true;
                if (chestType != ChestType.LEFT) break;
                xOffset = -1;
                break;
            }
            case EAST: {
                zLen = true;
                if (chestType != ChestType.RIGHT) break;
                zOffset = -1;
                break;
            }
            case WEST: {
                zLen = true;
                if (chestType != ChestType.LEFT) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.m_123341_() + 0.25 + world.f_46441_.m_188500_() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.m_123342_() + 0.25 + world.f_46441_.m_188500_() * 0.5;
            double z = (double)pos.m_123343_() + 0.25 + world.f_46441_.m_188500_() * (0.5 + (double)zLen) + (double)zOffset;
            world.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnChestBubbles(ParticleOptions particle, Level world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            Main.spawnBubble(particle, world, pos);
        }
    }

    public static void spawnDoubleChestBubbles(ParticleOptions particle, Level world, BlockPos pos, BlockState state) {
        ChestType chestType = (ChestType)state.m_61143_((Property)BlockStateProperties.f_61392_);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case NORTH: {
                xLen = true;
                if (chestType != ChestType.RIGHT) break;
                xOffset = -1;
                break;
            }
            case SOUTH: {
                xLen = true;
                if (chestType != ChestType.LEFT) break;
                xOffset = -1;
                break;
            }
            case EAST: {
                zLen = true;
                if (chestType != ChestType.RIGHT) break;
                zOffset = -1;
                break;
            }
            case WEST: {
                zLen = true;
                if (chestType != ChestType.LEFT) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.m_123341_() + 0.25 + world.f_46441_.m_188500_() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.m_123342_() + 0.25 + world.f_46441_.m_188500_() * 0.5;
            double z = (double)pos.m_123343_() + 0.25 + world.f_46441_.m_188500_() * (0.5 + (double)zLen) + (double)zOffset;
            world.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static {
        cascades = new ConcurrentHashMap();
        fireflyFrequency = 1.0f;
    }
}

