/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.datagen;

import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGroveStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberStructure;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class StructureHandler {
    public static final ResourceKey<Structure> WROUGHT_CHAMBER = StructureHandler.createStructureKey("wrought_chamber");
    public static final ResourceKey<Structure> UMVUTHANA_GROVE = StructureHandler.createStructureKey("umvuthana_grove");
    public static final ResourceKey<Structure> FROSTMAW = StructureHandler.createStructureKey("frostmaw_spawn");
    public static final ResourceKey<Structure> MONASTERY = StructureHandler.createStructureKey("monastery");

    private static ResourceKey<Structure> createStructureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("mowziesmobs", name));
    }

    public static void bootstrap(BootstapContext<Structure> context) {
        context.m_255272_(WROUGHT_CHAMBER, (Object)new WroughtnautChamberStructure(StructureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.NONE, context)));
        context.m_255272_(UMVUTHANA_GROVE, (Object)new UmvuthanaGroveStructure(StructureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.NONE, context)));
        context.m_255272_(FROSTMAW, (Object)new FrostmawStructure(StructureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.BEARD_THIN, context)));
    }

    private static HolderSet<Biome> biomes(TagKey<Biome> biomeTag, BootstapContext<Structure> context) {
        return context.m_255420_(Registries.f_256952_).m_254956_(biomeTag);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> biomeTag, Map<MobCategory, StructureSpawnOverride> spawnOverrides, GenerationStep.Decoration generationStep, TerrainAdjustment terrainAdjustment, BootstapContext<Structure> context) {
        return new Structure.StructureSettings(StructureHandler.biomes(biomeTag, context), spawnOverrides, generationStep, terrainAdjustment);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> biomeTag, TerrainAdjustment terrainAdjustment, BootstapContext<Structure> context) {
        return StructureHandler.structure(biomeTag, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, terrainAdjustment, context);
    }
}

