/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.network.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.network.CloseCart;
import noobanidus.mods.lootr.network.OpenCart;
import noobanidus.mods.lootr.network.UpdateModelData;

public class ClientHandlers {
    public static void handleUpdateModel(UpdateModelData message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to update model data for location '" + message.pos + "' as level is null.");
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            LootrAPI.LOG.info("Unable to update model data for location '" + message.pos + "' as player is null.");
            return;
        }
        SectionPos pos = SectionPos.m_123199_((BlockPos)message.pos);
        Minecraft.m_91087_().f_91060_.m_109770_(pos.m_123170_(), pos.m_123206_(), pos.m_123222_());
    }

    public static void handleOpenCart(OpenCart message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as level is null.");
            return;
        }
        Entity cart = level.m_6815_(message.entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as entity is not a Lootr minecart.");
            return;
        }
        ((LootrChestMinecartEntity)cart).setOpened();
    }

    public static void handleCloseCart(CloseCart message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as level is null.");
            return;
        }
        Entity cart = level.m_6815_(message.entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as entity is not a Lootr minecart.");
            return;
        }
        ((LootrChestMinecartEntity)cart).setClosed();
    }
}

