/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.miauczel.legendary_monsters.entity.custom.ElectricityEntity;
import net.miauczel.legendary_monsters.entity.custom.LightningBoltEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class Axe_Of_LightningItem
extends AxeItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public static final UUID ATTACK_RANGE_MODIFIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public Axe_Of_LightningItem(Tier tier, Item.Properties properties) {
        super(tier, 12.5f, -2.8f, properties.m_41497_(Rarity.EPIC).m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 12.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if ((double)pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0) {
            pStack.m_41622_(2, pEntityLiving, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, -1);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == EnchantmentCategory.DIGGER || enchantment == Enchantments.f_44962_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos blockPos = context.m_8083_();
        if (player != null) {
            ItemStack itemstack = player.m_21120_(hand);
            if (!player.m_36335_().m_41519_((Item)this)) {
                double theta = (double)player.m_6080_() * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int numberOfSkulls = 5;
                float angleStep = 15.0f;
                player.m_5496_(SoundEvents.f_12558_, 1.0f, 0.9f);
                for (int i = 0; i < numberOfSkulls; ++i) {
                    float angle = player.m_6080_() + (float)(i - numberOfSkulls / 2) * angleStep;
                    float rad = (float)Math.toRadians(angle);
                    double dx = -Math.sin(rad);
                    double dz = Math.cos(rad);
                    AttributeInstance attackDamageAttribute = player.m_21051_(Attributes.f_22281_);
                    if (attackDamageAttribute == null) continue;
                    float damage = (float)attackDamageAttribute.m_22135_();
                    float y = Mth.m_14107_((double)player.m_20186_());
                    ElectricityEntity witherskull = new ElectricityEntity((LivingEntity)player, dx, 0.0, dz, player.m_9236_(), damage, angle, 20.0f);
                    double spawnX = player.m_20185_() + vecX * 1.0;
                    double spawnY = y;
                    double spawnZ = player.m_20189_() + vecZ * 1.0;
                    witherskull.m_6034_(spawnX, spawnY, spawnZ);
                    player.m_9236_().m_7967_((Entity)witherskull);
                    player.m_36335_().m_41524_((Item)this, 60);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        int standingOnY = Mth.m_14107_((double)player.m_20186_()) - 1;
        double headY = player.m_20186_() + 1.0;
        float yawRadians = (float)Math.toRadians(90.0f + player.m_146908_());
        boolean hasSucceeded = false;
        player.m_5496_(SoundEvents.f_12090_, 3.0f, 1.0f);
        for (int l = 0; l < 12; ++l) {
            double d2 = 1.25 * (double)(l + 1);
            if (!this.spawnFangs(player.m_20185_() + (double)Mth.m_14089_((float)yawRadians) * d2, headY, player.m_20189_() + (double)Mth.m_14031_((float)yawRadians) * d2, standingOnY, yawRadians, l, world, player)) continue;
            hasSucceeded = true;
        }
        ItemStack stack = player.m_21120_(hand);
        if (hasSucceeded) {
            player.m_36335_().m_41524_((Item)this, 90);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean spawnFangs(double x, double y, double z, int lowestYCheck, float yRot, int warmupDelayTicks, Level world, Player player) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= lowestYCheck);
        if (flag) {
            world.m_7967_((Entity)new LightningBoltEntity(world, x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelayTicks, (LivingEntity)player, 30, 8.0f));
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.axe_of_lightning1"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.axe_of_lightning2"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.axe_of_lightning3"));
    }
}

