/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownHalbert
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownHalbert.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownHalbert.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack spearItem = new ItemStack((ItemLike)ModItems.GOLDEN_HALBERT.get());
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownHalbert(EntityType<? extends ThrownHalbert> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownHalbert(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)ModEntities.GOLDEN_HALBERT.get(), pShooter, pLevel);
        this.spearItem = pStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)pStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)pStack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        float damage = 8.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingEntity.m_6336_());
        }
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        boolean isInvulnerable = entity.m_6673_(damageSource);
        if (entity instanceof LivingEntity && !isInvulnerable && Math.random() < 0.5) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), 80, 0));
        }
        entity.m_6469_(damageSource, damage);
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, damage)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntityHit = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    LivingEntity livingEntityOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntityHit, (Entity)livingEntityOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingEntityOwner, (Entity)livingEntityHit);
                }
                this.m_7761_(livingEntityHit);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.1, -0.01, -0.1));
        float volume = 1.0f;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_9236_().m_46470_()) {
                LightningBolt lightningBolt;
                BlockPos blockPos = entity.m_20183_();
                if (this.m_9236_().m_45527_(blockPos) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                    lightningBolt.m_20879_(owner instanceof ServerPlayer ? (ServerPlayer)owner : null);
                    this.m_9236_().m_7967_((Entity)lightningBolt);
                    soundEvent = SoundEvents.f_12521_;
                    volume = 5.0f;
                }
            }
        }
        this.m_5496_(soundEvent, volume, 1.0f);
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.spearItem);
    }

    protected boolean m_142470_(Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Trident", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Trident"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.spearItem)));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Trident", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

