/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.ShockwaveEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkeletosaurusEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SkeletosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPEED = SynchedEntityData.m_135353_(SkeletosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private int walkAnimationTickCounter = 0;
    private static final int MESSAGE_INTERVAL = 15;
    private float prevYaw;
    private int speedDuration = 0;
    private int tailmCooldown = 0;
    private int roarCooldown = 0;
    private int shockCooldown = 0;
    private int tailCooldown = 0;
    private boolean isSpeed = false;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 60;
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState tailAnimationState = new AnimationState();
    public AnimationState tailmAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState biteAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState shockwaveAnimationState = new AnimationState();

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    private void runawayMobs() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(30.0, 10.0, 30.0));
        for (LivingEntity e : list) {
            Vec3 vec;
            PathfinderMob mob;
            if (this.m_7307_((Entity)e) || !(e instanceof PathfinderMob) || (mob = (PathfinderMob)e) instanceof TamableAnimal && ((TamableAnimal)mob).m_21825_() || e == this) continue;
            mob.m_6710_(null);
            mob.m_6703_(null);
            if (mob.m_20096_()) {
                Vec3 randomShake = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), 0.0, (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.1f);
                mob.m_20256_(mob.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
            }
            mob.m_21573_().m_26573_();
            if (!mob.m_21573_().m_26571_() || (vec = LandRandomPos.m_148521_((PathfinderMob)mob, (int)15, (int)7, (Vec3)this.m_20182_())) == null) continue;
            mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
        }
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public SkeletosaurusEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_21530_();
        this.m_6210_();
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updateWithAttack();
        if (this.isSpeedy()) {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            assert (attributeInstance != null);
            attributeInstance.m_22100_((double)0.15f);
        } else {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            assert (attributeInstance != null);
            attributeInstance.m_22100_((double)0.1f);
        }
        if (this.speedDuration <= 0) {
            this.speedDuration = 0;
            this.isSpeed = false;
        }
        if (this.speedDuration > 0) {
            --this.speedDuration;
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.shockCooldown > 0) {
            --this.shockCooldown;
        }
        if (this.tailCooldown > 0) {
            --this.tailCooldown;
        }
        if (this.tailmCooldown > 0) {
            --this.tailmCooldown;
        }
        this.updateAttributes();
        this.handleWalkingMessage();
    }

    private void handleWalkingMessage() {
        if (this.isMoving()) {
            ++this.walkAnimationTickCounter;
            if (this.walkAnimationTickCounter >= 15) {
                this.walkAnimationTickCounter = 0;
                Vec3 vec3 = this.m_20182_();
            }
        } else {
            this.walkAnimationTickCounter = 0;
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    private void sendMessageToAllPlayers(String message) {
        this.m_9236_().m_6907_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
            }
        });
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPEED, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 80, 80, 7.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeletosaurusEntity.this.m_217043_().m_188501_() * 42.0f < 16.0f && SkeletosaurusEntity.this.shockCooldown <= 0 && SkeletosaurusEntity.this.m_5448_() != null && SkeletosaurusEntity.this.getAttackState() != 8 && SkeletosaurusEntity.this.getAttackState() != 3 && SkeletosaurusEntity.this.getAttackState() != 6;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = SkeletosaurusEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (SkeletosaurusEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = SkeletosaurusEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (SkeletosaurusEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                SkeletosaurusEntity.this.shockCooldown = 100;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 7, 0, 50, 50, 7.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeletosaurusEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && SkeletosaurusEntity.this.tailCooldown <= 0 && (SkeletosaurusEntity.this.getCrackiness() == Crackiness.NONE || SkeletosaurusEntity.this.getCrackiness() == Crackiness.LOW) && SkeletosaurusEntity.this.m_5448_() != null && SkeletosaurusEntity.this.getAttackState() != 6 && SkeletosaurusEntity.this.getAttackState() != 3 && SkeletosaurusEntity.this.getAttackState() != 8;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = SkeletosaurusEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (SkeletosaurusEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = SkeletosaurusEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (SkeletosaurusEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                SkeletosaurusEntity.this.tailCooldown = 100;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 8, 0, 48, 48, 7.0f){

            @Override
            public void m_8041_() {
                super.m_8041_();
                SkeletosaurusEntity.this.tailmCooldown = 180;
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeletosaurusEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && SkeletosaurusEntity.this.m_5448_() != null && SkeletosaurusEntity.this.getAttackState() != 6 && (SkeletosaurusEntity.this.getCrackiness() == Crackiness.HIGH || SkeletosaurusEntity.this.getCrackiness() == Crackiness.MEDIUM) && SkeletosaurusEntity.this.getAttackState() != 6 && SkeletosaurusEntity.this.tailmCooldown <= 0 && SkeletosaurusEntity.this.getAttackState() != 3 && SkeletosaurusEntity.this.getAttackState() != 7;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 20, 20, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeletosaurusEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && SkeletosaurusEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 5, 0, 50, 64, 12.0f, 9.0f){

            @Override
            public void m_8056_() {
                SkeletosaurusEntity.this.isSpeed = false;
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeletosaurusEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && SkeletosaurusEntity.this.roarCooldown <= 0 && SkeletosaurusEntity.this.getAttackState() != 6 && SkeletosaurusEntity.this.getAttackState() != 7 && SkeletosaurusEntity.this.getAttackState() != 3;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                SkeletosaurusEntity.this.isSpeed = true;
                SkeletosaurusEntity.this.speedDuration = 40;
                SkeletosaurusEntity.this.m_20331_(false);
                SkeletosaurusEntity.this.roarCooldown = 300;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 70, 0, 15.0f));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 13.0);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)ModSounds.STEP_SOUND.get(), 1.0f, 1.0f);
        Vec3 entityPosition = this.m_20182_();
        CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 10.0f, 0.05f, 0, 20);
    }

    public void performAreaAttack() {
        double attackRadius = 3.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof CameraShakeEntity) continue;
            MobEffectInstance brokenArmorEffect = livingEntity.m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get());
            if (brokenArmorEffect != null) {
                int currentLevel = brokenArmorEffect.m_19564_();
                if (currentLevel < 4) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, currentLevel + 1));
                    continue;
                }
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 4));
                continue;
            }
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 0));
        }
    }

    public void attackTargets(Entity entity1) {
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity1;
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
            double damage = 9.5 * (Double)ModConfig.MOB_CONFIG.SkeletosaurusDamageMutliplier.get();
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 2.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 9.0));
            }
        }
    }

    public boolean isSpeedy() {
        return this.isSpeed;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("is_Sleep", this.isSleep());
        this.isSpeed = pCompound.m_128471_("isSpeed");
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.isSpeed = compound.m_128471_("isSpeed");
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.SkeletosaurusHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.SkeletosaurusDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 200.0;
        double baseAttackDamage = 9.5;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SKELETOSAURUS_HURT3.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKELETOSAURUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setAttackState(4);
        this.dragonDeathTime = 0;
        boolean var = true;
        int var2 = 2;
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public boolean isSleep() {
        return this.getAttackState() == 1;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 20) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.dragonDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.DINOSAUR_BONE.get(), 2);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "biteattack") {
            return this.biteAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "roar") {
            return this.roarAnimationState;
        }
        if (input == "shockwaves") {
            return this.shockwaveAnimationState;
        }
        if (input == "tail") {
            return this.tailAnimationState;
        }
        if (input == "tailm") {
            return this.tailmAnimationState;
        }
        return new AnimationState();
    }

    private void ApplyEffects(float range, float height, float arc, int shieldbreakticks, int Duration) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            if (!this.m_9236_().f_46443_) {
                entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FEAR.get(), Duration, 0));
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            SkeletosaurusEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.biteAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.roarAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.shockwaveAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.tailAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.tailmAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.tailAnimationState.m_216973_();
        this.tailmAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.shockwaveAnimationState.m_216973_();
        this.roarAnimationState.m_216973_();
        this.biteAnimationState.m_216973_();
    }

    public void updateWithAttack() {
        if (this.getAttackState() == 6) {
            int k;
            float f2;
            int k2;
            int standingOnY;
            Vec3 entityPoesition;
            if (this.attackTicks == 12) {
                this.SpawnCircleParticle(0.25f, -1.0f, 20.0f, true, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                entityPoesition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                if (this.m_5448_() != null) {
                    standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (k2 = 0; k2 < 6; ++k2) {
                        f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                    }
                }
            }
            if (this.attackTicks == 13 && this.m_5448_() != null) {
                int standingOnY2 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY2, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 16 && this.m_5448_() != null) {
                int standingOnY3 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY3, this.m_20186_() + 1.0, f4, 0);
                }
            }
            if (this.attackTicks == 19 && this.m_5448_() != null) {
                int standingOnY4 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 19; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY4, this.m_20186_() + 1.0, f5, 0);
                }
            }
            if (this.attackTicks == 21 && this.m_5448_() != null) {
                int standingOnY5 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 26; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY5, this.m_20186_() + 1.0, f5, 0);
                }
            }
            if (this.attackTicks == 37) {
                this.SpawnCircleParticle(0.25f, -1.0f, 20.0f, true, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                entityPoesition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                if (this.m_5448_() != null) {
                    standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (k2 = 0; k2 < 6; ++k2) {
                        f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                    }
                }
            }
            if (this.attackTicks == 40 && this.m_5448_() != null) {
                int standingOnY6 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY6, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 43 && this.m_5448_() != null) {
                int standingOnY7 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY7, this.m_20186_() + 1.0, f4, 0);
                }
            }
            if (this.attackTicks == 46 && this.m_5448_() != null) {
                int standingOnY8 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 19; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY8, this.m_20186_() + 1.0, f5, 0);
                }
            }
            if (this.attackTicks == 49 && this.m_5448_() != null) {
                int standingOnY9 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 26; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY9, this.m_20186_() + 1.0, f5, 0);
                }
            }
            if (this.attackTicks == 62) {
                this.SpawnCircleParticle(0.25f, -1.0f, 20.0f, true, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                Vec3 entityPoesition2 = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition2, 20.0f, 0.05f, 0, 20);
                if (this.m_5448_() != null) {
                    standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (k2 = 0; k2 < 6; ++k2) {
                        f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                    }
                }
            }
            if (this.attackTicks == 65 && this.m_5448_() != null) {
                int standingOnY10 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY10, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 68 && this.m_5448_() != null) {
                int standingOnY11 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY11, this.m_20186_() + 1.0, f4, 0);
                }
            }
            if (this.attackTicks == 71 && this.m_5448_() != null) {
                int standingOnY12 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 19; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY12, this.m_20186_() + 1.0, f5, 0);
                }
            }
            if (this.attackTicks == 74 && this.m_5448_() != null) {
                int standingOnY13 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 26; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY13, this.m_20186_() + 1.0, f5, 0);
                }
            }
        }
        if (this.getAttackState() == 7) {
            if (this.attackTicks == 7) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SPIN.get(), 2.0f, 1.0f);
            }
            if (this.attackTicks == 16) {
                this.AreaAttack(8.0f, 7.0f, 380.0f, 14.0f, 40, false, 0.0f, false, 0.75f, true);
            }
        }
        if (this.getAttackState() == 8) {
            if (this.attackTicks == 7) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SPIN.get(), 2.0f, 1.0f);
            }
            if (this.attackTicks == 16) {
                this.AreaAttack(8.0f, 7.0f, 380.0f, 14.0f, 40, false, 0.0f, false, 0.75f, true);
            }
            if (this.attackTicks == 33) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SPIN.get(), 2.0f, 1.0f);
            }
            if (this.attackTicks == 36) {
                this.AreaAttack(8.0f, 7.0f, 380.0f, 14.0f, 40, false, 0.0f, false, 0.75f, true);
            }
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 3) {
                this.m_5496_(SoundEvents.f_11865_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 8) {
                this.AreaAttack(8.0f, 5.0f, 380.0f, 9.0f, 40, false, 0.0f, false, 0.75f, false);
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 1) {
                this.m_5496_((SoundEvent)ModSounds.ANCIENT_GUARDIAN_ROAR.get(), 4.0f, 0.75f);
            }
            if (this.attackTicks > 1 && this.attackTicks < 10) {
                this.runawayMobs();
            }
            if (this.attackTicks == 6) {
                this.ApplyEffects(16.0f, 10.0f, 360.0f, 0, 240);
            }
        }
        if (this.getAttackState() == 2) {
            if (this.attackTicks > 23 && this.attackTicks < 33) {
                this.runawayMobs();
            }
            if (this.attackTicks == 23) {
                this.m_5496_((SoundEvent)ModSounds.ANCIENT_GUARDIAN_ROAR.get(), 4.0f, 0.75f);
                this.runawayMobs();
            }
            if (this.attackTicks == 45) {
                this.ApplyEffects(16.0f, 10.0f, 360.0f, 0, 140);
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof SkeletosaurusEntity || entityHit == this) continue;
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.SkeletosaurusDamageMutliplier.get()));
            if (launch) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK.get(), 2.0f, 1.0f);
                this.launch(entityHit, true);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            SkeletosaurusEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    private void spawnShockwaves(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            SkeletosaurusEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, false, 17.0f));
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

