/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.MossyGolemEntity;
import net.miauczel.legendary_monsters.entity.custom.ShockwaveEntity2;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class Overgrown_colossusEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Overgrown_colossusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RAGE = SynchedEntityData.m_135353_(Overgrown_colossusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWNED_ENTITIES = SynchedEntityData.m_135353_(Overgrown_colossusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWNED_ENTITIES2 = SynchedEntityData.m_135353_(Overgrown_colossusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(Overgrown_colossusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevYaw;
    private int teleportCooldown = 0;
    private int smashCooldown = 0;
    private final int SMASH_COOLDOWN = 160;
    public int bigsmashCooldown = 0;
    public final int SMASH_ANCHOR_COOLDOWN = 160;
    public final int SMASH_ANCHOR2_COOLDOWN = 100;
    public final int CHARGE_COOLDOWN = 160;
    public int bigsmash2Cooldown = 0;
    public int chargeCooldown = 0;
    private static final int STUN_COOLDOWN_DURATION = 160;
    private int stunCooldown = 0;
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState chargeendAnimationState = new AnimationState();
    public AnimationState chargestartAnimationState = new AnimationState();
    public AnimationState upperCutAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState attackarm1AnimationState = new AnimationState();
    public AnimationState attackarm2AnimationState = new AnimationState();
    public AnimationState attackarmsAnimationState = new AnimationState();
    public AnimationState attackPoisonCloudAnimationState = new AnimationState();
    public AnimationState attackComboAnimationState = new AnimationState();
    public AnimationState slashAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int colossusDeathTime;

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean WantsToStun() {
        return this.getTextureVariant() == 1;
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public Overgrown_colossusEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_5448_().m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity instanceof MossyGolemEntity || entity == this.m_5448_() || entity instanceof CameraShakeEntity || livingEntity.m_21254_()) continue;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 2));
        }
    }

    private void sendActionBarMessageToPlayer(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)message)));
        }
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public void attackTargets(Entity entity1) {
        LivingEntity livingEntity;
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 14.0 * (Double)ModConfig.MOB_CONFIG.OvergrownColosussDamageMutliplier.get();
        if (entity1 instanceof LivingEntity && ((livingEntity = (LivingEntity)entity1) instanceof Player || livingEntity instanceof ServerPlayer)) {
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 5.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 13.0));
            }
        }
    }

    public boolean canStun() {
        return this.stunCooldown <= 0;
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(RAGE, (Object)false);
        this.f_19804_.m_135372_(SPAWNED_ENTITIES, (Object)false);
        this.f_19804_.m_135372_(SPAWNED_ENTITIES2, (Object)false);
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = 160;
        }
    }

    public void resetSmashAnchorCooldown() {
        if (this.bigsmashCooldown <= 0) {
            this.bigsmashCooldown = 160;
        }
    }

    public void resetSmash2Cooldown() {
        if (this.bigsmash2Cooldown <= 0) {
            this.bigsmash2Cooldown = 100;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 25 == 0) {
            this.m_5634_(1.0f);
        }
        this.updateAttributes();
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.bigsmashCooldown > 0) {
            --this.bigsmashCooldown;
        }
        if (this.bigsmash2Cooldown > 0) {
            --this.bigsmash2Cooldown;
        }
    }

    private void launchMini(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? 1.2f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.3 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 9, 0, 44, 44, 3.75f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Overgrown_colossusEntity.this.m_217043_().m_188501_() * 25.0f < 16.0f && Overgrown_colossusEntity.this.bigsmash2Cooldown <= 0 && Overgrown_colossusEntity.this.m_5448_() != null;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Overgrown_colossusEntity.this.resetSmash2Cooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 13, 0, 37, 37, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Overgrown_colossusEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && Overgrown_colossusEntity.this.smashCooldown <= 0 && Overgrown_colossusEntity.this.m_5448_() != null;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Overgrown_colossusEntity.this.resetSmashCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 46, 75, 5.0f));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 85, 100, 8.0f){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Overgrown_colossusEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && Overgrown_colossusEntity.this.teleportCooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Overgrown_colossusEntity.this.m_20331_(false);
                Overgrown_colossusEntity.this.teleportCooldown = 160;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f));
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 0, 10, 11, 20, 20, 15.0f){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Overgrown_colossusEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && Overgrown_colossusEntity.this.chargeCooldown <= 0;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 11, 11, 12, 25, 100){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                ShockwaveEntity2 entity2 = new ShockwaveEntity2((EntityType<? extends ShockwaveEntity2>)((EntityType)ModEntities.SHOCKWAVE2.get()), Overgrown_colossusEntity.this.m_9236_());
                entity2.setCaster((LivingEntity)Overgrown_colossusEntity.this);
                entity2.setRadius(6.0f);
                entity2.setDamage(4.0f);
                entity2.setCanHealOwner(false);
                entity2.setLifeTicks(60);
                entity2.m_6034_(Overgrown_colossusEntity.this.m_20185_(), Overgrown_colossusEntity.this.m_20186_(), Overgrown_colossusEntity.this.m_20189_());
                Overgrown_colossusEntity.this.m_9236_().m_7967_((Entity)entity2);
                super.m_8041_();
            }

            @Override
            public void m_8037_() {
                if (this.entity.m_20096_()) {
                    Vec3 vector3d = this.entity.m_20184_();
                    float f = this.entity.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.entity.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(0.45).m_82549_(vector3d.m_82490_(0.6));
                    this.entity.m_20334_(vector3d1.f_82479_, this.entity.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 12, 12, 0, 20, 100){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                Overgrown_colossusEntity.this.chargeCooldown = 160;
                super.m_8041_();
            }
        });
    }

    private void destroy() {
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        Iterator var3 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
        while (var3.hasNext()) {
            BlockPos blockpos = (BlockPos)var3.next();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate) || this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) continue;
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
        return;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == 6 && this.attackTicks == 17) {
            this.SpawnCircleParticle(3.5f, 1.5f, 16.0f, true, 1.0f, 0.9f, 1.0f, 0.9f, 1.0f);
            this.SpawnCircleParticle(3.5f, -1.5f, 16.0f, true, 1.0f, 0.9f, 1.0f, 0.9f, 1.0f);
        }
        this.updateWithAttack();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22281_, 14.0);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @org.jetbrains.annotations.Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.colossusDeathTime = 0;
        this.setAttackState(8);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Overgrownprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
        compound.m_128405_("TextureVariant", this.getTextureVariant());
        compound.m_128405_("StunCooldown", this.stunCooldown);
    }

    public void resetStunCooldown() {
        this.stunCooldown = 160;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.stunCooldown = compound.m_128451_("StunCooldown");
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)compound.m_128451_("TextureVariant"));
        this.f_19804_.m_135381_(RAGE, (Object)compound.m_128471_("rage"));
        this.f_19804_.m_135381_(SPAWNED_ENTITIES, (Object)compound.m_128471_("SpawnedEntities"));
        this.f_19804_.m_135381_(SPAWNED_ENTITIES2, (Object)compound.m_128471_("SpawnedEntities2"));
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.OvergrownColosussHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.OvergrownColosussDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 190.0;
        double baseAttackDamage = 14.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "attackarmright") {
            return this.attackarm1AnimationState;
        }
        if (input == "attackarmleft") {
            return this.attackarm2AnimationState;
        }
        if (input == "attackarms") {
            return this.attackarmsAnimationState;
        }
        if (input == "attackpoison") {
            return this.attackPoisonCloudAnimationState;
        }
        if (input == "attackcombo") {
            return this.attackComboAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "uppercut") {
            return this.upperCutAnimationState;
        }
        if (input == "chargeend") {
            return this.chargeendAnimationState;
        }
        if (input == "charge") {
            return this.chargeAnimationState;
        }
        if (input == "chargestart") {
            return this.chargestartAnimationState;
        }
        if (input == "slash") {
            return this.slashAnimationState;
        }
        return new AnimationState();
    }

    public int deathtimer() {
        return 60;
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackarm1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackarm2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.attackPoisonCloudAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.attackarmsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.attackComboAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.upperCutAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.chargestartAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.chargeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.chargeendAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopAllAnimationStates();
                    this.slashAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.upperCutAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.attackarmsAnimationState.m_216973_();
        this.attackPoisonCloudAnimationState.m_216973_();
        this.attackComboAnimationState.m_216973_();
        this.attackarm1AnimationState.m_216973_();
        this.attackarm2AnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.chargeAnimationState.m_216973_();
        this.chargestartAnimationState.m_216973_();
        this.chargeendAnimationState.m_216973_();
        this.slashAnimationState.m_216973_();
    }

    private void minilaunch(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? 1.35f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.5 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    private void updateWithAttack() {
        Vec3 entityPosition;
        if (this.getAttackState() == 13) {
            if (this.attackTicks == 15) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 18) {
                this.AreaAttack(5.0f, 5.0f, 180.0f, 15.0f, 120, false, 0.75f, false, 0.75f, true);
            }
        }
        if (this.getAttackState() == 11) {
            if (this.attackTicks <= 3 && this.m_5448_() != null) {
                this.m_21391_((Entity)this.m_5448_(), 90.0f, 90.0f);
            }
            if (!this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                this.destroy();
            }
            if (this.f_19797_ % 5 == 0) {
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.075f, 0, 20);
                this.m_216990_((SoundEvent)ModSounds.STEP_SOUND.get());
                ShockwaveEntity2 entity2 = new ShockwaveEntity2((EntityType<? extends ShockwaveEntity2>)((EntityType)ModEntities.SHOCKWAVE2.get()), this.m_9236_());
                entity2.setCaster((LivingEntity)this);
                entity2.setRadius(3.0f);
                entity2.setDamage(4.0f);
                entity2.setCanHealOwner(false);
                entity2.setLifeTicks(60);
                entity2.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)entity2);
            }
            this.AreaAttack(2.5f, 4.0f, 360.0f, 10.0f, 100, false, 0.0f, false, 0.0f, false);
        }
        if (this.getAttackState() == 9) {
            if (!this.m_9236_().f_46443_) {
                this.destroy();
            } else if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                this.destroy();
            }
            if (this.attackTicks == 17) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
                this.dash(1.1f, 1.1f, 4.0f);
            }
            if (this.attackTicks == 20) {
                this.AreaAttack(4.75f, 5.0f, 150.0f, 15.0f, 100, false, 1.0f, false, 0.0f, true);
            }
        }
        if (this.getAttackState() == 8) {
            if (this.attackTicks == 32) {
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
            if (this.attackTicks == 58) {
                // empty if block
            }
        }
        if (this.getAttackState() != 8) {
            if (this.getAttackState() == 3 && this.attackTicks == 17) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    if (Math.random() > 0.5) {
                        this.spawnPoisonCloud(this.m_5448_().m_9236_(), this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), 1.0f, 40);
                    }
                    this.AreaAttack(5.5f, 5.0f, 150.0f, 12.0f, 40, false, 1.0f, false, 0.0f, true);
                }
            }
            if (this.getAttackState() == 4 && this.attackTicks == 17) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    if (Math.random() > 0.5) {
                        this.spawnPoisonCloud(this.m_5448_().m_9236_(), this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), 1.0f, 40);
                    }
                    this.AreaAttack(5.5f, 5.0f, 150.0f, 12.0f, 40, false, 1.0f, false, 0.0f, true);
                }
            }
            if (this.getAttackState() == 5) {
                float f2;
                int k;
                if (this.attackTicks == 14) {
                    this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    Vec3 entityPoesition = this.m_20182_();
                    CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                    if (this.m_5448_() != null) {
                        int standingOnY = Mth.m_14107_((double)this.m_20186_());
                        for (k = 0; k < 6; ++k) {
                            f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                            this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                        }
                    }
                }
                if (this.attackTicks == 17 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k2 = 0; k2 < 11; ++k2) {
                        float f3 = (float)k2 * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 0);
                    }
                }
                if (this.attackTicks == 20 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k3 = 0; k3 < 14; ++k3) {
                        float f4 = (float)k3 * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 0);
                    }
                }
                if (this.attackTicks == 23 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k4 = 0; k4 < 19; ++k4) {
                        float f5 = (float)k4 * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
                if (this.attackTicks == 26 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k5 = 0; k5 < 26; ++k5) {
                        float f5 = (float)k5 * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
                if (this.attackTicks == 42) {
                    this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    Vec3 entityPoesition = this.m_20182_();
                    CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                    if (this.m_5448_() != null) {
                        int standingOnY = Mth.m_14107_((double)this.m_20186_());
                        for (k = 0; k < 6; ++k) {
                            f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                            this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                        }
                    }
                }
                if (this.attackTicks == 45 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k6 = 0; k6 < 11; ++k6) {
                        float f3 = (float)k6 * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 0);
                    }
                }
                if (this.attackTicks == 48 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k7 = 0; k7 < 14; ++k7) {
                        float f4 = (float)k7 * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 0);
                    }
                }
                if (this.attackTicks == 51 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k8 = 0; k8 < 19; ++k8) {
                        float f5 = (float)k8 * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
                if (this.attackTicks == 54 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k9 = 0; k9 < 26; ++k9) {
                        float f5 = (float)k9 * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
                if (this.attackTicks == 70) {
                    this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    Vec3 entityPoesition = this.m_20182_();
                    CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                    if (this.m_5448_() != null) {
                        int standingOnY = Mth.m_14107_((double)this.m_20186_());
                        for (k = 0; k < 6; ++k) {
                            f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                            this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                        }
                    }
                }
                if (this.attackTicks == 73 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k10 = 0; k10 < 11; ++k10) {
                        float f3 = (float)k10 * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 0);
                    }
                }
                if (this.attackTicks == 76 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k11 = 0; k11 < 14; ++k11) {
                        float f4 = (float)k11 * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 0);
                    }
                }
                if (this.attackTicks == 79 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k12 = 0; k12 < 19; ++k12) {
                        float f5 = (float)k12 * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
                if (this.attackTicks == 81 && this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k13 = 0; k13 < 26; ++k13) {
                        float f5 = (float)k13 * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                    }
                }
            }
            if (this.getAttackState() == 6) {
                if (this.attackTicks == 12) {
                    this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
                }
                if (this.attackTicks == 17) {
                    if (this.m_5448_() != null && Math.random() > 0.5) {
                        this.spawnPoisonCloud(this.m_5448_().m_9236_(), this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), 1.0f, 40);
                    }
                    Vec3 entityPosition2 = this.m_20182_();
                    CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition2, 20.0f, 0.15f, 0, 20);
                    this.m_5496_(SoundEvents.f_11892_, 1.0f, 1.0f);
                    this.AreaAttack(6.25f, 6.0f, 180.0f, 16.0f, 120, false, 0.75f, false, 0.75f, true);
                }
            }
        }
    }

    public void spawnPoisonCloud(Level level, double x, double y, double z, float radius, int duration) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(EntityType.f_20476_, level);
        areaEffectCloud.m_6034_(x, y, z);
        areaEffectCloud.m_19734_(duration);
        areaEffectCloud.m_19712_(radius);
        areaEffectCloud.m_19718_((LivingEntity)this);
        areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 200, 2));
        level.m_7967_((Entity)areaEffectCloud);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Overgrown_colossusEntity || entityHit instanceof MossyGolemEntity || entityHit == this) continue;
            if (stun || entityHit.m_21254_() || Math.random() > 0.5) {
                // empty if block
            }
            boolean hurt = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.OvergrownColosussDamageMutliplier.get()));
            if ((this.getAttackState() == 4 || this.getAttackState() == 3) && this.attackTicks == 20) {
                if (BNknockback && !entityHit.m_21254_()) {
                    double knockbackRadius = 5.0;
                    double dx = entityHit.m_20185_() - this.m_20185_();
                    double dz = entityHit.m_20189_() - this.m_20189_();
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    double knockbackStrength = (double)knockback + 0.5 * (knockbackRadius - distance);
                    entityHit.m_5997_(dx / distance * knockbackStrength, 0.4, dz / distance * knockbackStrength);
                }
                Vec3 entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
            }
            if (hurt) {
                if (this.getAttackState() == 11) {
                    this.launchMini(entityHit, true);
                }
                if (this.getAttackState() == 9 || this.getAttackState() == 13) {
                    this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 0.5f);
                }
                if (this.getAttackState() != 11) {
                    this.launch(entityHit, true);
                }
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            Overgrown_colossusEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    protected void m_6153_() {
        ++this.colossusDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.colossusDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.colossusDeathTime == 25) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.colossusDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.NATURE_CRYSTAL.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    private void spawnShockwaves(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Overgrown_colossusEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveEntity2(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, 6, 1.0f, 7.0f));
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

