/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.FireBreath;
import net.miauczel.legendary_monsters.entity.custom.FireColumnEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class Lava_eaterEntity
extends IAnimatedMonster {
    public int bigsmashCooldown2 = 0;
    public int bigsmashCooldown = 0;
    public final int SMASH_ANCHOR_COOLDOWN = 100;
    public final int SMASH_ANCHOR_COOLDOWN2 = 200;
    private int teleportCooldown = 0;
    private int anger;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 60;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState fAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState attackDigAnimationState = new AnimationState();
    public AnimationState attackBiteAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState spinAnimationState = new AnimationState();
    public AnimationState slamAnimationState = new AnimationState();

    public Lava_eaterEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    public void resetSmashAnchorCooldown() {
        if (this.bigsmashCooldown <= 0) {
            this.bigsmashCooldown = 100;
        }
    }

    @Override
    public void m_8119_() {
        if (this.bigsmashCooldown > 0) {
            --this.bigsmashCooldown;
        }
        if (this.bigsmashCooldown2 > 0) {
            --this.bigsmashCooldown2;
        }
        if (this.anger > 0) {
            --this.anger;
        }
        this.m_6094_();
        if (this.getAttackState() != 4 || this.attackTicks < 54 || this.attackTicks <= 90) {
            // empty if block
        }
        if (this.getAttackState() != 4) {
            this.m_20153_();
        }
        this.UpdateWithAttack();
        super.m_8119_();
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        this.updateAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 24, 18, 4.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Lava_eaterEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Lava_eaterEntity.this.m_5448_() != null && Lava_eaterEntity.this.getAttackState() != 6 && Lava_eaterEntity.this.getAttackState() != 7;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 48, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Lava_eaterEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Lava_eaterEntity.this.bigsmashCooldown <= 0 && Lava_eaterEntity.this.m_5448_() != null && Lava_eaterEntity.this.getAttackState() != 3 && Lava_eaterEntity.this.getAttackState() != 7;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Lava_eaterEntity.this.resetSmashAnchorCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new FlamethrowerGoal(this, 0, 8, 0, 80, 10, 7.0f, -1.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Lava_eaterEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Lava_eaterEntity.this.k() && Lava_eaterEntity.this.m_5448_() != null && Lava_eaterEntity.this.getAttackState() != 3 && Lava_eaterEntity.this.getAttackState() != 7;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Lava_eaterEntity.this.anger = 160;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 7, 0, 48, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Lava_eaterEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Lava_eaterEntity.this.bigsmashCooldown2 <= 0 && Lava_eaterEntity.this.m_5448_() != null && Lava_eaterEntity.this.getAttackState() != 3 && Lava_eaterEntity.this.getAttackState() != 6;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Lava_eaterEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Lava_eaterEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Lava_eaterEntity.this.bigsmashCooldown2 = 200;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 4, 0, 104, 64, 12.0f, 6.0f){

            @Override
            public void m_8056_() {
                Lava_eaterEntity.this.m_20331_(true);
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Lava_eaterEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && Lava_eaterEntity.this.teleportCooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Lava_eaterEntity.this.m_20331_(false);
                Lava_eaterEntity.this.teleportCooldown = 300;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 11.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.LavaEaterHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.LavaEaterDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 170.0;
        double baseAttackDamage = 12.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ENDERSENT_HURT1.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENDERSENT_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setAttackState(5);
        this.dragonDeathTime = 0;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return this.getAttackState() != 4;
    }

    public boolean k() {
        return this.anger <= 0;
    }

    public int hh() {
        return this.anger;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Lavaprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268530_) || source.m_276093_(DamageTypes.f_268515_)) {
            // empty if block
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268434_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 30) {
            // empty if block
        }
        if (this.dragonDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.LAVA_EATERS_SKIN.get(), 3);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "dig") {
            return this.attackDigAnimationState;
        }
        if (input == "bite") {
            return this.attackBiteAnimationState;
        }
        if (input == "spin") {
            return this.spinAnimationState;
        }
        if (input == "slam") {
            return this.slamAnimationState;
        }
        if (input == "fire") {
            return this.fAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @javax.annotation.Nullable SpawnGroupData p_29681_, @javax.annotation.Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackBiteAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackDigAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.spinAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.slamAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.fAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void launch2(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        float multiplier = huge ? 2.0f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.5 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.fAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.attackDigAnimationState.m_216973_();
        this.attackBiteAnimationState.m_216973_();
        this.spinAnimationState.m_216973_();
        this.slamAnimationState.m_216973_();
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Lava_eaterEntity || entityHit == this) continue;
            if (this.getAttackState() == 3 && this.attackTicks == 8) {
                entityHit.m_7311_(80);
            }
            if (this.getAttackState() == 3 && this.attackTicks == 8) {
                entityHit.m_7311_(80);
            }
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.LavaEaterDamageMutliplier.get()));
            if (launch) {
                if (this.getAttackState() == 6) {
                    this.launch(entityHit, true);
                }
                if (this.getAttackState() == 7) {
                    this.launch2(entityHit, true);
                }
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            Lava_eaterEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    private void spawnFire(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Lava_eaterEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new FireColumnEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1));
        }
    }

    private void StrikeFire2() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            int k;
            double d0 = Math.min(target.m_20186_(), this.m_20186_());
            double d1 = Math.max(target.m_20186_(), this.m_20186_()) + 2.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.m_20189_()), (double)(target.m_20185_() - this.m_20185_()));
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            for (k = 0; k < 15; ++k) {
                this.spawnFire(this.m_20185_() + this.f_19796_.m_188583_() * 4.5, this.m_20189_() + this.f_19796_.m_188583_() * 4.5, d0, d1, f3, 10);
            }
            for (k = 0; k < 15; ++k) {
                this.spawnFire(this.m_20185_() + this.f_19796_.m_188583_() * 4.5, this.m_20189_() + this.f_19796_.m_188583_() * 4.5, d0, d1, f3, 5);
            }
        }
    }

    private void StrikeFire(int rune, double time) {
        for (int i = 0; i < rune; ++i) {
            float throwAngle = (float)i * (float)Math.PI / (float)(rune / 2);
            for (int k = 0; k < 8; ++k) {
                double d2 = 1.15 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                this.spawnFire(this.m_20185_() + (double)Mth.m_14089_((float)throwAngle) * 1.25 * d2, this.m_20189_() + (double)Mth.m_14031_((float)throwAngle) * 1.25 * d2, this.m_20186_(), this.m_20186_() + 2.0, throwAngle, d3);
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    private void teleportToTarget(LivingEntity target) {
        double targetPosX = target.m_20185_();
        double targetPosY = target.m_20186_();
        double targetPosZ = target.m_20189_();
        this.m_6021_(targetPosX, targetPosY, targetPosZ);
    }

    private void teleportToTarget2(LivingEntity target) {
        double targetPosX = target.m_20185_();
        double targetPosY = target.m_20186_();
        double targetPosZ = target.m_20189_();
        this.m_6021_(targetPosX + 2.0, targetPosY, targetPosZ);
    }

    public void UpdateWithAttack() {
        if (this.getAttackState() == 8) {
            if (this.attackTicks > 5 && this.attackTicks < 60) {
                this.m_5496_(SoundEvents.f_215772_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 13) {
                Vec3 mouthPos = new Vec3(0.0, 1.0, 0.0);
                mouthPos = mouthPos.m_82524_((float)Math.toRadians(-this.m_146908_() - 90.0f));
                mouthPos = mouthPos.m_82549_(this.m_20182_());
                mouthPos = mouthPos.m_82549_(new Vec3(0.0, 0.0, 0.0).m_82496_((float)Math.toRadians(-this.m_146909_())).m_82524_((float)Math.toRadians(-this.f_20885_)));
                FireBreath breath = new FireBreath((EntityType<? extends FireBreath>)((EntityType)ModEntities.FIRE_B.get()), this.m_9236_(), 11.0f, (LivingEntity)this);
                breath.m_19890_(mouthPos.f_82479_, mouthPos.f_82480_, mouthPos.f_82481_, this.f_20885_, this.m_146909_());
                this.m_9236_().m_7967_((Entity)breath);
            }
        }
        if (this.getAttackState() == 6 && this.attackTicks == 13) {
            this.AreaAttack(6.7f, 3.0f, 140.0f, 12.0f, 40, false, 0.75f, false, 0.75f, true);
            this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK.get(), 2.0f, 1.0f);
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 3) {
                this.m_5496_(SoundEvents.f_11865_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 8) {
                this.AreaAttack(4.5f, 3.0f, 100.0f, 8.0f, 40, false, 0.75f, true, 0.75f, false);
            }
        }
        if (this.getAttackState() == 7 && this.attackTicks == 28) {
            this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
            this.AreaAttack(7.5f, 6.0f, 200.0f, 16.0f, 40, false, 0.75f, false, 0.75f, true);
            this.StrikeFire(10, 0.5);
            this.SpawnCircleParticle(2.0f, 0.0f, 30.0f, true, 5.0f, 1.0f, 0.2f, 0.2f, 1.0f);
        }
        if (this.getAttackState() == 4) {
            double distanceToTarget;
            LivingEntity target;
            double d5;
            double d4;
            double d3;
            double d2;
            double d1;
            double d0;
            BlockState block;
            if (this.attackTicks > 10 && this.attackTicks < 27 && this.f_19797_ % 2 == 0) {
                this.m_5496_(SoundEvents.f_144206_, 2.0f, 1.0f);
            }
            if (this.attackTicks == 1) {
                this.m_20331_(true);
            }
            if (this.attackTicks == 10) {
                for (int i = 0; i < 80; ++i) {
                    block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                    d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d1 = this.m_20186_() + 0.03;
                    d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d3 = this.f_19796_.m_188583_() * 0.07;
                    d4 = this.f_19796_.m_188583_() * 0.07;
                    d5 = this.f_19796_.m_188583_() * 0.07;
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
                }
            }
            if (this.attackTicks == 20) {
                for (int i = 0; i < 80; ++i) {
                    block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                    d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d1 = this.m_20186_() + 0.03;
                    d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d3 = this.f_19796_.m_188583_() * 0.07;
                    d4 = this.f_19796_.m_188583_() * 0.07;
                    d5 = this.f_19796_.m_188583_() * 0.07;
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
                }
            }
            if (this.attackTicks == 25) {
                this.m_6842_(true);
                for (int i = 0; i < 80; ++i) {
                    block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                    d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d1 = this.m_20186_() + 0.03;
                    d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    d3 = this.f_19796_.m_188583_() * 0.07;
                    d4 = this.f_19796_.m_188583_() * 0.07;
                    d5 = this.f_19796_.m_188583_() * 0.07;
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
                }
            }
            if (this.attackTicks >= 27 && this.attackTicks <= 50 && (target = this.m_5448_()) != null && (distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_())) < 225.0) {
                this.teleportToTarget(target);
            }
            if (this.attackTicks > 24 && this.attackTicks < 35 && this.f_19797_ % 2 == 0) {
                this.m_5496_(SoundEvents.f_144206_, 2.0f, 1.0f);
            }
            if (this.attackTicks == 50) {
                this.m_6842_(false);
            }
            if (this.attackTicks == 54) {
                LivingEntity target2 = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target2 != null);
                    if (this.m_20197_().isEmpty()) {
                        if (!target2.m_21254_()) {
                            target2.m_7998_((Entity)this, true);
                        } else if (target2 instanceof Player) {
                            Player p = (Player)target2;
                            Lava_eaterEntity.disableShield((LivingEntity)p, 200);
                        }
                    }
                    if (target2 instanceof Player || !(target2 instanceof ServerPlayer)) {
                        // empty if block
                    }
                }
                for (int i = 0; i < 80; ++i) {
                    BlockState block2 = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                    double d02 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    double d12 = this.m_20186_() + 0.03;
                    double d22 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                    double d32 = this.f_19796_.m_188583_() * 0.07;
                    double d42 = this.f_19796_.m_188583_() * 0.07;
                    double d52 = this.f_19796_.m_188583_() * 0.07;
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block2), d02, d12, d22, d32, d42, d52);
                }
            }
            if (this.attackTicks >= 54 && this.attackTicks <= 90) {
                LivingEntity target3 = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target3 != null);
                    double distanceToTarget2 = this.m_20275_(target3.m_20185_(), target3.m_20186_(), target3.m_20189_());
                    if (distanceToTarget2 < 9.0) {
                        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
                        float m = (float)((double)target3.m_21233_() * 0.01);
                        if (!this.m_20197_().isEmpty()) {
                            this.AreaAttack(2.0f, 5.0f, 560.0f, 10.0f + m, 0, false, 0.75f, false, 0.75f, false);
                            if (this.f_19797_ % 5 == 0) {
                                this.m_5634_(2.0f);
                            }
                        }
                        if (target3.m_6144_()) {
                            target3.m_20260_(false);
                        }
                    }
                }
                this.m_20331_(false);
            }
            if (this.attackTicks == 93) {
                LivingEntity target4 = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target4 != null);
                    target4.m_8127_();
                }
            }
            if (this.attackTicks == 95) {
                LivingEntity target5 = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target5 != null);
                    this.teleportToTarget2(target5);
                }
            }
            if (!this.m_20197_().isEmpty()) {
                Entity entity = (Entity)this.m_20197_().get(0);
                LivingEntity target6 = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target6 != null);
                    if (target6.m_6144_()) {
                        target6.m_20260_(false);
                    }
                }
            }
        }
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    private static void laser(@Nullable Event event, LevelAccessor world, Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return;
        }
        double TrackX = 0.0;
        double TrackY = 0.0;
        double TrackZ = 0.0;
        double Grow = 0.0;
        if (entity instanceof Mob) {
            Mob _mobEnt = (Mob)entity;
            livingEntity = _mobEnt.m_5448_();
        } else {
            livingEntity = null;
        }
        if (livingEntity != null) {
            LivingEntity livingEntity2;
            LivingEntity livingEntity3;
            LivingEntity livingEntity4;
            LivingEntity livingEntity5;
            Mob _mobEnt;
            if (entity instanceof Mob) {
                _mobEnt = (Mob)entity;
                livingEntity5 = _mobEnt.m_5448_();
            } else {
                livingEntity5 = null;
            }
            TrackX = livingEntity5.m_20185_() - entity.m_20185_();
            if (entity instanceof Mob) {
                Mob _mobEnt2 = (Mob)entity;
                livingEntity4 = _mobEnt2.m_5448_();
            } else {
                livingEntity4 = null;
            }
            double d = livingEntity4.m_20186_() - entity.m_20186_();
            if (entity instanceof Mob) {
                _mobEnt = (Mob)entity;
                livingEntity3 = _mobEnt.m_5448_();
            } else {
                livingEntity3 = null;
            }
            TrackY = d + (double)livingEntity3.m_20206_() * 0.75 - (double)entity.m_20206_() * 0.75;
            if (entity instanceof Mob) {
                _mobEnt = (Mob)entity;
                livingEntity2 = _mobEnt.m_5448_();
            } else {
                livingEntity2 = null;
            }
            TrackZ = livingEntity2.m_20189_() - entity.m_20189_();
            Grow = 1.0;
            for (int index0 = 0; index0 < 20; ++index0) {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_() + TrackX * Grow, entity.m_20186_() + (double)entity.m_20206_() * 0.75 + TrackY * Grow, entity.m_20189_() + TrackZ * Grow, 5, 0.15, 0.15, 0.15, 0.0);
                }
                Grow -= 0.05;
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public class FlamethrowerGoal
    extends Goal {
        protected final IAnimatedMonster entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;
        private final float attackrangemin;

        public FlamethrowerGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, float attackrangemin) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
            this.attackrangemin = attackrangemin;
        }

        public FlamethrowerGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, float attackrangemin, EnumSet<Goal.Flag> interruptFlagTypes) {
            this.entity = entity;
            this.m_7021_(interruptFlagTypes);
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
            this.attackrangemin = attackrangemin;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.entity.m_20270_((Entity)target) > this.attackrangemin;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            this.entity.attackCooldown = 0;
        }

        public boolean m_8045_() {
            return this.entity.attackTicks < this.attackMaxtick;
        }

        public void m_8037_() {
            float laserSpeed = 0.0f;
            LivingEntity target = this.entity.m_5448_();
            if (target != null) {
                float distanceToTarget = this.entity.m_20270_((Entity)target);
                laserSpeed = Math.min(3.76f, Math.max(0.54f, distanceToTarget / 5.0f));
            }
            float yRotSpeed = 1.5f + laserSpeed;
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 15.0f, 15.0f);
            } else if (this.entity.attackTicks > this.attackseetick && target != null) {
                this.entity.m_21563_().m_24950_(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), yRotSpeed, 90.0f);
            } else if (target == null) {
                this.entity.m_146922_(this.entity.f_19859_);
            }
        }

        public boolean m_183429_() {
            return false;
        }
    }
}

