/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.Cloud_GolemEntity;
import net.miauczel.legendary_monsters.entity.custom.Tornado;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HoveringHurricaneEntity
extends IAnimatedMonster {
    public int shootCoolown = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState ShootAnimationState = new AnimationState();
    public AnimationState SlamAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public HoveringHurricaneEntity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 5;
        this.m_21530_();
    }

    @Override
    public void m_8119_() {
        this.updateWithAttack();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        }
        if (this.m_5448_() instanceof Cloud_GolemEntity) {
            this.m_6710_(null);
        }
        if (this.shootCoolown > 0) {
            --this.shootCoolown;
        }
        super.m_8119_();
    }

    protected boolean canDespawn() {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.StratlingHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.StratlingDamageMultiplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 50.0;
        double baseAttackDamage = 5.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new StratlingAttackGoal(this, 0, 2, 0, 40, 40, 3.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HoveringHurricaneEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && HoveringHurricaneEntity.this.m_5448_() != null && HoveringHurricaneEntity.this.getAttackState() != 3;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 45, 45, 15.0f){

            @Override
            public void m_8041_() {
                super.m_8041_();
                HoveringHurricaneEntity.this.shootCoolown = 40;
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HoveringHurricaneEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && HoveringHurricaneEntity.this.m_5448_() != null && HoveringHurricaneEntity.this.getAttackState() != 2 && HoveringHurricaneEntity.this.shootCoolown <= 0;
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 6.0);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "slam") {
            return this.SlamAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "shoot") {
            return this.ShootAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.SlamAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.ShootAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.ShootAnimationState.m_216973_();
        this.SlamAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            boolean flag;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if ((entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && !this.m_7307_((Entity)entityHit) && !(entityHit instanceof HoveringHurricaneEntity) && !(entityHit instanceof Cloud_GolemEntity) && entityHit != this && !(flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.StratlingDamageMultiplier.get())))) continue;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() != 14 || this.getAttackState() != 17) {
            this.m_20242_(false);
        }
        int i = 0;
        while ((double)i < 0.5) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
            ++i;
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CGA.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.CGH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CGD.get();
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public void shootTornado(float Velocity, float inAccuracy) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(d0 * d0 + d2 * d2);
        }
    }

    public void updateWithAttack() {
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 8) {
                // empty if block
            }
            if (this.attackTicks == 13) {
                this.m_5496_(SoundEvents.f_12558_, 1.0f, 1.0f);
                LivingEntity target = this.m_5448_();
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int numberOfSkulls = 1;
                float angleStep = 30.0f;
                for (int i = 0; i < numberOfSkulls; ++i) {
                    float angle = this.f_20883_ + (float)(i - numberOfSkulls / 2) * angleStep;
                    float rad = (float)Math.toRadians(angle);
                    double dx = -Math.sin(rad);
                    double dz = Math.cos(rad);
                    if (this.m_5448_() != null) {
                        float m = (float)((double)this.m_5448_().m_21233_() * 0.05);
                        Tornado witherskull = new Tornado((LivingEntity)this, dx, 0.0, dz, this.m_9236_(), 16.0f + m, angle, 120.0f);
                        double spawnX = this.m_20185_() + vecX * 1.0;
                        double spawnY = this.m_20227_(0.15);
                        double spawnZ = this.m_20189_() + vecZ * 1.0;
                        witherskull.m_6034_(spawnX, spawnY, spawnZ);
                        this.m_9236_().m_7967_((Entity)witherskull);
                        continue;
                    }
                    Tornado witherskull = new Tornado((LivingEntity)this, dx, 0.0, dz, this.m_9236_(), 16.0f, angle, 120.0f);
                    double spawnX = this.m_20185_() + vecX * 1.0;
                    double spawnY = this.m_20227_(0.15);
                    double spawnZ = this.m_20189_() + vecZ * 1.0;
                    witherskull.m_6034_(spawnX, spawnY, spawnZ);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
        }
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 7) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 2.0f);
            }
            if (this.attackTicks == 15) {
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                this.AreaAttack(4.5f, 3.0f, 180.0f, 10.0f);
            }
        }
    }

    public static class StratlingAttackGoal
    extends Goal {
        protected final IAnimatedMonster entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;

        public StratlingAttackGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public StratlingAttackGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, EnumSet<Goal.Flag> interruptFlagTypes) {
            this.entity = entity;
            this.m_7021_(interruptFlagTypes);
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            this.entity.attackCooldown = 0;
        }

        public boolean m_8045_() {
            return this.entity.attackTicks < this.attackMaxtick;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
        }

        public boolean m_183429_() {
            return false;
        }
    }
}

