/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.List;
import java.util.UUID;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.IAnimatedTamableMob;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ILookingTamableMobStateGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class FLivingArmorEntity
extends IAnimatedTamableMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(FLivingArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(FLivingArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(FLivingArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int regenerationCooldown = 30;
    private static final double HITBOX_RADIUS = 3.0;
    private static final double HITBOX_HEIGHT = 2.0;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public AnimationState combo1AnimationState = new AnimationState();
    public AnimationState combo2AnimationState = new AnimationState();
    public AnimationState slashAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();

    @Override
    public double baseHealth() {
        return 60.0;
    }

    @Override
    public double baseDamage() {
        return 12.0;
    }

    @Override
    public double healthMult() {
        return (Double)ModConfig.MOB_CONFIG.FKnightHealthMutliplier.get();
    }

    @Override
    public double damageMult() {
        return (Double)ModConfig.MOB_CONFIG.FKnightDamageMultiplier.get();
    }

    public FLivingArmorEntity(EntityType<? extends IAnimatedTamableMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2;
        this.m_21557_(false);
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)0);
        this.m_7105_(false);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_146762_(0);
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
        if (((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue()) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
        }
        this.sitAnimationState.m_246184_(((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue(), this.f_19797_);
        if (this.getAttackState() != 0 || !((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue() || this.getAttackState() == 3 || this.getAttackState() == 4 || this.getAttackState() == 5 || this.getAttackState() != 2) {
            // empty if block
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % this.regenerationCooldown == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
            this.spawnHeartParticles();
        }
    }

    @Override
    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    @Override
    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int maxExtraMobs) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        int attackedExtraMobCount = 0;
        for (LivingEntity entityHit : entitiesHit) {
            TamableAnimal tamableEntity;
            boolean isEnemy;
            boolean inArc;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            boolean inRange = entityHitDistance <= range;
            boolean bl = inArc = entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f;
            if (!inRange || !inArc || !(isEnemy = !this.m_7307_((Entity)entityHit) && entityHit != this && !(entityHit instanceof FLivingArmorEntity) && (!(entityHit instanceof TamableAnimal) || !(tamableEntity = (TamableAnimal)entityHit).m_21824_() || tamableEntity.m_269323_() != this.m_269323_()))) continue;
            if (entityHit == this.m_5448_()) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 1.0f);
                entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * this.damageMult()));
                continue;
            }
            if (attackedExtraMobCount >= maxExtraMobs) continue;
            this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 1.0f);
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * this.damageMult()));
            ++attackedExtraMobCount;
        }
    }

    private void spawnHeartParticles() {
        if (this.m_9236_().m_5776_()) {
            double x = this.m_20185_();
            double y = this.m_20186_() + (double)this.m_20206_() + 0.5;
            double z = this.m_20189_();
            for (int i = 0; i < 5; ++i) {
                double offsetX = this.f_19796_.m_188583_() * 0.02;
                double offsetY = this.f_19796_.m_188583_() * 0.02;
                double offsetZ = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, offsetX, offsetY, offsetZ);
            }
        }
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    @Nullable
    public FLivingArmorEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        UUID uuid;
        FLivingArmorEntity armor = (FLivingArmorEntity)((EntityType)ModEntities.Knights_Armor.get()).m_20615_((Level)pLevel);
        if (armor != null && (uuid = this.m_21805_()) != null) {
            armor.m_21816_(uuid);
            armor.m_7105_(true);
        }
        return armor;
    }

    public AnimationState getAnimationState(String input) {
        if (input == "slash") {
            return this.slashAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "sit") {
            return this.sitAnimationState;
        }
        if (input == "combo1") {
            return this.combo1AnimationState;
        }
        if (input == "combo2") {
            return this.combo2AnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.slashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.combo1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.combo2AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.sitAnimationState.m_216973_();
        this.slashAnimationState.m_216973_();
        this.combo1AnimationState.m_216973_();
        this.combo2AnimationState.m_216973_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        InteractionResult interactionresult1;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemstack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                InteractionResult interactionresult;
                int newTextureVariant = -1;
                if (pPlayer.m_6144_()) {
                    if (item == Items.f_42417_ && this.getTextureVariant() != 1) {
                        customAttackSound2 = SoundEvents.f_11676_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 1;
                    } else if (item == Items.f_151049_ && this.getTextureVariant() != 2) {
                        customAttackSound2 = SoundEvents.f_11673_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 2;
                    } else if (item == Items.f_42616_ && this.getTextureVariant() != 3) {
                        customAttackSound2 = SoundEvents.f_11673_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 3;
                    } else if (item == Items.f_151052_ && this.getTextureVariant() != 4) {
                        customAttackSound2 = SoundEvents.f_11672_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 4;
                    } else if (item == Items.f_42415_ && this.getTextureVariant() != 5) {
                        customAttackSound2 = SoundEvents.f_11673_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 5;
                    } else if (item == Items.f_220224_ && this.getTextureVariant() != 6) {
                        customAttackSound = SoundEvents.f_11679_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        SoundEvent customAttackSound2 = SoundEvents.f_215779_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        newTextureVariant = 6;
                    } else if (item == Items.f_42416_ && this.getTextureVariant() != 7) {
                        customAttackSound2 = SoundEvents.f_11677_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 7;
                    } else if (item == Items.f_42418_ && this.getTextureVariant() != 8) {
                        customAttackSound = SoundEvents.f_12009_;
                        SoundEvent customAttackSound2 = SoundEvents.f_11679_;
                        this.m_9236_().m_5594_(null, this.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        newTextureVariant = 8;
                    }
                    if (newTextureVariant != -1) {
                        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)newTextureVariant);
                        itemstack.m_41774_(1);
                        return InteractionResult.CONSUME;
                    }
                }
                if (!(interactionresult = super.m_6071_(pPlayer, pHand)).m_19077_() || this.m_6162_()) {
                    this.m_21839_(!this.m_21827_());
                }
                return interactionresult;
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionresult1 = super.m_6071_(pPlayer, pHand)).m_19077_()) {
            this.m_21530_();
        }
        return interactionresult1;
    }

    public void m_21839_(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        if (sitting) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_sit_enable", this.getEntityName());
            }
        } else {
            this.setAttackState(0);
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_walk_enable", this.getEntityName());
            }
        }
    }

    private void sendActionBarMessageToPlayer(Player player, String translationKey, String entityName) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)entityName)).m_130946_(">").m_7220_((Component)Component.m_237115_((String)translationKey));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private String getEntityName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return "legendary_monsters.message.knight_string_message_name";
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ILookingTamableMobStateGoal(this, 3, 3, 0, 0, 100, true){

            @Override
            public void m_8037_() {
                this.entity.m_21573_().m_26573_();
                this.entity.m_20334_(0.0, 0.0, 0.0);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 4.0, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 2, 0, 28, 28, 3.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FLivingArmorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && FLivingArmorEntity.this.m_5448_() != null && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 4, 0, 48, 48, 3.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FLivingArmorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && FLivingArmorEntity.this.m_5448_() != null && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 5, 0, 44, 48, 3.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FLivingArmorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && FLivingArmorEntity.this.m_5448_() != null && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new ITamableMobMoveGoal(this, false, 3.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)FLivingArmorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    public void UpdateWithAttack() {
        SoundEvent customAttackSound;
        int extraMobs = 1;
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 3) {
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 9) {
                this.AreaAttack(4.0f, 3.0f, 100.0f, 12.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 6) {
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 9) {
                this.AreaAttack(4.0f, 3.0f, 100.0f, 12.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
            if (this.attackTicks == 26) {
                this.dash(0.9f, 0.6f, 4.0f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 28) {
                this.AreaAttack(4.0f, 3.0f, 100.0f, 13.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 9) {
                this.dash(0.9f, 0.6f, 4.0f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 12) {
                this.AreaAttack(4.0f, 3.0f, 100.0f, 12.0f, extraMobs);
                this.dash(0.9f, 0.6f, 4.0f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
            if (this.attackTicks == 23) {
                this.dash(0.9f, 0.6f, 4.0f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 26) {
                this.AreaAttack(4.0f, 3.0f, 100.0f, 13.0f, extraMobs);
                SoundEvent soundEvent = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.stopAttackingAllies();
        this.UpdateWithAttack();
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, (double)0.7f).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 18.0);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.LIVING_ARMOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_8077_()) {
            ItemStack nameTag = new ItemStack((ItemLike)Items.f_42656_, 1);
            nameTag.m_41714_(this.m_7755_());
            this.m_19983_(nameTag);
        }
        ItemStack diamond = new ItemStack((ItemLike)ModItems.DEACTIVATED_KNIGHT_SUMMONER.get(), 1);
        ItemStack txt0 = new ItemStack((ItemLike)Items.f_42416_, 1);
        ItemStack txt1 = new ItemStack((ItemLike)Items.f_42417_, 1);
        ItemStack txt2 = new ItemStack((ItemLike)Items.f_151049_, 1);
        ItemStack txt3 = new ItemStack((ItemLike)Items.f_42616_, 1);
        ItemStack txt4 = new ItemStack((ItemLike)Items.f_151052_, 1);
        ItemStack txt5 = new ItemStack((ItemLike)Items.f_42415_, 1);
        ItemStack txt6 = new ItemStack((ItemLike)Items.f_220224_, 1);
        ItemStack txt8 = new ItemStack((ItemLike)Items.f_42418_, 1);
        ItemStack tag = new ItemStack((ItemLike)Items.f_42656_, 1);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        if (this.getTextureVariant() == 1) {
            this.LGspawnatlocation(txt1);
        }
        if (this.getTextureVariant() == 7) {
            this.LGspawnatlocation(txt0);
        }
        if (this.getTextureVariant() == 2) {
            this.LGspawnatlocation(txt2);
        }
        if (this.getTextureVariant() == 3) {
            this.LGspawnatlocation(txt3);
        }
        if (this.getTextureVariant() == 4) {
            this.LGspawnatlocation(txt4);
        }
        if (this.getTextureVariant() == 5) {
            this.LGspawnatlocation(txt5);
        }
        if (this.getTextureVariant() == 6) {
            this.LGspawnatlocation(txt6);
        }
        if (this.getTextureVariant() == 8) {
            this.LGspawnatlocation(txt8);
        }
        this.LGspawnatlocation(diamond);
        this.m_19983_(emerald);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if ((this.getAttackState() == 2 || this.getAttackState() == 4 && this.attackTicks < 20) && this.f_19797_ % 3 == 0) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
        }
        if (this.getAttackState() == 2 || this.getAttackState() == 4 && this.attackTicks < 20) {
            if (this.f_19797_ % 10 == 0) {
                // empty if block
            }
            amount = 1.0f;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42416_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.m_21827_());
        compound.m_128405_("TextureVariant", this.getTextureVariant());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_21839_(compound.m_128471_("Sitting"));
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)compound.m_128451_("TextureVariant"));
    }
}

