/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom.EntityTypes;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MathHelper {
    public static AABB makeAttackRange(double x, double y, double z, double height, double sizeX, double sizeY, double sizeZ) {
        return new AABB(x - sizeX / 2.0, (y += height) - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
    }

    public static boolean checkAnimalSpawnRules(EntityType<?> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && MathHelper.isBrightEnoughToSpawn((BlockAndTintGetter)levelAccessor, pos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter blockAndTintGetter, BlockPos pos) {
        return blockAndTintGetter.m_45517_(LightLayer.SKY, pos) > 8 || blockAndTintGetter.m_45517_(LightLayer.BLOCK, pos) > 8;
    }

    public static boolean isOverworld(LevelAccessor world) {
        ResourceKey resourceKey;
        if (world instanceof Level) {
            Level level = (Level)world;
            resourceKey = level.m_46472_();
        } else {
            resourceKey = Level.f_46428_;
        }
        return resourceKey == Level.f_46428_;
    }

    public static boolean isEntityInBox(LivingEntity entityIn, LivingEntity caster, double sizeup) {
        return caster.m_20191_().m_82400_(sizeup).m_82381_(entityIn.m_20191_());
    }

    public static boolean isEntityInBox(LivingEntity entityIn, LivingEntity caster, AABB aabb) {
        return aabb.m_82381_(entityIn.m_20191_());
    }
}

