/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.entity.custom.INoRendererEntity;
import net.miauczel.legendary_monsters.entity.custom.Lava_eaterEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ChorusBreathEntity
extends INoRendererEntity {
    private static final int RANGE = 10;
    private static final int ARC = 45;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ChorusBreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FRONT = SynchedEntityData.m_135353_(ChorusBreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.m_135353_(ChorusBreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(ChorusBreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACK = SynchedEntityData.m_135353_(ChorusBreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ChorusBreathEntity(EntityType<? extends ChorusBreathEntity> type, Level world) {
        super(type, world);
    }

    public ChorusBreathEntity(EntityType<? extends ChorusBreathEntity> type, Level world, float damage, LivingEntity caster, boolean isFront, boolean isLeft, boolean isRight, boolean isBack) {
        super(type, world);
        this.setCaster(caster);
        this.setDamage(damage);
        this.setIsFront(isFront);
        this.setIsLeft(isLeft);
        this.setIsRight(isRight);
        this.setIsBack(isBack);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void setIsFront(boolean input) {
        this.f_19804_.m_135381_(FRONT, (Object)input);
    }

    public void setIsLeft(boolean input) {
        this.f_19804_.m_135381_(LEFT, (Object)input);
    }

    public void setIsRight(boolean input) {
        this.f_19804_.m_135381_(RIGHT, (Object)input);
    }

    public void setIsBack(boolean input) {
        this.f_19804_.m_135381_(BACK, (Object)input);
    }

    public boolean isLeft() {
        return (Boolean)this.f_19804_.m_135370_(LEFT);
    }

    public boolean isBack() {
        return (Boolean)this.f_19804_.m_135370_(BACK);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public boolean isFront_() {
        return (Boolean)this.f_19804_.m_135370_(FRONT);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.caster instanceof Player) {
            this.m_5496_(SoundEvents.f_215772_, 1.0f, 1.0f);
        }
        if (this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        if (this.caster != null) {
            Vec3 pos = new Vec3(this.caster.m_20185_(), this.caster.m_20186_() + 1.0, this.caster.m_20189_());
            if (this.isFront_()) {
                this.m_146922_(this.caster.f_20885_);
            }
            if (this.isBack()) {
                this.m_146922_(this.caster.f_20885_ - 180.0f);
            }
            if (this.isRight()) {
                this.m_146922_(this.caster.f_20885_ - 90.0f);
            }
            if (this.isLeft()) {
                double rad = Math.toRadians(this.caster.f_20885_ - 90.0f);
                this.m_146922_(this.caster.f_20885_ + 90.0f);
            }
            this.m_146884_(pos);
        }
        float yaw = (float)Math.toRadians(-this.m_146908_());
        float pitch = (float)Math.toRadians(-this.m_146909_());
        float spread = 0.25f;
        float speed = 0.56f;
        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
        float yComp = (float)Math.sin(pitch);
        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
        double theta = (double)this.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double vec = 0.9;
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 80; ++i) {
                double xSpeed = (double)(speed * xComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - xComp * xComp);
                double ySpeed = (double)(speed * yComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - yComp * yComp);
                double zSpeed = (double)(speed * zComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - zComp * zComp);
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.CHORUS_SMOKE.get(), this.m_20185_() + vec * vecX, this.m_20186_(), this.m_20189_() + vec * vecZ, xSpeed, ySpeed, zSpeed);
            }
        }
        if (this.f_19797_ > 2 && this.caster != null) {
            this.hitEntities();
        }
        if (this.f_19797_ > 50) {
            this.m_146870_();
        }
    }

    public void hitEntities() {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(10.0, 10.0, 10.0, 10.0);
        for (LivingEntity entityHit : entitiesHit) {
            boolean flag;
            boolean CloseCheck2;
            int distance;
            float entityHitYaw = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingYaw = this.m_146908_() % 360.0f;
            if (entityHitYaw < 0.0f) {
                entityHitYaw += 360.0f;
            }
            if (entityAttackingYaw < 0.0f) {
                entityAttackingYaw += 360.0f;
            }
            float entityRelativeYaw = entityHitYaw - entityAttackingYaw;
            float xzDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            double hitY = entityHit.m_20186_() + (double)entityHit.m_20206_() / 2.0;
            float entityHitPitch = (float)(Math.atan2(hitY - this.m_20186_(), xzDistance) * 57.29577951308232 % 360.0);
            float entityAttackingPitch = -this.m_146909_() % 360.0f;
            if (entityHitPitch < 0.0f) {
                entityHitPitch += 360.0f;
            }
            if (entityAttackingPitch < 0.0f) {
                entityAttackingPitch += 360.0f;
            }
            float entityRelativePitch = entityHitPitch - entityAttackingPitch;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()) + (hitY - this.m_20186_()) * (hitY - this.m_20186_()));
            boolean inRange = entityHitDistance <= (float)(distance = this.f_19797_ / 2) + 1.0f;
            boolean yawCheck = entityRelativeYaw <= 22.5f && entityRelativeYaw >= -22.5f || entityRelativeYaw >= 337.5f || entityRelativeYaw <= -337.5f;
            boolean pitchCheck = entityRelativePitch <= 22.5f && entityRelativePitch >= -22.5f || entityRelativePitch >= 337.5f || entityRelativePitch <= -337.5f;
            boolean CloseCheck = this.caster instanceof Lava_eaterEntity && entityHitDistance <= 2.0f;
            boolean bl = CloseCheck2 = this.caster instanceof Player && entityHitDistance <= 2.0f;
            if ((!inRange || !yawCheck || !pitchCheck) && !CloseCheck || this.f_19797_ % 3 != 0 || this.m_7307_((Entity)entityHit) || entityHit == this.caster || !(flag = entityHit.m_6469_(this.m_269291_().m_269333_(this.caster), this.getDamage()))) continue;
            entityHit.m_7311_(60);
            entityHit.m_20256_(entityHit.m_20184_().m_82542_(0.25, 1.0, 0.25));
        }
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BACK, (Object)false);
        this.f_19804_.m_135372_(FRONT, (Object)false);
        this.f_19804_.m_135372_(RIGHT, (Object)false);
        this.f_19804_.m_135372_(LEFT, (Object)false);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
        this.setDamage(compound.m_128457_("damage"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
        compound.m_128350_("damage", this.getDamage());
    }

    public boolean m_6087_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_5829_() {
        return false;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public boolean m_6094_() {
        return false;
    }
}

