/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.entity.animations.MossyGolemAnimations;
import net.miauczel.legendary_monsters.entity.custom.MossyGolemEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class MossyGolemModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;

    public MossyGolemModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = root.m_171324_("root").m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition right_leg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 29).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.5f, -6.5f, -3.0f, 9.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(16, 38).m_171488_(-0.5f, 0.5f, -3.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-5.5f, (float)-1.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(34, 13).m_171488_(-1.1f, -12.1f, -0.7f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.5f, -8.1f, -3.2f, 9.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 37).m_171488_(-1.5f, -4.1f, -5.2f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 33).m_171488_(-4.5f, -8.1f, -4.2f, 9.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 38).m_171488_(-3.5f, -5.1f, -4.2f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.4f, (float)-0.8f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(0.0f, -2.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.1f, (float)0.8f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(0.0f, -2.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.1f, (float)0.8f, (float)0.0f, (float)-2.5307f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 25).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(34, 0).m_171488_(-0.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(30, 16).m_171488_(-1.0f, 6.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(8, 38).m_171488_(-0.5f, 7.5f, -3.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(34, 7).m_171488_(-1.0f, 7.0f, -5.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 38).m_171488_(-0.5f, 7.5f, 2.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-6.5f, (float)0.0f));
        PartDefinition cube_r3 = left_arm.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(34, 7).m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)9.0f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171480_().m_171488_(-2.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 16).m_171480_().m_171488_(-3.0f, 6.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 38).m_171480_().m_171488_(-2.5f, 7.5f, -3.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(34, 7).m_171480_().m_171488_(-3.0f, 7.0f, -5.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 38).m_171480_().m_171488_(-2.5f, 7.5f, 2.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 25).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.5f, (float)-6.5f, (float)0.0f));
        PartDefinition cube_r4 = right_arm.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(34, 7).m_171480_().m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)9.0f, (float)4.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation((MossyGolemEntity)((Object)entity), netHeadYaw, headPitch, ageInTicks);
        this.m_233385_(((MossyGolemEntity)((Object)entity)).getAnimationState("slam"), MossyGolemAnimations.smash, ageInTicks, 1.0f);
        this.m_267799_(MossyGolemAnimations.walk4, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.m_233385_(((MossyGolemEntity)((Object)entity)).idleAnimationState, MossyGolemAnimations.IDLE, ageInTicks, 1.0f);
        this.m_233385_(((MossyGolemEntity)((Object)entity)).sitAnimationState, MossyGolemAnimations.sit, ageInTicks, 1.0f);
        this.m_233385_(((MossyGolemEntity)((Object)entity)).growthAnimationState, MossyGolemAnimations.growth, ageInTicks, 1.0f);
        this.root.f_233553_ = 1.25f;
        this.root.f_233554_ = 1.25f;
        this.root.f_233555_ = 1.25f;
    }

    private void applyHeadRotation(MossyGolemEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)25.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

