/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.entity.animations.AmbusherAnimations;
import net.miauczel.legendary_monsters.entity.custom.AmbusherEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AmbusherModel<T extends AmbusherEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;

    public AmbusherModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = root.m_171324_("root").m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -11.5f, -18.75f, 12.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)10.75f));
        PartDefinition tailpart1 = body.m_171599_("tailpart1", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.5f, 0.5f, 8.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-0.25f));
        PartDefinition tailpart2 = tailpart1.m_171599_("tailpart2", CubeListBuilder.m_171558_().m_171514_(38, 31).m_171488_(-3.0f, -3.5f, 0.5f, 6.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)11.0f));
        PartDefinition spike3 = tailpart2.m_171599_("spike3", CubeListBuilder.m_171558_().m_171514_(68, 56).m_171488_(-1.5f, -3.5f, -4.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-7.0f, (float)7.5f));
        PartDefinition cube_r1 = spike3.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(62, 14).m_171488_(-2.5f, -3.5f, 0.0f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)1.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition spike2 = tailpart1.m_171599_("spike2", CubeListBuilder.m_171558_().m_171514_(16, 65).m_171488_(-3.5f, -3.5f, -5.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-8.0f, (float)8.5f));
        PartDefinition cube_r2 = spike2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(62, 14).m_171488_(-2.5f, -3.5f, 0.0f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-5.0f, -5.0f, -4.0f, 10.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)-18.75f));
        PartDefinition leftribcage = head.m_171599_("leftribcage", CubeListBuilder.m_171558_().m_171514_(68, 63).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-4.0f, (float)-4.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition right_ribcage = head.m_171599_("right_ribcage", CubeListBuilder.m_171558_().m_171514_(28, 71).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)-4.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition knife = body.m_171599_("knife", CubeListBuilder.m_171558_().m_171514_(62, 21).m_171488_(-1.0f, -1.0f, -7.5f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)4.75f));
        PartDefinition blade = knife.m_171599_("blade", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.3536f, (float)-14.6464f));
        PartDefinition cube_r3 = blade.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(0.0f, -2.5f, -4.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.3536f, (float)3.1464f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r4 = blade.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(0.0f, -2.5f, -4.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.3536f, (float)3.1464f, (float)0.0f, (float)0.0f, (float)-2.3562f));
        PartDefinition spikes1 = body.m_171599_("spikes1", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171488_(3.0f, -0.5f, -15.75f, 12.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(62, 7).m_171488_(3.0f, -0.5f, -3.75f, 12.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-18.0f, (float)0.0f));
        PartDefinition cube_r5 = spikes1.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(38, 49).m_171480_().m_171488_(-2.5f, -3.5f, 0.0f, 19.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)3.0f, (float)-16.25f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r6 = spikes1.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(38, 49).m_171488_(-16.5f, -3.5f, 0.0f, 19.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)12.0f, (float)3.0f, (float)-16.25f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leg4 = root.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(48, 56).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.5f, (float)-10.0f, (float)7.5f));
        PartDefinition leg3 = root.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(48, 56).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.5f, (float)-10.0f, (float)-4.5f));
        PartDefinition leg2 = root.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(28, 56).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-10.0f, (float)7.5f));
        PartDefinition leg1 = root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(28, 56).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-10.0f, (float)-4.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation((AmbusherEntity)((Object)entity), netHeadYaw, headPitch, ageInTicks);
        this.m_233385_(((AmbusherEntity)((Object)entity)).getAnimationState("idle"), AmbusherAnimations.IDLE, ageInTicks, 1.0f);
        this.m_233385_(((AmbusherEntity)((Object)entity)).getAnimationState("toungue"), AmbusherAnimations.ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((AmbusherEntity)((Object)entity)).getAnimationState("death"), AmbusherAnimations.DEATH, ageInTicks, 1.0f);
        this.m_267799_(AmbusherAnimations.WALK2, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        this.root.f_233553_ = 1.25f;
        this.root.f_233554_ = 1.25f;
        this.root.f_233555_ = 1.25f;
    }

    private void applyHeadRotation(AmbusherEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)25.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

