/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster;

import java.util.List;
import net.miauczel.legendary_monsters.LegendaryMonsters;
import net.miauczel.legendary_monsters.Message.PlayBossMusicMessage;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class IAnimatedTamableMob
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(IAnimatedTamableMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean dropAfterDeathAnim = false;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private Player killDataAttackingPlayer;
    public int attackTicks;
    public int attackCooldown;
    public int customDeathTime;

    public double healthMult() {
        return 1.0;
    }

    public double damageMult() {
        return 1.0;
    }

    public double baseDamage() {
        return 10.0;
    }

    public double baseHealth() {
        return 20.0;
    }

    public void updateAttributes() {
        double healthMultiplier = this.healthMult();
        double damageMultiplier = this.damageMult();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = this.baseHealth();
        double baseAttackDamage = this.baseDamage();
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public void stopAttackingAllies() {
        if (this.m_5448_() != null && this.m_5448_() instanceof TamableAnimal && this.m_269323_() != null && ((TamableAnimal)this.m_5448_()).m_269323_() == this.m_269323_()) {
            this.m_6710_(null);
        }
    }

    public IAnimatedTamableMob(EntityType entity, Level world) {
        super(entity, world);
    }

    public void SpawnCircleParticle(float vec, float math, float size, boolean blockParticles, float blockParticleSize, float r, float g, float b, float a) {
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = blockParticleSize * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = blockParticleSize * Mth.m_14089_((float)angle);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE || !blockParticles) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 35, r, g, b, a, 1.0f * size, false, Circle.EnumRingBehavior.GROW), this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)input);
        this.m_9236_().m_7605_((Entity)this, (byte)(-input));
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateAttributes();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            if (this.canPlayMusic() && this.getBossMusic() != null) {
                LegendaryMonsters.sendMSGToAll(new PlayBossMusicMessage(this.m_19879_(), true));
            } else {
                LegendaryMonsters.sendMSGToAll(new PlayBossMusicMessage(this.m_19879_(), false));
            }
        }
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public SoundEvent getBossMusic() {
        return null;
    }

    public int getAttackTicks() {
        return this.attackTicks;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.m_20189_() - first.m_20189_(), second.m_20185_() - first.m_20185_()) * 57.29577951308232 + 90.0;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
        livingEntity.m_5810_();
        livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.m_6087_() || entity.f_19794_) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.m_20334_(-0.1 * Math.cos(angle), entity.m_20184_().f_82480_, -0.1 * Math.sin(angle));
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_5803_() || this.m_20365_(entityIn) || entityIn.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.m_20160_() && this.canBePushedByEntity(entityIn)) {
                this.m_5997_(-d0, 0.0, -d1);
            }
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }
}

