/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.entity.custom.LivingArmorEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LivingArmorAttackGoal
extends MeleeAttackGoal {
    private final LivingArmorEntity entity;
    private int attackDelay = 16;
    private int ticksUntilNextAttack = 16;
    private boolean shouldCountTillNextAttack = false;
    private boolean hasPlayedAttackSound = false;

    public LivingArmorAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (LivingArmorEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 13;
        this.ticksUntilNextAttack = 13;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation() && !this.hasPlayedAttackSound) {
                SoundEvent customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 2.0f);
                this.entity.setAttacking(true);
                this.hasPlayedAttackSound = true;
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.hasPlayedAttackSound = false;
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.hasPlayedAttackSound = false;
        }
    }

    public void Attack2Hurt(LivingEntity target) {
        Holder.Reference cactusDamageType = this.f_25540_.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268585_);
        DamageSource damageSource = new DamageSource((Holder)cactusDamageType);
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= 10.0;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        Player player;
        this.m_25563_();
        if (!(pEnemy instanceof Player) && !(pEnemy instanceof ServerPlayer)) {
            this.f_25540_.m_7327_((Entity)pEnemy);
        }
        SoundEvent customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
        this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!this.f_25540_.m_5448_().m_21254_()) {
            // empty if block
        }
        if (pEnemy instanceof Player && (player = (Player)pEnemy).m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
            Item shieldItem;
            Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
            if (!player.m_36335_().m_41519_(shieldItem)) {
                player.m_36335_().m_41524_(shieldItem, 40);
                if (player.m_21254_()) {
                    player.m_5810_();
                }
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
        this.hasPlayedAttackSound = false;
    }
}

