/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.just_a_slingshot.common.item.slingshot;

import com.github.teamfusion.just_a_slingshot.common.item.slingshot.SlingshotItem;
import com.github.teamfusion.just_a_slingshot.common.registry.ItemRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SlingshotPouchItem
extends Item {
    public static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 384;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public SlingshotPouchItem(Item.Properties properties) {
        super(properties);
    }

    public static float getFullnessDisplay(ItemStack itemStack) {
        return (float)SlingshotPouchItem.getContentWeight(itemStack) / 64.0f * 6.0f;
    }

    public boolean m_142207_(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemStack22 = slot.m_7993_();
        if (itemStack22.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            SlingshotPouchItem.removeOne(itemStack).ifPresent(itemStack2 -> SlingshotPouchItem.add(itemStack, slot.m_150659_(itemStack2)));
        } else if (itemStack22.m_41720_().m_142095_() && SlingshotItem.getAmmoBehavior((ItemLike)itemStack22.m_41720_()) != null) {
            int i = (384 - SlingshotPouchItem.getContentWeight(itemStack)) / SlingshotPouchItem.getWeight(itemStack22);
            int j = SlingshotPouchItem.add(itemStack, slot.m_150647_(itemStack22.m_41613_(), i, player));
            if (j > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack itemStack2, ItemStack itemStack22, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        int i;
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (itemStack22.m_41619_()) {
            SlingshotPouchItem.removeOne(itemStack2).ifPresent(itemStack -> {
                this.playRemoveOneSound((Entity)player);
                slotAccess.m_142104_(itemStack);
            });
        } else if (SlingshotItem.getAmmoBehavior((ItemLike)itemStack22.m_41720_()) != null && (i = SlingshotPouchItem.add(itemStack2, itemStack22)) > 0) {
            this.playInsertSound((Entity)player);
            itemStack22.m_41774_(i);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public boolean m_142522_(ItemStack itemStack) {
        return SlingshotPouchItem.getContentWeight(itemStack) > 0;
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.min(1 + 12 * SlingshotPouchItem.getContentWeight(itemStack) / 384, 13);
    }

    public int m_142159_(ItemStack itemStack) {
        return BAR_COLOR;
    }

    public static int add(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2.m_41619_() || !itemStack2.m_41720_().m_142095_()) {
            return 0;
        }
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            compoundTag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        int i = SlingshotPouchItem.getContentWeight(itemStack);
        int j = SlingshotPouchItem.getWeight(itemStack2);
        int k = Math.min(itemStack2.m_41613_(), (384 - i) / j);
        if (k == 0) {
            return 0;
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        Optional<CompoundTag> optional = SlingshotPouchItem.getMatchingItem(itemStack2, listTag);
        if (optional.isPresent() && itemStack2.m_41613_() < 64) {
            CompoundTag compoundTag2 = optional.get();
            CompoundTag compoundTag3 = compoundTag2.m_6426_();
            ItemStack itemStack3 = ItemStack.m_41712_((CompoundTag)compoundTag3);
            itemStack3.m_41769_(k);
            listTag.remove((Object)compoundTag2);
            itemStack3.m_41739_(compoundTag3);
            listTag.add(0, (Tag)compoundTag3);
        } else {
            ItemStack itemStack4 = itemStack2.m_255036_(k);
            CompoundTag compoundTag3 = new CompoundTag();
            itemStack4.m_41739_(compoundTag3);
            listTag.add(0, (Tag)compoundTag3);
        }
        return k;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack itemStack, ListTag listTag) {
        if (itemStack.m_150930_(ItemRegistry.SLINGSHOT_POUCH.get())) {
            return Optional.empty();
        }
        return listTag.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)itemStack) && itemStack.m_41613_() + ItemStack.m_41712_((CompoundTag)compoundTag).m_41613_() < 64).findFirst();
    }

    private static int getWeight(ItemStack itemStack) {
        CompoundTag compoundTag;
        if (SlingshotItem.getAmmoBehavior((ItemLike)itemStack.m_41720_()) != null) {
            return 64 / itemStack.m_41741_();
        }
        if (itemStack.m_41782_() && (compoundTag = BlockItem.m_186336_((ItemStack)itemStack)) != null && !compoundTag.m_128437_("Bees", 10).isEmpty()) {
            return 640;
        }
        return 640;
    }

    private static int getContentWeight(ItemStack itemStack2) {
        return SlingshotPouchItem.getContents(itemStack2).mapToInt(itemStack -> SlingshotPouchItem.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    public static Optional<ItemStack> removeOneCountItem(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        if (listTag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundTag2 = listTag.m_128728_(SlingshotPouchItem.getSelectedItem(itemStack));
        ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag2);
        itemStack2.m_41774_(1);
        if (itemStack2.m_41619_()) {
            listTag.remove(SlingshotPouchItem.getSelectedItem(itemStack));
            compoundTag.m_128473_("ItemSelect");
        } else {
            listTag.set(SlingshotPouchItem.getSelectedItem(itemStack), (Tag)itemStack2.m_41739_(new CompoundTag()));
        }
        if (listTag.isEmpty()) {
            itemStack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemStack2);
    }

    public static Optional<ItemStack> removeOne(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        if (listTag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundTag2 = listTag.m_128728_(0);
        ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag2);
        listTag.remove(0);
        if (listTag.isEmpty()) {
            itemStack.m_41749_(TAG_ITEMS);
        }
        compoundTag.m_128473_("ItemSelect");
        return Optional.of(itemStack2);
    }

    private static boolean dropContents(ItemStack itemStack, Player player) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag2);
                player.m_36176_(itemStack2, true);
            }
        }
        itemStack.m_41749_(TAG_ITEMS);
        return true;
    }

    public static Stream<ItemStack> getContents(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        return listTag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        SlingshotPouchItem.getContents(itemStack).forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new BundleTooltip(nonNullList, SlingshotPouchItem.getContentWeight(itemStack)));
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{SlingshotPouchItem.getContentWeight(itemStack), 384}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, SlingshotPouchItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static int getSelectedItem(ItemStack p_40885_) {
        CompoundTag compoundtag = p_40885_.m_41784_();
        if (compoundtag.m_128441_("ItemSelect")) {
            return compoundtag.m_128451_("ItemSelect");
        }
        return 0;
    }

    public static void setSelectedItem(int select, ItemStack p_40885_) {
        CompoundTag compoundtag = p_40885_.m_41784_();
        compoundtag.m_128405_("ItemSelect", select);
    }

    public static boolean cycle(ItemStack stack) {
        return SlingshotPouchItem.cycle(1, stack);
    }

    public static boolean cycle(boolean clockWise, ItemStack stack) {
        return SlingshotPouchItem.cycle(clockWise ? 1 : -1, stack);
    }

    public static boolean cycle(int slotsMoved, ItemStack stack) {
        int originalSlot = SlingshotPouchItem.getSelectedItem(stack);
        List<ItemStack> content = SlingshotPouchItem.getContents(stack).toList();
        if (slotsMoved == 0 && content.isEmpty()) {
            return false;
        }
        int maxSlots = content.size();
        if (maxSlots <= 0) {
            return false;
        }
        SlingshotPouchItem.setSelectedItem((maxSlots + (SlingshotPouchItem.getSelectedItem(stack) + (slotsMoved %= maxSlots))) % maxSlots, stack);
        for (int i = 0; i < maxSlots; ++i) {
            SlingshotPouchItem.setSelectedItem((maxSlots + (SlingshotPouchItem.getSelectedItem(stack) + (slotsMoved >= 0 ? 1 : -1))) % maxSlots, stack);
        }
        return originalSlot != SlingshotPouchItem.getSelectedItem(stack);
    }
}

