/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.just_a_slingshot.client;

import com.github.teamfusion.just_a_slingshot.common.item.slingshot.SlingshotPouchItem;
import com.github.teamfusion.just_a_slingshot.common.network.JustASlingShotServerNetwork;
import com.github.teamfusion.just_a_slingshot.common.registry.ItemRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderHelper {
    public static final ResourceLocation TOLERANCE_METER_LOCATION = new ResourceLocation("just_a_slingshot", "textures/gui/tolerance_meter.png");
    private static Gui ingameGui;
    private static Minecraft minecraft;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation TEXTURE_SELECT;

    public static boolean onMouseScrolled(Minecraft minecraft, double scrollDelta) {
        ItemStack pouch;
        LocalPlayer player = minecraft.f_91074_;
        ItemStack itemStack = player.m_21205_().m_150930_(ItemRegistry.SLINGSHOT_POUCH.get()) ? player.m_21205_() : (pouch = player.m_21206_().m_150930_(ItemRegistry.SLINGSHOT_POUCH.get()) ? player.m_21206_() : ItemStack.f_41583_);
        if (player.m_6144_() && pouch.m_41720_() == ItemRegistry.SLINGSHOT_POUCH.get()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(scrollDelta > 0.0 ? 1 : -1);
            NetworkManager.sendToServer((ResourceLocation)JustASlingShotServerNetwork.SELECT_SYNC_PACKET, (FriendlyByteBuf)buf);
            return true;
        }
        return false;
    }

    private static void renderSlot(GuiGraphics graphics, int pX, int pY, ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            graphics.m_280480_(itemStack, pX, pY);
            graphics.m_280370_(Minecraft.m_91087_().f_91062_, itemStack, pX, pY);
        }
    }

    public static void renderItemContent(GuiGraphics graphics, int screenWidth, int screenHeight) {
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity instanceof Player) {
            ItemStack pouch;
            Player player = (Player)entity;
            ItemStack itemStack = player.m_21205_().m_150930_(ItemRegistry.SLINGSHOT_POUCH.get()) ? player.m_21205_() : (pouch = player.m_21206_().m_150930_(ItemRegistry.SLINGSHOT_POUCH.get()) ? player.m_21206_() : ItemStack.f_41583_);
            if (pouch.m_41720_() == ItemRegistry.SLINGSHOT_POUCH.get()) {
                PoseStack poseStack = graphics.m_280168_();
                poseStack.m_85836_();
                int selected = SlingshotPouchItem.getSelectedItem(pouch);
                List<ItemStack> list = SlingshotPouchItem.getContents(pouch).toList();
                int slots = list.size();
                int uWidth = slots * 20 + 2;
                int px = screenWidth / 2 - 91 - 29;
                int py = screenHeight - 16 - 3 - 16;
                px += 0;
                py += 0;
                boolean i1 = true;
                for (int i = 0; i < slots; ++i) {
                    int jy = py - 10 - i * 20;
                    if (!list.isEmpty() && list.size() > i) {
                        RenderHelper.renderSlot(graphics, px + 3, jy + 3, list.get(i));
                        graphics.m_280163_(TEXTURE, px, jy, 0.0f, 0.0f, 22, 22, 22, 22);
                        continue;
                    }
                    RenderHelper.renderSlot(graphics, px + 3, jy + 3, null);
                    graphics.m_280163_(TEXTURE, px, jy, 0.0f, 0.0f, 22, 22, 22, 22);
                }
                if (selected < slots) {
                    int jy = py - 10 - selected * 20;
                    graphics.m_280163_(TEXTURE_SELECT, px - 1, jy - 1, 0.0f, 0.0f, 24, 24, 24, 24);
                }
                if (!list.isEmpty() && list.size() > selected) {
                    ItemStack selectedArrow = list.get(selected);
                    RenderHelper.drawHighlight(graphics, screenWidth, py, selectedArrow);
                }
                poseStack.m_85849_();
            }
        }
    }

    protected static void drawHighlight(GuiGraphics graphics, int screenWidth, int py, ItemStack selectedEntity) {
        MutableComponent mutablecomponent;
        MutableComponent highlightTip = mutablecomponent = Component.m_237119_().m_7220_(selectedEntity.m_41611_());
        int fontWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)highlightTip);
        int nx = (screenWidth - fontWidth) / 2;
        int ny = py - 19;
        int l = 255;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280509_(nx - 2, ny - 2, nx + fontWidth + 2, ny + 9 + 2, Minecraft.m_91087_().f_91066_.m_92143_(0));
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)highlightTip, nx, ny, 0xFFFFFF + (l << 24));
        RenderSystem.disableBlend();
    }

    public static void renderSlingshotPouchSlot(GuiGraphics guiGraphics, float partialTick) {
        RenderHelper.renderItemContent(guiGraphics, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    @Nullable
    private static Gui getIngameGui(boolean minecraftChanged) {
        if (ingameGui == null || minecraftChanged) {
            Gui gui;
            ingameGui = gui = Minecraft.m_91087_().f_91065_;
        }
        return ingameGui;
    }

    static {
        TEXTURE = new ResourceLocation("just_a_slingshot", "textures/gui/hud/pouch.png");
        TEXTURE_SELECT = new ResourceLocation("just_a_slingshot", "textures/gui/hud/pouch_selected.png");
    }
}

