/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.void_tentacle;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidTentacle
extends LivingEntity
implements GeoEntity,
AntiMagicSusceptible {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float damage;
    private int age;
    private final RawAnimation ANIMATION_RISE = RawAnimation.begin().thenPlay("rise");
    private final RawAnimation ANIMATION_RETREAT = RawAnimation.begin().thenPlay("retreat");
    private final RawAnimation ANIMATION_FLAIL = RawAnimation.begin().thenPlay("flail");
    private final RawAnimation ANIMATION_FLAIL2 = RawAnimation.begin().thenPlay("flail2");
    private final RawAnimation ANIMATION_FLAIL3 = RawAnimation.begin().thenPlay("flail3");
    private final RawAnimation ANIMATION_IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimationController controller = new AnimationController((GeoAnimatable)this, "void_tentacle_controller", 20, this::animationPredicate);
    private final AnimationController riseController = new AnimationController((GeoAnimatable)this, "void_tentacle_rise_controller", 0, this::risePredicate);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public VoidTentacle(EntityType<? extends VoidTentacle> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public VoidTentacle(Level level, LivingEntity owner, float damage) {
        this((EntityType<? extends VoidTentacle>)((EntityType)EntityRegistry.SCULK_TENTACLE.get()), level);
        this.setOwner(owner);
        this.setDamage(damage);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.age > 300) {
                this.m_146870_();
            } else if (this.age < 280 && this.age % 20 == 0) {
                this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.2)).forEach(this::dealDamage);
                if (Utils.random.m_188501_() < 0.15f) {
                    this.m_5496_((SoundEvent)SoundRegistry.VOID_TENTACLES_AMBIENT.get(), 1.5f, 0.5f + Utils.random.m_188501_() * 0.65f);
                }
            }
            if (this.age == 260 && Utils.random.m_188501_() < 0.3f) {
                this.m_5496_((SoundEvent)SoundRegistry.VOID_TENTACLES_LEAVE.get(), 2.0f, 1.0f);
            }
        } else if (this.age < 280 && Utils.random.m_188501_() < 0.15f) {
            this.f_19853_.m_7106_(ParticleHelper.VOID_TENTACLE_FOG, this.m_20185_() + Utils.getRandomScaled(0.5), this.m_20186_() + Utils.getRandomScaled(0.5) + (double)0.2f, this.m_20189_() + Utils.getRandomScaled(0.5), Utils.getRandomScaled(2.0), (double)(-this.f_19796_.m_188501_() * 0.5f), Utils.getRandomScaled(2.0));
        }
        ++this.age;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean dealDamage(LivingEntity target) {
        return false;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.age = pCompound.m_128451_("Age");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.singleton(ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.age);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    @Override
    public void onAntiMagic(MagicData playerMagicData) {
        MagicManager.spawnParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 50, 0.2, 1.25, 0.2, 0.08, false);
        this.m_146870_();
    }

    private PlayState animationPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.age > 220 && Utils.random.m_188501_() < 0.04f) {
            controller.setAnimation(this.ANIMATION_RETREAT);
        } else if (controller.getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(this.ANIMATION_IDLE);
        }
        return PlayState.CONTINUE;
    }

    private PlayState risePredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.age < 10) {
            controller.setAnimation(this.ANIMATION_RISE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.riseController});
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

