/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.spells;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.SpellContainer;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public interface ISpellContainer
extends INBTSerializable<CompoundTag> {
    @NotNull
    public SpellData[] getAllSpells();

    @NotNull
    public List<SpellData> getActiveSpells();

    public int getMaxSpellCount();

    public void setMaxSpellCount(int var1);

    public int getActiveSpellCount();

    public int getNextAvailableIndex();

    public boolean mustEquip();

    public boolean spellWheel();

    @NotNull
    public SpellData getSpellAtIndex(int var1);

    public int getIndexForSpell(AbstractSpell var1);

    public boolean addSpellAtIndex(AbstractSpell var1, int var2, int var3, boolean var4, ItemStack var5);

    public boolean addSpell(AbstractSpell var1, int var2, boolean var3, ItemStack var4);

    public boolean removeSpellAtIndex(int var1, ItemStack var2);

    public boolean removeSpell(AbstractSpell var1, ItemStack var2);

    public boolean isEmpty();

    public void save(ItemStack var1);

    public static boolean isSpellContainer(ItemStack itemStack) {
        if (itemStack != null && itemStack.m_41613_() >= 1) {
            CompoundTag tag = itemStack.m_41783_();
            return tag != null && (tag.m_128441_("ISB_Spells") || SpellContainer.isLegacyTagFormat(tag));
        }
        return false;
    }

    public static ISpellContainer create(int maxSpells, boolean addsToSpellWheel, boolean mustBeEquipped) {
        return new SpellContainer(maxSpells, addsToSpellWheel, mustBeEquipped);
    }

    public static ISpellContainer createScrollContainer(AbstractSpell spell, int spellLevel, ItemStack itemStack) {
        ISpellContainer spellContainer = ISpellContainer.create(1, false, false);
        spellContainer.addSpellAtIndex(spell, spellLevel, 0, true, itemStack);
        return spellContainer;
    }

    public static ISpellContainer createImbuedContainer(AbstractSpell spell, int spellLevel, ItemStack itemStack) {
        ISpellContainer spellContainer = ISpellContainer.create(1, true, itemStack.m_41720_() instanceof ArmorItem || itemStack.m_41720_() instanceof ICurioItem);
        spellContainer.addSpellAtIndex(spell, spellLevel, 0, true, itemStack);
        return spellContainer;
    }

    public static ISpellContainer get(ItemStack itemStack) {
        return new SpellContainer(itemStack);
    }

    public static ISpellContainer getOrCreate(ItemStack itemStack) {
        if (ISpellContainer.isSpellContainer(itemStack)) {
            return new SpellContainer(itemStack);
        }
        return new SpellContainer(1, true, false);
    }
}

