/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;

public abstract class LayerPiece
extends Piece {
    protected final TextureAtlas armorTrimsAtlas = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_);

    protected abstract HumanoidModel<LivingEntity> getModel();

    protected static HumanoidModel<LivingEntity> buildDilatedModel(float dilation) {
        return LayerPiece.buildDilatedModel(dilation, dilation);
    }

    protected static HumanoidModel<LivingEntity> buildDilatedModel(float dilation, float headDilation) {
        return new HumanoidModel(LayerDefinition.m_171565_((MeshDefinition)LayerPiece.getHeadAdjustedModelData(new CubeDeformation(dilation), new CubeDeformation(headDilation), 0.0f), (int)64, (int)32).m_171564_());
    }

    public static MeshDefinition getHeadAdjustedModelData(CubeDeformation dilation, CubeDeformation headDilation, float pivotOffsetY) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headDilation), PartPose.m_171419_((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headDilation.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)-5.0f, (float)(2.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)5.0f, (float)(2.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)-1.9f, (float)(12.0f + pivotOffsetY), (float)0.0f));
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)1.9f, (float)(12.0f + pivotOffsetY), (float)0.0f));
        return modelData;
    }

    protected void renderTrim(ArmorMaterial material, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorTrim trim, HumanoidModel<LivingEntity> model, boolean leggings) {
        TextureAtlasSprite sprite = this.armorTrimsAtlas.m_118316_(leggings ? trim.m_267774_(material) : trim.m_267606_(material));
        VertexConsumer vertexConsumer = sprite.m_118381_(vertexConsumers.m_6299_(Sheets.m_266442_()));
        model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public <T extends LivingEntity, A extends HumanoidModel<T>> void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, A armorModel) {
        Item item = itemStack.m_41720_();
        if (item instanceof ExtendedArmorItem) {
            ExtendedArmorItem armorItem = (ExtendedArmorItem)item;
            armorModel.m_102872_(this.getModel());
            this.setVisible(this.getModel(), armorSlot);
            if (this.isColored()) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), red, green, blue, false);
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), 1.0f, 1.0f, 1.0f, true);
            } else {
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), 1.0f, 1.0f, 1.0f, false);
            }
            ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent(trim -> this.renderTrim(armorItem.getMaterial(), matrices, vertexConsumers, light, (ArmorTrim)trim, this.getModel(), armorSlot == EquipmentSlot.LEGS));
        }
    }
}

