/*
 * Decompiled with CFR 0.152.
 */
package de.bene2212.holdmyitems.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.bene2212.holdmyitems.util.HoldMyItemsTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private float smoothSwing = 0.0f;
    private float rotationSwing = 0.0f;
    private float lastYaw = 0.0f;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"render*"}, at={@At(value="TAIL")})
    private void injectLanternRendering(AbstractClientPlayer player, float f, float f1, PoseStack poseStack, MultiBufferSource buffer, int light, CallbackInfo ci) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!stack.m_204117_(HoldMyItemsTags.LANTERNS)) {
            return;
        }
        float swingMultiplier = player.m_20096_() ? 1.0f : 0.2f;
        poseStack.m_85836_();
        float bodyYaw = Mth.m_14179_((float)f1, (float)player.f_20884_, (float)player.f_20883_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-bodyYaw));
        ((PlayerModel)this.m_7200_()).f_102811_.m_104299_(poseStack);
        if (!player.m_6047_()) {
            poseStack.m_252880_(-0.32f, -0.18f, 0.65f);
        } else {
            poseStack.m_252880_(-0.32f, -0.18f, 0.25f);
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(85.0f));
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        float limbSwing = player.f_267362_.m_267756_();
        float limbSwingAmount = player.f_267362_.m_267731_();
        float targetSwing = Mth.m_14031_((float)((limbSwing - 0.1f) * 0.8f)) * limbSwingAmount * 8.0f * swingMultiplier;
        float smoothingSpeed = 0.1f;
        this.smoothSwing += (targetSwing - this.smoothSwing) * smoothingSpeed;
        float currentYaw = player.m_146908_();
        float yawDelta = Mth.m_14177_((float)(currentYaw - this.lastYaw));
        this.lastYaw = currentYaw;
        float rotationInfluence = -yawDelta * 2.0f;
        this.rotationSwing += (rotationInfluence - this.rotationSwing) * 0.2f;
        float combinedSwing = this.smoothSwing + this.rotationSwing;
        poseStack.m_252880_(0.0f, 0.4f, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(combinedSwing));
        poseStack.m_252880_(0.0f, -0.4f, 0.0f);
        Block block = blockItem.m_40614_();
        BlockState state = block.m_49966_();
        if (state.m_61138_((Property)LanternBlock.f_153459_)) {
            state = (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false));
        }
        Minecraft.m_91087_().m_91289_().m_110912_(state, poseStack, buffer, light, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }
}

