/*
 * Decompiled with CFR 0.152.
 */
package de.bene2212.holdmyitems.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class HoldMyItemsClientConfig {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec.DoubleValue ANIMATION_SPEED;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SWIMMING_ANIM;
    public static final ForgeConfigSpec.IntValue SWING_SPEED;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CLIMB_AND_CRAWL;
    public static final ForgeConfigSpec.DoubleValue VIEWMODEL_X_OFFSET;
    public static final ForgeConfigSpec.DoubleValue VIEWMODEL_Y_OFFSET;
    public static final ForgeConfigSpec.DoubleValue VIEWMODEL_Z_OFFSET;
    public static final ForgeConfigSpec.BooleanValue MB3D_COMPAT;

    public static float getXOffset() {
        return ((Double)VIEWMODEL_X_OFFSET.get()).floatValue();
    }

    public static float getYOffset() {
        return ((Double)VIEWMODEL_Y_OFFSET.get()).floatValue();
    }

    public static float getZOffset() {
        return ((Double)VIEWMODEL_Z_OFFSET.get()).floatValue();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("animations");
        ANIMATION_SPEED = builder.comment("Choose your preferred animation speed (1-15)").defineInRange("animationSpeed", 8.0, 1.0, 15.0);
        ENABLE_SWIMMING_ANIM = builder.comment("Enable or disable swimming animation").define("enableSwimmingAnimation", true);
        SWING_SPEED = builder.comment("Swing animation speed (6-12)").defineInRange("swingSpeed", 9, 6, 12);
        ENABLE_CLIMB_AND_CRAWL = builder.comment("Enable or disable climb and crawl animation").define("enableclimbandcrawlAnimation", true);
        builder.pop();
        builder.push("positions");
        VIEWMODEL_X_OFFSET = builder.comment("Viewmodel X Offset").defineInRange("viewmodelXOffset", 0.0, -10.0, 10.0);
        VIEWMODEL_Y_OFFSET = builder.comment("Viewmodel Y Offset").defineInRange("viewmodelYOffset", 0.0, -10.0, 10.0);
        VIEWMODEL_Z_OFFSET = builder.comment("Viewmodel Z Offset").defineInRange("viewmodelZOffset", 0.0, -10.0, 10.0);
        builder.pop();
        builder.push("misc");
        MB3D_COMPAT = builder.comment("Enable MB3D compatibility mode").define("mb3DCompat", false);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }
}

