/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.client;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.customization.world.LastWorldHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastWorldOrServerPlaceholder
extends Placeholder {
    public LastWorldOrServerPlaceholder() {
        super("last_world_server");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String type = dps.values.get("type");
        if (type != null) {
            if (type.equals("both")) {
                return LastWorldHandler.getLastWorld();
            }
            if (type.equals("server") && LastWorldHandler.isLastWorldServer()) {
                return LastWorldHandler.getLastWorld();
            }
            if (type.equals("world") && !LastWorldHandler.isLastWorldServer()) {
                return LastWorldHandler.getLastWorld();
            }
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.last_world_server", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.last_world_server.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.client", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("type", "both");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

