/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final Entity entity;
    private final float scale;

    protected EntityEmiStack(@Nullable Entity entity, float scale) {
        this.entity = entity;
        this.scale = scale;
    }

    public static EntityEmiStack of(@Nullable Entity entity) {
        return EntityEmiStack.ofScaled(entity, 8.0f);
    }

    public static EntityEmiStack ofScaled(@Nullable Entity entity, float scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = EntityEmiStack.ofScaled(this.entity, this.scale);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        if (this.entity != null) {
            MouseHandler mouse = Minecraft.m_91087_().f_91067_;
            Entity entity = this.entity;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityEmiStack.drawLivingEntity(draw, x, y, this.scale, (float)mouse.m_91589_(), (float)mouse.m_91594_(), living);
            } else {
                EntityEmiStack.drawEntity(draw, x, y, this.scale, (float)mouse.m_91589_(), (float)mouse.m_91594_(), this.entity);
            }
        }
    }

    public CompoundTag getNbt() {
        return Optional.ofNullable(this.entity).map(e -> e.m_20240_(new CompoundTag())).orElse(new CompoundTag());
    }

    public Object getKey() {
        return this.entity;
    }

    public ResourceLocation getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_());
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        if (this.entity != null) {
            String mod;
            list.addAll(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::m_169948_).toList());
            Entity entity = this.entity;
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                mod = EmiUtil.getModName((String)BuiltInRegistries.f_256735_.m_7981_((Object)villager.m_7141_().m_35571_()).m_135827_());
            } else {
                mod = EmiUtil.getModName((String)BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_()).m_135827_());
            }
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)mod, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
            if (!this.getRemainder().isEmpty()) {
                list.add((ClientTooltipComponent)new RemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public Component getName() {
        return this.entity != null ? this.entity.m_7755_() : EmiPort.literal((String)"yet another missingno");
    }

    public static void drawLivingEntity(GuiGraphics ctx, int x, int y, float size, float mouseX, float mouseY, LivingEntity entity) {
        float mouseX0 = (float)(ctx.m_280182_() + 51) - mouseX;
        float mouseY0 = (float)(ctx.m_280206_() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, (Entity)entity);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
    }

    public static void drawEntity(GuiGraphics ctx, int x, int y, float size, float mouseX, float mouseY, Entity entity) {
        float mouseX0 = (float)(ctx.m_280182_() + 51) - mouseX;
        float mouseY0 = (float)(ctx.m_280206_() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, entity);
        entity.m_146922_(i);
        entity.m_146926_(j);
    }

    private static void draw(GuiGraphics ctx, int x, int y, float size, Quaternionf quaternion, @Nullable Quaternionf quaternion2, Entity entity) {
        ctx.m_280168_().m_85836_();
        ctx.m_280168_().m_85837_((double)(x + 8), (double)(y + 16), 50.0);
        ctx.m_280168_().m_252931_(new Matrix4f().scaling(size, size, -size));
        ctx.m_280168_().m_252781_(quaternion);
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        if (quaternion2 != null) {
            quaternion2.conjugate();
            dispatcher.m_252923_(quaternion2);
        }
        dispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ctx.m_280168_(), (MultiBufferSource)ctx.m_280091_(), 0xF000F0));
        ctx.m_280262_();
        dispatcher.m_114468_(true);
        ctx.m_280168_().m_85849_();
        Lighting.m_84931_();
    }
}

